#ifndef GPIO_H
#define GPIO_H

#include <xdc/std.h>  					// Mandatory - have to include first, for BIOS types
#include <xdc/runtime/System.h>
#include <xdc/runtime/Error.h>                          // Errors are our specialty.
#include <xdc/runtime/Log.h>				// Needed for any Log_info() call

#include <ti/sysbios/BIOS.h> 				// Mandatory - for BIOS_start() and friends.
#include <xdc/cfg/global.h> 				// Header file for statically defined objects/handles

#include <stdint.h>

// CSL - Chip support library. A suffix "R" means register (C macros based). The alternative is "C functions".
//       CSL can also work without SYS/BIOS, but the hardware interrupts are not compatible. check
//       http://processors.wiki.ti.com/index.php/Chip_support_library
#include <ti/csl/csl_gpio.h>
#include <ti/csl/csl_gpioAux.h>

#include "common.h"

extern CSL_GpioHandle gpio_init( uint32_t pin, uint8_t* bank_number );
extern CSL_GpioHandle gpio_config_output_pin( uint32_t pin );
extern CSL_GpioHandle gpio_config_input_pin( uint32_t pin );
extern CSL_GpioHandle gpio_pin_clear( uint32_t pin );
extern CSL_GpioHandle gpio_pin_set( uint32_t pin );
extern PinStatus_T gpio_read_pin( CSL_GpioHandle gpio, uint32_t pin );
extern CSL_GpioHandle init_gpio_pin_irq( uint32_t pin );
extern CSL_GpioHandle gpio_config_irq_pin( uint32_t pin, EdgeType_T edge_type );
extern void config_gpio_irq( int int_vec, int host_int_num, int32_t gpio_pin, void (*isr)(UArg), EdgeType_T et );

#endif // GPIO_H
