
#include <xdc/std.h>                    // Mandatory - have to include first, for BIOS types
#include <xdc/runtime/Error.h>                          // Errors are our specialty.
#include <xdc/runtime/Log.h>                // Needed for any Log_info() call

#include <ti/sysbios/BIOS.h>                // Mandatory - for BIOS_start() and friends.
#include <xdc/cfg/global.h>                 // Header file for statically defined objects/handles
#include <ti/sysbios/knl/Task.h>                        // For tasks.
#include <ti/sysbios/hal/Hwi.h>                         // Interrupts.

#include <stdio.h>
#include <stdint.h>

#include "edma3.h"
#include "semaphore.h"

Hwi_Params hwi_params;

Error_Block error_block;
int8_t error_flag = 0;
char* error_msg = "We don't plan time for errors";

#define BUFFER_SIZE 32
int16_t source_buffer[BUFFER_SIZE];      // Source buffer for DMA transfer
int16_t destination_buffer[BUFFER_SIZE]; // Destionation buffer for DMA transfer

void init_buffers(void)
{
  int16_t buffer_size = BUFFER_SIZE, i = 0;
  for( i = 0; i < buffer_size; ++i )
  {
      source_buffer[i] = 0xAD;
      destination_buffer[i] = 0;
  }
}

Void taskFxn(UArg a0, UArg a1)
{
  Log_info0( "Entering taskFxn()\n" );
  while( 1 )
  {
    Task_sleep( 10 );
    init_buffers();
    EDMA_T edma_instance = { NULL,                 // edma: handle to be returned by our edma_config function
                             EDMA_HW_EVENT_TINT1L, // channel: use TINT1L (enum found in edma3.h)
                             EDMA3_DRV_TCC_ANY };  // tcc: use ANY TCC (when sync'ing to a peripheral, you need to pick a specific channel)
    edma_config( &edma_instance );
  }

  // Log_info0( "Leaving taskFxn().\n" );
}

Int main( void )
{
  Log_info0( "Entering main()\n" );

  init_semaphores();
  Hwi_enable();
  BIOS_start(); // Never returns.

  Log_info0( "Leaving main()\n" );

  return 0;
}
