
#include "semaphore.h"

//var semaphore0Params = new Semaphore.Params();
//semaphore0Params.instance.name = "OsSem";
//Program.global.OsSem = Semaphore.create(1, semaphore0Params);
//var semaphore1Params = new Semaphore.Params();
//semaphore1Params.instance.name = "wait_for_completion";
//Program.global.wait_for_completion = Semaphore.create(null, semaphore1Params);

static Error_Block error_block;

static Semaphore_Params os_sem_parms,
                        wait_for_completion_sem_parms;
Semaphore_Handle os_sem,
                 wait_for_completion_sem;

void init_semaphores( void )
{
  Error_init( &error_block );
  Semaphore_Params_init( &os_sem_parms );
  os_sem_parms.instance->name = "os_sem";
  os_sem = Semaphore_create( 1, &os_sem_parms, &error_block );
  if( Error_check( &error_block ) )
  {
      Log_info0( Error_getMsg( &error_block ) );
      return;
  }

  Semaphore_Params_init( &wait_for_completion_sem_parms );
  wait_for_completion_sem_parms.instance->name = "wait_for_completion_sem";
  wait_for_completion_sem = Semaphore_create( 0, &wait_for_completion_sem_parms, &error_block );
  if( Error_check( &error_block ) )
  {
      Log_info0( Error_getMsg( &error_block ) );
      return;
  }
}
