// AIC3106.h

#ifndef AIC3106_H_INCLUDED
#define AIC3106_H_INCLUDED

// PAGE 0 registers
#define AIC3106_REG0_PAGESELECT     		0
#define AIC3106_REG0_RESET         		    1
#define AIC3106_REG0_CODEC_SAMPLE_RATE		2
#define AIC3106_REG0_PLL_A					3
#define AIC3106_REG0_PLL_B					4
#define AIC3106_REG0_PLL_C					5
#define AIC3106_REG0_PLL_D					6
#define AIC3106_REG0_CODEC_DATAPATH			7
#define AIC3106_REG0_SERIAL_DATA_INTFC_A	8
#define AIC3106_REG0_SERIAL_DATA_INTFC_B	9
#define AIC3106_REG0_SERIAL_DATA_INTFC_C	10
#define AIC3106_REG0_OVERFLOW_FLAG			11
#define AIC3106_REG0_DIG_FILTER_CNTL		12
#define AIC3106_REG0_HEADSET_BUTTON_PRESS_A	13
#define AIC3106_REG0_HEADSET_BUTTON_PRESS_B	14
#define AIC3106_REG0_LEFT_ADC_PGA			15
#define AIC3106_REG0_RIGHT_ADC_PGA			16
#define AIC3106_REG0_MIC3LR_LEFT_ADC		17
#define AIC3106_REG0_MIC3LR_RIGHT_ADC		18
#define AIC3106_REG0_LINE1L_LEFT_ADC		19
#define AIC3106_REG0_LINE2L_LEFT_ADC		20
#define AIC3106_REG0_LINE1R_LEFT_ADC		21
#define AIC3106_REG0_LINE1R_RIGHT_ADC		22
#define AIC3106_REG0_LINE2R_RIGHT_ADC		23
#define AIC3106_REG0_LINE1L_RIGHT_ADC		24
#define AIC3106_REG0_MICBIAS				25
#define AIC3106_REG0_LEFT_AGC_CNTL_A		26
#define AIC3106_REG0_LEFT_AGC_CNTL_B		27
#define AIC3106_REG0_LEFT_AGC_CNTL_C		28
#define AIC3106_REG0_RIGHT_AGC_CNTL_A		29
#define AIC3106_REG0_RIGHT_AGC_CNTL_B		30
#define AIC3106_REG0_RIGHT_AGC_CNTL_C		31
#define AIC3106_REG0_LEFT_AGC_GAIN			32
#define AIC3106_REG0_RIGHT_AGC_GAIN			33
#define AIC3106_REG0_LEFT_AGC_NOISE_GATE	34
#define AIC3106_REG0_RIGHT_AGC_NOISE_GATE	35
#define AIC3106_REG0_ADC_FLAG				36
#define AIC3106_REG0_DAC_POWER_OUTPUT_DRVR	37
#define AIC3106_REG0_HI_POWER_OUTPUT_DRVR	38
#define AIC3106_REG0_RESERVED_39			39
#define AIC3106_REG0_HI_POWER_OUTPUT_CNTL	40
#define AIC3106_REG0_DAC_OUTPUT_SWITCHING	41
#define AIC3106_REG0_OUTPUT_POP_REDUCTION	42
#define AIC3106_REG0_LEFT_DAC_VOLUME		43
#define AIC3106_REG0_RIGHT_DAC_VOLUME		44
#define AIC3106_REG0_LINE2L_TO_HPLOUT		45
#define AIC3106_REG0_PGA_L_TO_HPLOUT		46
#define AIC3106_REG0_DAC_L1_TO_HPLOUT		47
#define AIC3106_REG0_LINE2R_TO_HPLOUT		48
#define AIC3106_REG0_PGA_R_TO_HPLOUT		49
#define AIC3106_REG0_DAC_R1_TO_HPLOUT		50
#define AIC3106_REG0_HPLOUT_OUTPUT_LEVEL	51
#define AIC3106_REG0_LINE2L_TO_HPLCOM		52
#define AIC3106_REG0_PGA_L_TO_HPLCOM		53
#define AIC3106_REG0_DAC_L1_TO_HPLCOM		54
#define AIC3106_REG0_LINE2R_TO_HPLCOM		55
#define AIC3106_REG0_PGA_R_TO_HPLCOM		56
#define AIC3106_REG0_DAC_R1_TO_HPLCOM		57
#define AIC3106_REG0_HPLCOM_OUTPUT_LEVEL	58
#define AIC3106_REG0_LINE2L_TO_HPROUT		59
#define AIC3106_REG0_PGA_L_TO_HPROUT		60
#define AIC3106_REG0_DAC_L1_TO_HPROUT		61
#define AIC3106_REG0_LINE2R_TO_HPROUT		62
#define AIC3106_REG0_PGA_R_TO_HPROUT		63
#define AIC3106_REG0_DAC_R1_TO_HPROUT		64
#define AIC3106_REG0_HPROUT_OUTPUT_LEVEL	65
#define AIC3106_REG0_LINE2L_TO_HPRCOM		66
#define AIC3106_REG0_PGA_L_TO_HPRCOM		67
#define AIC3106_REG0_DAC_L1_TO_HPRCOM		68
#define AIC3106_REG0_LINE2R_TO_HPRCOM		69
#define AIC3106_REG0_PGA_R_TO_HPRCOM		70
#define AIC3106_REG0_DAC_R1_TO_HPRCOM		71
#define AIC3106_REG0_HPRCOM_OUTPUT_LEVEL	72
#define AIC3106_REG0_LINE2L_TO_MONO_LOP		73
#define AIC3106_REG0_PGA_L_TO_MONO_LOP		74
#define AIC3106_REG0_DAC_L1_TO_MONO_LOP		75
#define AIC3106_REG0_LINE2R_TO_MONO_LOP		76
#define AIC3106_REG0_PGA_R_TO_MONO_LOP		77
#define AIC3106_REG0_DAC_R1_TO_MONO_LOP		78
#define AIC3106_REG0_MONO_LOP_OUTPUT_LEVEL	79
#define AIC3106_REG0_LINE2L_TO_LEFT_LOP		80
#define AIC3106_REG0_PGA_L_TO_LEFT_LOP		81
#define AIC3106_REG0_DAC_L1_TO_LEFT_LOP		82
#define AIC3106_REG0_LINE2R_TO_LEFT_LOP		83
#define AIC3106_REG0_PGA_R_TO_LEFT_LOP		84
#define AIC3106_REG0_DAC_R1_TO_LEFT_LOP		85
#define AIC3106_REG0_LEFT_LOP_OUTPUT_LEVEL	86
#define AIC3106_REG0_LINE2L_TO_RIGHT_LOP	87
#define AIC3106_REG0_PGA_L_TO_RIGHT_LOP		88
#define AIC3106_REG0_DAC_L1_TO_RIGHT_LOP	89
#define AIC3106_REG0_LINE2R_TO_RIGHT_LOP	90
#define AIC3106_REG0_PGA_R_TO_RIGHT_LOP		91
#define AIC3106_REG0_DAC_R1_TO_RIGHT_LOP	92
#define AIC3106_REG0_RIGHT_LOP_OUTPUT_LEVEL	93
#define AIC3106_REG0_MODULE_POWER_STATUS	94
#define AIC3106_REG0_OUTPUT_SHORT_CIRCUIT	95
#define AIC3106_REG0_STICKY_IRQ_FLAGS		96
#define AIC3106_REG0_REALTIME_IRQ_FLAGS		97
#define AIC3106_REG0_GPIO1_CONTROL			98
#define AIC3106_REG0_GPIO2_CONTROL			99
#define AIC3106_REG0_ADDNL_GPIO_CONTROL_A	100
#define AIC3106_REG0_ADDNL_GPIO_CONTROL_B	101
#define AIC3106_REG0_CLOCK_GEN_CONTROL		102
#define AIC3106_REG0_LEFT_AGC_NEW_ATTACK	103
#define AIC3106_REG0_LEFT_AGC_NEW_DECAY		104
#define AIC3106_REG0_RIGHT_AGC_NEW_ATTACK	105
#define AIC3106_REG0_RIGHT_AGC_NEW_DECAY	106
#define AIC3106_REG0_NEW_ADC_DIGITAL_PATH	107
#define AIC3106_REG0_PASSIVE_ANALOG_BYPASS	108
#define AIC3106_REG0_DAC_QUIESCENT_CURRENT	109
#define AIC3106_REG0_RESERVED110			110
#define AIC3106_REG0_RESERVED127			127

// PAGE 1 registers
#define AIC3106_REG1_PAGESELECT    			128

// sample rate settings based on 24.576MHz MCLK, not using PLL
// Fs(ref) = 24.576MHz / (128 * Q)
// Fs(ADC/DAC) = Fs(ref) / N(ADC/DAC)
#define REG_PLL_A_96KHZ						0x10	// PLL disabled, Q = 2
#define REG_CODEC_SAMPLE_RATE_96KHZ			0x00	// N(ADC/DAC) = 1
#define REG_PLL_A_48KHZ						0x20	// PLL disabled, Q = 4
#define REG_CODEC_SAMPLE_RATE_48KHZ			0x00	// N(ADC/DAC) = 1
#define REG_PLL_A_32KHZ						0x30	// PLL disabled, Q = 6
#define REG_CODEC_SAMPLE_RATE_32KHZ			0x00	// N(ADC/DAC) = 1
#define REG_PLL_A_24KHZ						0x40	// PLL disabled, Q = 8
#define REG_CODEC_SAMPLE_RATE_24KHZ			0x00	// N(ADC/DAC) = 1
#define REG_PLL_A_16KHZ						0x60	// PLL disabled, Q = 12
#define REG_CODEC_SAMPLE_RATE_16KHZ			0x00	// N(ADC/DAC) = 1
#define REG_PLL_A_12KHZ						0x40	// PLL disabled, Q = 8
#define REG_CODEC_SAMPLE_RATE_12KHZ			0x22	// N(ADC/DAC) = 2
#define REG_PLL_A_8KHZ						0x60	// PLL disabled, Q = 12
#define REG_CODEC_SAMPLE_RATE_8KHZ			0x22	// N(ADC/DAC) = 2


#endif
