///////////////////////////////////////////////////////////////////////
// Filename: ISRs.c
//
// Interrupt service routine for codec data transmit/receive
//
///////////////////////////////////////////////////////////////////////

#include "DSP_Config.h" 
  
// Data is received as 2 16-bit words (left/right) packed into one
// 32-bit word.  The union allows the data to be accessed as a single 
// entity when transferring to and from the serial port, but still be 
// able to manipulate the left and right channels independently.

#define LEFT  0
#define RIGHT 1

volatile union {
	Uint32 UINT;
	Int16 Channel[2];
} CodecDataIn, CodecDataOut;



interrupt void Codec_ISR()
///////////////////////////////////////////////////////////////////////
// Purpose:   Codec interface interrupt service routine  
// Input:     None
// Returns:   Nothing
// Calls:     CheckForOverrun, ReadCodecData, WriteCodecData
///////////////////////////////////////////////////////////////////////
{                    
	/*  local variables here...                                        */
	float xLeft, xRight, yLeft, yRight;
	unsigned char temp_char;
	//extern Int16 fsk_inp[60000];

	extern int index_6250;
	extern int index_5555;
	extern int index_5000;

	extern int index;

	extern float sin_6250[192];
	extern float cos_6250[192];
	extern float sin_5555[216];
	extern float cos_5555[216];
	extern float sin_5000[240];
	extern float cos_5000[240];

	extern float temp_cos6250;
	extern float temp_sin6250;
	extern float temp_cos5555;
	extern float temp_sin5555;
	extern float temp_cos5000;
	extern float temp_sin5000;


	extern int index_6250;
	extern int index_5555;
	extern int index_5000;

	extern float sement[50000];
	extern int index_sement;

	extern int pilot_end_detected;
	extern int when_end_detected;

	extern int index_66_detected;
	extern int pilot_exist;
	extern int index_detected;

	extern int tone_ada_di66cyc;

	extern float b[3];
	extern float a[3];

	extern unsigned short vane_load;

 	if(CheckForOverrun())					// overrun error occurred (i.e. halted DSP)
		return;								// so serial port is reset to recover

  	CodecDataIn.UINT = ReadCodecData();		// get input data samples
	
  	//mic on left ch
	xLeft  = CodecDataIn.Channel[ LEFT];
	xRight = CodecDataIn.Channel[ RIGHT];
	yLeft  = xLeft;

/*

	if (never_repeat_again == 0)
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		if (index_6250 == 192)
			index_6250 = 0;
		if (index_5555 == 216)
			index_5555 = 0;
		if (index_5000 == 240)
			index_5000= 0;

		//generate I & Q
		temp_sin6250 = yLeft * sin_6250[index_6250];
		temp_cos6250 = yLeft * cos_6250[index_6250];
		temp_sin5555 = yLeft * sin_5555[index_5555];
		temp_cos5555 = yLeft * cos_5555[index_5555];

		temp_sin5000 = yLeft * sin_5000[index_5000];
		temp_cos5000 = yLeft * cos_5000[index_5000];


		//filter out double freq to leave out  DC
		//IIR 2nd order - brute force implementation
		//a & b are obtained from scilab : myfilter = iir(2,'lp','butt',[0.005 0],[]);
		//filtered_iir_Q_6K4 = filter ([ 0.0002414 0.0004827 0.0002414], [1 -1.9555782 0.9565437], Q_6K4);
		//direct ( cascade) form II is used , in this case cascade = 1 . so actally it's Direct Form II only

		//sin6250 :
		wn_temp_sin6250 = temp_sin6250 - a[1]*w_temp_sin6250[0] - a[2]*w_temp_sin6250[1];
		yn_temp_sin6250 = b[0]*wn_temp_sin6250 + b[1]*w_temp_sin6250[0] + b[2]*w_temp_sin6250[1];

		w_temp_sin6250[1] = w_temp_sin6250[0];
		w_temp_sin6250[0] = wn_temp_sin6250;
		temp_out_temp_sin6250 = yn_temp_sin6250;


		//cos6250 :
		wn_temp_cos6250 = temp_cos6250 - a[1]*w_temp_cos6250[0] - a[2]*w_temp_cos6250[1];
		yn_temp_cos6250 = b[0]*wn_temp_cos6250 + b[1]*w_temp_cos6250[0] + b[2]*w_temp_cos6250[1];

		w_temp_cos6250[1] = w_temp_cos6250[0];
		w_temp_cos6250[0] = wn_temp_cos6250;
		temp_out_temp_cos6250 = yn_temp_cos6250;

		//sin5555 :
		wn_temp_sin5555 = temp_sin5555 - a[1]*w_temp_sin5555[0] - a[2]*w_temp_sin5555[1];
		yn_temp_sin5555 = b[0]*wn_temp_sin5555 + b[1]*w_temp_sin5555[0] + b[2]*w_temp_sin5555[1];

		w_temp_sin5555[1] = w_temp_sin5555[0];
		w_temp_sin5555[0] = wn_temp_sin5555;
		temp_out_temp_sin5555 = yn_temp_sin5555;


		//cos5555 :
		wn_temp_cos5555 = temp_cos5555 - a[1]*w_temp_cos5555[0] - a[2]*w_temp_cos5555[1];
		yn_temp_cos5555 = b[0]*wn_temp_cos5555 + b[1]*w_temp_cos5555[0] + b[2]*w_temp_cos5555[1];

		w_temp_cos5555[1] = w_temp_cos5555[0];
		w_temp_cos5555[0] = wn_temp_cos5555;
		temp_out_temp_cos5555 = yn_temp_cos5555;



		//sin5000 :
		wn_temp_sin5000 = temp_sin5000 - a[1]*w_temp_sin5000[0] - a[2]*w_temp_sin5000[1];
		yn_temp_sin5000 = b[0]*wn_temp_sin5000 + b[1]*w_temp_sin5000[0] + b[2]*w_temp_sin5000[1];

		w_temp_sin5000[1] = w_temp_sin5000[0];
		w_temp_sin5000[0] = wn_temp_sin5000;
		temp_out_temp_sin5000 = yn_temp_sin5000;


		//cos5000 :
		wn_temp_cos5000 = temp_cos5000 - a[1]*w_temp_cos5000[0] - a[2]*w_temp_cos5000[1];
		yn_temp_cos5000 = b[0]*wn_temp_cos5000 + b[1]*w_temp_cos5000[0] + b[2]*w_temp_cos5000[1];

		w_temp_cos5000[1] = w_temp_cos5000[0];
		w_temp_cos5000[0] = wn_temp_cos5000;
		temp_out_temp_cos5000 = yn_temp_cos5000;

		//integrate , 66 cycle for 6250hz and 73 cycle for 5555hz
		subtotal_sin6250= subtotal_sin6250 + temp_out_temp_sin6250;
		subtotal_cos6250= subtotal_cos6250 + temp_out_temp_cos6250;

		subtotal_sin5555= subtotal_sin5555 + temp_out_temp_sin5555;
		subtotal_cos5555= subtotal_cos5555 + temp_out_temp_cos5555;

		subtotal_sin5000= subtotal_sin5000 + temp_out_temp_sin5000;
		subtotal_cos5000= subtotal_cos5000 + temp_out_temp_cos5000;

		//change this ....!!!
		//sement[index_sement] = 0.00023*(( subtotal_sin6250 * subtotal_sin6250 ) + (subtotal_cos6250 * subtotal_cos6250));
		temp_integr_6250_66cyc = 0.00023*(( subtotal_sin6250 * subtotal_sin6250 ) + (subtotal_cos6250 * subtotal_cos6250));
		temp_integr_5555_66cyc = 0.00023*(( subtotal_sin5555 * subtotal_sin5555 ) + (subtotal_cos5555 * subtotal_cos5555));
		temp_integr_5000_66cyc = 0.00023*(( subtotal_sin5000 * subtotal_sin5000 ) + (subtotal_cos5000 * subtotal_cos5000));

		//sement[index_sement] = temp_out_temp_cos6250;

		index_66++;
		if (index_66 == 66 )
		{
			//		for (mmm = 0; mmm <66; mmm++)
			//			sement_integr_6250_66cyc[mmm] = temp_integr_6250_66cyc;

			//sement[index_sement + mmm] = temp_integr_6250_66cyc;

			//		for (mmm = 0; mmm <66; mmm++)
			//			sement_integr_5000_66cyc[mmm] = temp_integr_5000_66cyc;

			//for (mmm = 0; mmm < 66; mmm++)
			//{
				//sement_integr_5555_66cyc[mmm] = temp_integr_5555_66cyc;
				if (temp_integr_5000_66cyc > temp_integr_6250_66cyc)
				{
					if  (temp_integr_5000_66cyc > temp_integr_5555_66cyc)
						//sement[index_sement + mmm] = 1;
						tone_ada_di66cyc =1;
					else
						//sement[index_sement + mmm] = 0;
						tone_ada_di66cyc =0;
				}
				else
					//sement[index_sement + mmm] = 0;
					tone_ada_di66cyc =0;
			//}


			//if (sement[index_sement + 65] == 1)
			if (tone_ada_di66cyc ==1)
			{
				index_66_detected ++;
				if (index_66_detected > 110)
					pilot_exist =1 ;
			}
			else
			{
				if (pilot_exist == 1)
				{
					if (pilot_end_detected ==0 )
					{
						pilot_end_detected =1;
						never_repeat_again =1;
						when_end_detected = index_sement + 65;
						//pilot_end_detected =0;
					}
					//pilot_exist = 0 ;
				}
				else
				{
					index_detected =0;
					pilot_exist = 0 ;
					index_66_detected =0;
					//dlete this later
					//when_end_detected =0;
				}
			}

			index_66 =0;
			subtotal_sin6250 = 0;
			subtotal_cos6250 = 0;
			subtotal_sin5555 = 0;
			subtotal_cos5555 = 0;
			subtotal_sin5000 = 0;
			subtotal_cos5000 = 0;

			index_sement = index_sement + 66;
		}

//		if (index_sement >= 50000)
	//		index_sement = 0;

		index_6250++;
		index_5555++;
		index_5000++;

		if (pilot_end_detected == 1 )
		{
			//reset all variables to zero
			index_6250=0;			index_5555=0;			index_5000=0;

			index_sement = 0;

			index_detected =0;
			when_end_detected=0;

			index_66_detected =0;
			pilot_exist =0;
			index_66 =0 ;
			w_temp_sin6250[0] = 0; w_temp_sin6250[1]=0;
			w_temp_cos6250[0] =0;  w_temp_cos6250[1] =0;
			w_temp_sin5555[0] = 0; w_temp_sin5555[1] = 0;
			w_temp_cos5555[0] =0;  w_temp_cos5555[1] =0;
			w_temp_sin5000[0] =0;  w_temp_sin5000[1] =0;
			w_temp_cos5000[0] =0;  w_temp_cos5000[1] =0;
			//wn_temp_sin6250=0; wn_temp_cos6250=0; wn_temp_sin5555=0; wn_temp_cos5555=0; wn_temp_sin5000=0; wn_temp_cos5000=0; //check this ...! may not be needed !!!
			//yn_temp_sin6250=0; yn_temp_cos6250=0; yn_temp_sin5555=0; yn_temp_cos5555=0; yn_temp_sin5000=0; yn_temp_cos5000=0; //check this ...! may not be needed !!!

			//dont really need to be reset...!!!
			//temp_out_temp_sin6250=0; temp_out_temp_cos6250=0; temp_out_temp_sin5555=0; temp_out_temp_cos5555=0; temp_out_temp_sin5000=0; temp_out_temp_cos5000=0 ;
			//not necessary ....
			//temp_integr_6250_66cyc =0; temp_integr_5555_66cyc =0; temp_integr_5000_66cyc =0;

		}

	} //endif never_repeat_again ==0

	else  //never_repeat_again ==1-> 2 tones detection now...
	{
		if (index_6250 == 192)
			index_6250 = 0;
		if (index_5555 == 216)
			index_5555 = 0;

		//generate I & Q
		temp_sin6250 = yLeft * sin_6250[index_6250];
		temp_cos6250 = yLeft * cos_6250[index_6250];
		temp_sin5555 = yLeft * sin_5555[index_5555];
		temp_cos5555 = yLeft * cos_5555[index_5555];


		//filter out double freq to leave out  DC
		//IIR 2nd order - brute force implementation
		//a & b are obtained from scilab : myfilter = iir(2,'lp','butt',[0.005 0],[]);
		//filtered_iir_Q_6K4 = filter ([ 0.0002414 0.0004827 0.0002414], [1 -1.9555782 0.9565437], Q_6K4);
		//direct ( cascade) form II is used , in this case cascade = 1 . so actally it's Direct Form II only

		wn_temp_sin6250 = temp_sin6250 - a[1]*w_temp_sin6250[0] - a[2]*w_temp_sin6250[1];
		yn_temp_sin6250 = b[0]*wn_temp_sin6250 + b[1]*w_temp_sin6250[0] + b[2]*w_temp_sin6250[1];

		w_temp_sin6250[1] = w_temp_sin6250[0];
		w_temp_sin6250[0] = wn_temp_sin6250;
		temp_out_temp_sin6250 = yn_temp_sin6250;


		//cos6250 :
		wn_temp_cos6250 = temp_cos6250 - a[1]*w_temp_cos6250[0] - a[2]*w_temp_cos6250[1];
		yn_temp_cos6250 = b[0]*wn_temp_cos6250 + b[1]*w_temp_cos6250[0] + b[2]*w_temp_cos6250[1];

		w_temp_cos6250[1] = w_temp_cos6250[0];
		w_temp_cos6250[0] = wn_temp_cos6250;
		temp_out_temp_cos6250 = yn_temp_cos6250;

		//sin5555 :
		wn_temp_sin5555 = temp_sin5555 - a[1]*w_temp_sin5555[0] - a[2]*w_temp_sin5555[1];
		yn_temp_sin5555 = b[0]*wn_temp_sin5555 + b[1]*w_temp_sin5555[0] + b[2]*w_temp_sin5555[1];

		w_temp_sin5555[1] = w_temp_sin5555[0];
		w_temp_sin5555[0] = wn_temp_sin5555;
		temp_out_temp_sin5555 = yn_temp_sin5555;


		//cos5555 :
		wn_temp_cos5555 = temp_cos5555 - a[1]*w_temp_cos5555[0] - a[2]*w_temp_cos5555[1];
		yn_temp_cos5555 = b[0]*wn_temp_cos5555 + b[1]*w_temp_cos5555[0] + b[2]*w_temp_cos5555[1];

		w_temp_cos5555[1] = w_temp_cos5555[0];
		w_temp_cos5555[0] = wn_temp_cos5555;
		temp_out_temp_cos5555 = yn_temp_cos5555;


		//integrate , 66 cycle for 6250hz and 73 cycle for 5555hz
		subtotal_sin6250= subtotal_sin6250 + temp_out_temp_sin6250;
		subtotal_cos6250= subtotal_cos6250 + temp_out_temp_cos6250;

		subtotal_sin5555= subtotal_sin5555 + temp_out_temp_sin5555;
		subtotal_cos5555= subtotal_cos5555 + temp_out_temp_cos5555;



		//float subtotal_sin6250, subtotal_cos6250, subtotal_sin5555, subtotal_cos5555;

		//change this ....!!!
		//sement[index_sement] = 0.00023*(( subtotal_sin6250 * subtotal_sin6250 ) + (subtotal_cos6250 * subtotal_cos6250));
		temp_integr_6250_66cyc = 0.00023*(( subtotal_sin6250 * subtotal_sin6250 ) + (subtotal_cos6250 * subtotal_cos6250));
		temp_integr_5555_66cyc = 0.00023*(( subtotal_sin5555 * subtotal_sin5555 ) + (subtotal_cos5555 * subtotal_cos5555));
		//sement[index_sement] = temp_out_temp_cos6250;

		index_66++;
		if (index_66 == 66 )
		{
			//for (mmm = 0; mmm <66; mmm++)
			//	sement_integr_6250_66cyc[mmm] = temp_integr_6250_66cyc;
			//sement[index_sement + mmm] = temp_integr_6250_66cyc;

			for (mmm = 0; mmm <66; mmm++)
			{
			//	sement_integr_5555_66cyc[mmm] = temp_integr_5555_66cyc;
				if (temp_integr_5555_66cyc > temp_integr_6250_66cyc)
					sement[index_sement + mmm] = 1;
				else
					sement[index_sement + mmm] = 0;
			}

			index_66 =0;
			subtotal_sin6250 = 0;
			subtotal_cos6250 = 0;
			subtotal_sin5555 = 0;
			subtotal_cos5555 = 0;




			index_sement = index_sement + 66;


		}

		//index_sement = index_sement + 66;



		index_6250++;
		index_5555++;
		if (index_sement >= 30688)
		{
			//structures data and then send to uart2,
//last_buff_index 29728	//30688-960
//#define 1918step	1918
			vane_load =0;
			if (sement[last_buff_index - step_1918*12] == 0)
			{
				vane_load = vane_load | 0x0008;
			}

			if (sement[last_buff_index - step_1918*13] == 0)
			{
				vane_load = vane_load | 0x0004;
			}

			if (sement[last_buff_index - (step_1918*14)] == 0)
			{
				vane_load = vane_load | 0x0002;
			}

			if (sement[last_buff_index - (step_1918*15)] == 0)
			{
				vane_load = vane_load | 0x0001;
			}

			if (sement[last_buff_index - (step_1918*8)] == 0)
			{
				vane_load = vane_load | 0x0080;
			}

			if (sement[last_buff_index - (step_1918*89)] == 0)
			{
				vane_load = vane_load | 0x0040;
			}

			if (sement[last_buff_index - (step_1918*10)] == 0)
			{
				vane_load = vane_load | 0x0020;
			}

			if (sement[last_buff_index - (step_1918*11)] == 0)
			{
				vane_load = vane_load | 0x0010;
			}
			if (sement[last_buff_index - (step_1918*4)] == 0)
			{
				vane_load = vane_load | 0x0800;
			}
			if (sement[last_buff_index - (step_1918*5)] == 0)
			{
				vane_load = vane_load | 0x0400;
			}
			if (sement[last_buff_index - (step_1918*6)] == 0)
			{
				vane_load = vane_load | 0x0200;
			}
			if (sement[last_buff_index - (step_1918*7)] == 0)
			{
				vane_load = vane_load | 0x0100;
			}
			if (sement[last_buff_index - (step_1918*0)] == 0)
			{
				vane_load = vane_load | 0x8000;
			}
			if (sement[last_buff_index - (step_1918*1)] == 0)
			{
				vane_load = vane_load | 0x4000;
			}
			if (sement[last_buff_index - (step_1918*2)] == 0)
			{
				vane_load = vane_load | 0x2000;
			}
			if (sement[last_buff_index - (step_1918*3)] == 0)
			{
				vane_load = vane_load | 0x1000;
			}

			temp_char = vane_load & 0x000f;
			//temp_char = temp_char << 0;
			if (temp_char <= 9  )
				temp_char = temp_char+0x30;
			else
				temp_char = temp_char+0x31;
			Write_UART2(temp_char);

			temp_char = vane_load & 0x00f0;
			temp_char = temp_char >> 4;
			if (temp_char <= 9  )
				temp_char = temp_char+0x30;
			else
				temp_char = temp_char+0x31;
			Write_UART2(temp_char);

			temp_char = vane_load & 0x0f00;
			temp_char = temp_char >> 8;
			if (temp_char <= 9  )
				temp_char = temp_char+0x30;
			else
				temp_char = temp_char+0x31;
			Write_UART2(temp_char);

			temp_char = vane_load & 0xf000;
			temp_char = temp_char >> 12;
			if (temp_char <= 9  )
				temp_char = temp_char+0x30;
			else
				temp_char = temp_char+0x31;
			Write_UART2(temp_char);

			index_sement = 0;
			index_6250 = 0;			index_5555 = 0;

			w_temp_sin6250[0] = 0; w_temp_sin6250[1]=0;
			w_temp_cos6250[0] =0;  w_temp_cos6250[1] =0;
			w_temp_sin5555[0] = 0; w_temp_sin5555[1] = 0;
			w_temp_cos5555[0] =0;  w_temp_cos5555[1] =0;

			subtotal_sin6250 = 0;
			subtotal_cos6250 = 0;
			subtotal_sin5555 = 0;
			subtotal_cos5555 = 0;


		}

		//never_repeat_again =0;
	}//end of else  never_repeat_again ==1
*/

	CodecDataOut.Channel[ LEFT] = xLeft;

	//MIC IS MONO , RIGHT CH IN NOT USED !! ONLY LEFT IS USED
	CodecDataOut.Channel[RIGHT] = xRight;

	WriteCodecData(CodecDataOut.UINT);		// send output data to  port
}

//yRight = xRight;
	//yRight = 0;

//	yLeft  = xRight;
//	yRight = xLeft;

//wn = temp_sin6250 - a[1]*w[0] - a[2]*w[1];
//	wn = temp_cos5555 - a[1]*w[0] - a[2]*w[1];
//	yn = b[0]*wn + b[1]*w[0] + b[2]*w[1];
//
//	w[1] = w[0];
//	w[0] = wn;

//  temp_out = yn;



//	sement[index_sement] = temp_sin6250;
//	index_sement ++;
//
//	if (index_sement == 10000)
//		index_sement = 0;



//	fsk_inp[index] = xLeft;
//	index++;
//	if (index == 59)
//		index =0;

