import  gen_json 
import  json_to_c
import os
import subprocess

def main():
    try:
        os.makedirs('build', exist_ok=True)  
        print(f"Directory 'build' created successfully.")
    except OSError as e:
        print(f"Error creating directory '{directory_path}': {e}")
    print("Welcome to Key Ring Generator!")
    gen_json.generate_json()
    json_to_c.generate_c_file()

  
    num_asymmetric_keys = gen_json.num_asymmetric_keys  
    num_symmetric_keys = gen_json.num_symmetric_keys     
    print(f"num_asymmetric_keys: {num_asymmetric_keys}")
    print(f"num_symmetric_keys: {num_symmetric_keys}")
  
    current_dir = os.getcwd()

    
    command = [
        "x509CertificateGen.sh",
        "-b", os.path.join(current_dir, "build/keyring_data.bin"),
        "-o", os.path.join(current_dir, "build/keyring_blob.bin"),
        "-c", "R5",
        "-l", "0x41C00100",
        "-k", os.path.join(current_dir, "k3_dev_mpk.pem"),
        "-x", str(num_asymmetric_keys),  
        "-z", str(num_symmetric_keys)   
    ]

    
    try:
        result = subprocess.run(command, check=True, capture_output=True, text=True)
        print(result.stdout)  
    except subprocess.CalledProcessError as e:
        print(f"Error running x509CertificateGen.sh: {e}")
        print(e.stderr) 

    
    try:
        subprocess.run(["xxd", "-i", "build/keyring_blob.bin", "build/keyring_blob.h"], check=True)
        print("build/keyring_blob.bin converted to build/keyring_blob.h successfully.")
    except subprocess.CalledProcessError as e:
        print(f"Error converting bin to h: {e}")


if __name__ == "__main__":
    main()
