#include <stdio.h>

// CACHE definitions
#define CACHE_BASE         		0x01840000
#define CACHE_L2CFG             (*( unsigned int* )( CACHE_BASE ))
#define CACHE_L1PCFG            (*( unsigned int* )( CACHE_BASE + 0x0020 ))
#define CACHE_L1DCFG            (*( unsigned int* )( CACHE_BASE + 0x0040 ))
//
#define L2_SRAM_TOP				0x00800000
#define L1P_SRAM_TOP			0x00E00000
#define L1D_SRAM_TOP			0x00F00000

#define L1_BYTE					(32 * 1024)				// 32Kbyte as L1 size
#define BUFF_WORD				(L1_BYTE/sizeof(int))

//
void set_data (unsigned int *ptr, int size);
void copy_data (unsigned int *src, unsigned int *dst, int size);
int verify_data (unsigned int *src, unsigned int *dst, int size);
int verify_data2 (unsigned int *src, unsigned int *dst, int size);

//
unsigned int *buff_l2 = (unsigned int *)L2_SRAM_TOP;
unsigned int *buff_l1p = (unsigned int *)L1P_SRAM_TOP;
unsigned int *buff_l1d = (unsigned int *)L1D_SRAM_TOP;

//_
int main(void) {
	
    // Modify for the desired cache settings needed
    CACHE_L1PCFG = 0;           // L1P cache off, use as SRAM
    CACHE_L1DCFG = 0;           // L1D cache off, use as SRAM
    CACHE_L2CFG  = 0;           // L2 cache off, use as SRAM

	printf("test start.\n");

    set_data(buff_l2, BUFF_WORD);

    // L2 to L1D
    copy_data(buff_l2, buff_l1d, BUFF_WORD);
    if (verify_data(buff_l2, buff_l1d, BUFF_WORD) != 0) {
    	printf("L1D fail!\n");
    }
/*    if (verify_data2(buff_l2, buff_l1d, BUFF_WORD) != 0) {
    	printf("L1D fail!(2)\n");
    }*/

    // L2 to L1P
    copy_data(buff_l2, buff_l1p, BUFF_WORD);
    if (verify_data(buff_l2, buff_l1p, BUFF_WORD) != 0) {
    	printf("L1P fail!\n");
    }
    if (verify_data2(buff_l2, buff_l1p, BUFF_WORD) != 0) {
    	printf("L1P fail!(2)\n");
    }

	printf("test end.\n");

	return 0;
}

//_
void set_data (unsigned int *ptr, int size) {

	int loop;

	for (loop = 0; loop < size; loop++) {
		ptr[loop] = loop;
	}

	return;
}

//_
void copy_data (unsigned int *src, unsigned int *dst, int size) {

	int loop;

	for (loop = 0; loop < size; loop++) {
		dst[loop] = src[loop];
	}

	return;
}

//_
int verify_data (unsigned int *src, unsigned int *dst, int size) {

	int loop;
	volatile int Src, Dst;

	for (loop = 0; loop < size; loop++) {
		if (dst[loop] != src[loop]) {
			return -1;
		}
	}

	return 0;
}

//_
int verify_data2 (unsigned int *src, unsigned int *dst, int size) {

	int loop;
	int Src, Dst;

	for (loop = 0; loop < size; loop++) {
		Src = src[loop];
		printf("dummy\n");	// To have a dummy function between reading src and dst.
		Dst = dst[loop];
		printf("src = 0x%x, dst = 0x%x\n", Src, Dst);

		if (Dst != Src)
		{
			return -1;
		}
	}

	return 0;
}
