#include "copy_buffer.h"

double4 gd_src_lch_d4[SAMPLE_NUM_QUATER];
double4 gd_src_rch_d4[SAMPLE_NUM_QUATER];
double4 gd_dst_lch_d4[SAMPLE_NUM_QUATER];
double4 gd_dst_rch_d4[SAMPLE_NUM_QUATER];

#pragma DATA_SECTION(".sdram");
float sdram_buffer01[768 * 1024];
#pragma DATA_SECTION(".sdram");
float sdram_buffer02[768 * 1024];
#pragma DATA_SECTION(".sdram");
float sdram_buffer03[768 * 1024];
#pragma DATA_SECTION(".sdram");
float sdram_buffer04[3 * 1024 * 1024];
#pragma DATA_SECTION(".sdram");
float sdram_buffer05[4][4000 * 96];
#pragma DATA_SECTION(".sdram");
float sdram_buffer06[3 * 1024 * 1024];
#pragma DATA_SECTION(".sdram");
float sdram_buffer07[2][12][4096];
#pragma DATA_SECTION(".sdram");
float sdram_buffer08[9600];
#pragma DATA_SECTION(".sdram");
float sdram_buffer09[9600];
#pragma DATA_SECTION(".sdram");
float sdram_buffer10[2][8][32768];
#pragma DATA_SECTION(".sdram");
float sdram_buffer11[4096];
#pragma DATA_SECTION(".sdram");
float sdram_buffer12[4096];
#pragma DATA_SECTION(".sdram");
float sdram_buffer13[768 * 1024];
#pragma DATA_SECTION(".sdram");
float sdram_buffer14[768 * 1024];

void copy_float( float *restrict src_lch, float *restrict src_rch, float *restrict dst_lch, float *restrict dst_rch )
{
	int num;

	ALIGNED_ARRAY(src_lch);
	ALIGNED_ARRAY(src_rch);
	ALIGNED_ARRAY(dst_lch);
	ALIGNED_ARRAY(dst_rch);

	for(num=0; num<SAMPLE_NUM; num++) {
		dst_lch[num] = src_lch[num];
		dst_rch[num] = src_rch[num];
	}
}

void copy_float_size( float *restrict src_lch, float *restrict src_rch, float *restrict dst_lch, float *restrict dst_rch, int size )
{
	int num;

	ALIGNED_ARRAY(src_lch);
	ALIGNED_ARRAY(src_rch);
	ALIGNED_ARRAY(dst_lch);
	ALIGNED_ARRAY(dst_rch);

	for(num=0; num < size; num++) {
		dst_lch[num] = src_lch[num];
		dst_rch[num] = src_rch[num];
	}
}

void copy_double( double *restrict src_lch, double *restrict src_rch, double *restrict dst_lch, double *restrict dst_rch )
{
	int num;

	ALIGNED_ARRAY(src_lch);
	ALIGNED_ARRAY(src_rch);
	ALIGNED_ARRAY(dst_lch);
	ALIGNED_ARRAY(dst_rch);

	for(num=0; num<SAMPLE_NUM; num++) {
		dst_lch[num] = src_lch[num];
		dst_rch[num] = src_rch[num];
	}
}

void copy_double4( double4 *restrict src_lch, double4 *restrict src_rch, double4 *restrict dst_lch, double4 *restrict dst_rch )
{
	int num;

	ALIGNED_ARRAY(src_lch);
	ALIGNED_ARRAY(src_rch);
	ALIGNED_ARRAY(dst_lch);
	ALIGNED_ARRAY(dst_rch);

	for(num=0; num<SAMPLE_NUM_QUATER; num++) {
		dst_lch[num] = src_lch[num];
		dst_rch[num] = src_rch[num];
	}
}

void test_func01( void )
{
	int i;
	for(i=0; i < 100; i++)
	{
		copy_double(gd_src_lch, gd_src_rch, gd_dst_lch, gd_dst_rch);
	}
}

void test_func02( void )
{
	int i;
	for(i=0; i < 100; i++)
	{
		copy_double4(gd_src_lch_d4, gd_src_rch_d4, gd_dst_lch_d4, gd_dst_rch_d4);
	}
}

void test_func03( void )
{
	int i;
	int size = sizeof(sdram_buffer04)/sizeof(float);

	for(i=0; i < 10; i++)
	{
		copy_float_size(sdram_buffer04, sdram_buffer04, sdram_buffer06, sdram_buffer06, size);
	}
}

void test_func04( void )
{
	int i;
	int size = sizeof(sdram_buffer01)/sizeof(float);

	for(i=0; i < 10; i++)
	{
		copy_float_size(sdram_buffer01, sdram_buffer02, sdram_buffer04, sdram_buffer04 + size, size);
		copy_float_size(sdram_buffer03, sdram_buffer13, sdram_buffer06, sdram_buffer06 + size, size);
	}
}
