/*
 *  Copyright (C) 2018-2024 Texas Instruments Incorporated
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <kernel/dpl/DebugP.h>
#include "ti_drivers_config.h"
#include "ti_board_config.h"
#include "ti_drivers_open_close.h"
#include "ti_board_open_close.h"
#include "FreeRTOS.h"
#include "task.h"
// user add
#include <c7x.h>
#include <c6x_migration.h>
#include "copy_buffer.h"

#define MAIN_TASK_PRI  (configMAX_PRIORITIES-1)

#define MAIN_TASK_SIZE (65536U/sizeof(configSTACK_DEPTH_TYPE))
StackType_t gMainTaskStack[MAIN_TASK_SIZE] __attribute__((aligned(32)));

StaticTask_t gMainTaskObj;
TaskHandle_t gMainTask;


// user add
extern void CSL_c7xSetTCR0(uint64_t param);
extern void CSL_c7xSetTBR0(uint64_t param);
extern void CSL_c7xSetMAR(uint64_t param);
extern void CSL_c7xSetSCR(uint64_t param);
extern void CSL_c7xMmuTlbInvAll();
extern void test_func01( void );
extern void test_func02( void );
extern void test_func03( void );
extern void test_func04( void );
extern const uint64_t pte_lvl0[512];

void mcasp_playback_main(void *args);

void freertos_main(void *args)
{
    int32_t status = SystemP_SUCCESS;

    /* Open drivers */
    Drivers_open();
    /* Open flash and board drivers */
    status = Board_driversOpen();
    DebugP_assert(status==SystemP_SUCCESS);

    mcasp_playback_main(NULL);

    /* Close board and flash drivers */
    Board_driversClose();
    /* Close drivers */
    Drivers_close();

    vTaskDelete(NULL);
}



void enable_cache_mmu(uint64_t ttbr)
{
	uint64_t          tcr;
	uint64_t          mar;
	uint64_t          scr;
	
	tcr = 0x0000000000002a21U;
	scr = 0x80000000000000c1U;
	mar = 0x3D3D3D2915032A00U;

	CSL_c7xSetTCR0(tcr);    //ECR785
	CSL_c7xSetTBR0(ttbr);   //ECR787
	CSL_c7xSetMAR(mar);     //ECR789
	CSL_c7xSetSCR(scr);     //ECR784  *** This register has to be last ***
}

void invalidate_tlb()
{
	CSL_c7xMmuTlbInvAll();
}


// user add
extern float sdram_buffer01[768 * 1024];
extern float sdram_buffer02[768 * 1024];
extern void _c_int00_secure();

int main()
{
	//_c_int00_secure();
	#if 0
	// user add
	enable_cache_mmu((uint64_t) pte_lvl0);
	invalidate_tlb();
	#else
    /* init SOC specific modules */
    System_init();
    Board_init();
	#endif

	uint32_t k = 0;

	// user add
	#if 1
	#if 1
	for(k = 0; k < 10; k++){
		//test_func01();
		test_func03();
		//test_func04();
	}
	for(k = 0; k < 100; k++){
		//test_func01();
		//test_func02();
		//test_func03();
		test_func04();
	}
	#else
	for(k = 0; k < 100; k++){
		copy_double((double*)sdram_buffer01, (double*)sdram_buffer01, 
					(double*)sdram_buffer02, (double*)sdram_buffer02);
	}
	#endif
	#endif

	// user add end

    /* This task is created at highest priority, it should create more tasks and then delete itself */
    gMainTask = xTaskCreateStatic( freertos_main,   /* Pointer to the function that implements the task. */
                                  "freertos_main", /* Text name for the task.  This is to facilitate debugging only. */
                                  MAIN_TASK_SIZE,  /* Stack depth in units of StackType_t typically uint32_t on 32b CPUs */
                                  NULL,            /* We are not using the task parameter. */
                                  MAIN_TASK_PRI,   /* task priority, 0 is lowest priority, configMAX_PRIORITIES-1 is highest */
                                  gMainTaskStack,  /* pointer to stack base */
                                  &gMainTaskObj ); /* pointer to statically allocated task object memory */
    configASSERT(gMainTask != NULL);

    /* Start the scheduler to start the tasks executing. */
    vTaskStartScheduler();

    /* The following line should never be reached because vTaskStartScheduler()
    will only return if there was not enough FreeRTOS heap memory available to
    create the Idle and (if configured) Timer tasks.  Heap management, and
    techniques for trapping heap exhaustion, are described in the book text. */
    DebugP_assertNoLog(0);

    return 0;
}
