/******************************************************************************
* FILE: omp_hello.c
* DESCRIPTION:
*   OpenMP Example - Hello World - C/C++ Version
*   In this simple example, the master thread forks a parallel region.
*   All threads in the team obtain their unique thread number and print it.
*   The master thread only prints the total number of threads.  Two OpenMP
*   library routines are used to obtain the number of threads and each
*   thread's number.
* AUTHOR: Blaise Barney  5/99
* LAST REVISED: 04/06/05
******************************************************************************/
#include <ti/runtime/openmp/omp.h>
#include <stdio.h>

#define REC_LIMIT (2*1024)   // works
#define REC_LIMIT (25*1024)  // not working

double bad_recursion(double x){
    if (x > REC_LIMIT){
        return 1;
    } else {
        return 1+bad_recursion(1+x);
    }
}

int main (int argc, char *argv[]) {

  int nthreads, tid;

  double retval = bad_recursion(1);
  printf("retval = %f \n", retval);
  return 0;
}
