
#include <ti/runtime/openmp/omp.h>
#include <xdc/runtime/System.h>
#include <stdio.h>
#include <stdint.h>

#define DATA_LEN 100

struct STRUCT_AB {
	uint32_t a;
	uint32_t b;
};

uint32_t omp_test1(uint32_t *data, uint32_t size){
	uint32_t i;
	memset(data, 0, size * sizeof(uint32_t));

	#pragma omp parallel for
	for (i = 0; i < size; i++){
		uint32_t s[2] = { 0, 0 };
		data[i] += s[0];
		data[i] += s[1];
	}

	uint32_t sum = 0;
	for (i = 0; i < size; i++){
		sum += data[i];
	}
	return sum;
}

uint32_t omp_test2(uint32_t *data, uint32_t size){
	uint32_t i;
	memset(data, 0, size * sizeof(uint32_t));

	#pragma omp parallel for
	for (i = 0; i < size; i++){
		struct STRUCT_AB s = { 0, 0 };
		data[i] += s.a;
		data[i] += s.b;
	}

	uint32_t sum = 0;
	for (i = 0; i < size; i++){
		sum += data[i];
	}
	return sum;
}


void main()
{
    uint32_t result1, result2;
    uint32_t data[DATA_LEN];

    result1 = omp_test1(data, DATA_LEN);
    result2 = omp_test2(data, DATA_LEN);
    while(1) {
    	asm(" nop");
    }
}

