#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);



    DatabaseConnect();
    readFromDatabaseAndUpload();
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::DatabaseConnect()
{
    const QString DRIVER("QSQLITE");
    QString Path;
    QDir dir=QDir::current();
    Path=dir.currentPath();
    Path=Path +"/"+"ics.db3";

    qDebug()<<"Path "<<Path;

    if(QSqlDatabase::isDriverAvailable(DRIVER))
    {
        /**Add Sqlite Database**/
        db= QSqlDatabase::addDatabase("QSQLITE");
        /*Initialise Database Path*/

        qDebug()<<"Path inside isDriverAvailable function "<<Path;
        /*Set Path to Database */
        db.setDatabaseName(Path);
        /*Check if Database is Open or Not*/
        if(!db.open())
        {
            ui->status->setText("Database Not Connected");
        }
        else
        {
            ui->status->setText("Database is Connected Successfully");
        }
    }
}


void MainWindow::readFromDatabaseAndUpload()


{
    QSqlQuery query;

    query.prepare("SELECT TERMINAL_ID,TERMINAL_NAME,Priority,Default_Group_Number,Group_Numbers,Main_BroadCast,Conference_Dial FROM TERMINAL_INFO");

    const int TERMINAL_INFO_INDEX_TERMINAL_ID=0;
    const int TERMINAL_INFO_INDEX_TERMINAL_NAME=1;
    const int TERMINAL_INFO_INDEX_Priority=2;
    const int TERMINAL_INFO_INDEX_Default_Group_Number=3;
    const int TERMINAL_INFO_INDEX_Group_Numbers=4;
    const int TERMINAL_INFO_INDEX_Main_BroadCast=5;
    const int TERMINAL_INFO_INDEX_Conference_Dial=6;

    if(!query.exec())
    {
        qDebug() << "Can't Execute Query !";
    }
    else
    {
        while(query.next())
        {

            qDebug() << "TERMINAL_ID : " << query.value(TERMINAL_INFO_INDEX_TERMINAL_ID).toString();
            qDebug() << "TERMINAL_NAME : " << query.value(TERMINAL_INFO_INDEX_TERMINAL_NAME).toString();
            qDebug() << "Priority : " << query.value(TERMINAL_INFO_INDEX_Priority).toString();
            qDebug() << "Default_Group_Number : " << query.value(TERMINAL_INFO_INDEX_Default_Group_Number).toString();
            qDebug() << "Group_Numbers : " << query.value(TERMINAL_INFO_INDEX_Group_Numbers).toString();
            qDebug() << "Main_BroadCast : " << query.value(TERMINAL_INFO_INDEX_Main_BroadCast).toString();
            qDebug() << "Conference_Dial : " << query.value(TERMINAL_INFO_INDEX_Conference_Dial).toString();


            QString TERMINAL_NAME,TERMINAL_ID;

            /*********Gets values in variables from database********/
            TERMINAL_ID = query.value(TERMINAL_INFO_INDEX_TERMINAL_ID).toString();
            TERMINAL_NAME =query.value(TERMINAL_INFO_INDEX_TERMINAL_NAME).toString();




            ui->Id->setText(TERMINAL_ID);
            ui->name->setText(TERMINAL_NAME);



        }
    }
    qDebug() << "Reading finished";
}

