import tensorflow as tf
import pathlib

model_out_dir = './'

model = tf.keras.Sequential([
  tf.keras.layers.Conv1D(filters=16, kernel_size=(7), padding='same', activation='tanh', input_shape=(24, 5)),
  tf.keras.layers.Conv1D(filters=16, kernel_size=(7), padding='same', activation='tanh'),
  tf.keras.layers.Flatten(),
  tf.keras.layers.Dense(2, activation='relu'),
])

## convert to tflite
converter = tf.lite.TFLiteConverter.from_keras_model(model)
converter.target_spec.supported_ops = [tf.lite.OpsSet.TFLITE_BUILTINS]
tflite_model = converter.convert()

tflite_models_dir = pathlib.Path(model_out_dir)
# Save model:
tflite_model_file = tflite_models_dir/"test_model.tflite"
tflite_model_file.write_bytes(tflite_model)