#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Include appropriate OpenGL/platform libraries
#include "graphics_platform.h"

#include "window_wayland.h"

#include "window_nodisplay.h"

#include "draw_texture.h"


int main(int argc, char **argv)
{

	printf("Starting application...\n");
	// Set up windowing system specific to target that will allow GL functions to run
    if (setup_gl_context() < 0)
	{
		fprintf(stderr, "setup_gl_context failed.\n");
		exit(EXIT_FAILURE);
	}

    if(!initializeBuffer())
	{
		fprintf(stderr, "initializeBuffer failed.\n");
		exit(EXIT_FAILURE);
	};

	if(!initializeShaders()){
		fprintf(stderr, "initializeShaders failed.\n");
		exit(EXIT_FAILURE);
	};

	printf("Running...\n");
	//for(int i = 0; i<5; i++){
	while(1){
		renderScene();
		swap_buffers();
	}
	
    terminate_gl_context();
	exit(EXIT_SUCCESS);
}
