/*******************************************************************************
 * Copyright 2004-2005 - Software Design Solutions, Inc.  All rights reserved.
 *
 * Portions of this work have been provided under license with Texas
 * Instruments Inc.
 *
 * $RCSfile: BlinkDSK6713.cmd,v $
 * $Revision: 1.2 $
 *
 * Linker command file for BlinkDSK6713
 ******************************************************************************/

MEMORY
{
    vecs:          o = 00000000h   l = 00000200h
    boot:          o = 00000200h   l = 00000200h
    IRAM:          o = 00000400h   l = 0000FA00h
    CE0:           o = 80000000h   l = 01000000h
    FLASHBOOT:     o = 90000000h   l = 00000400h
    FLASH:         o = 90000400h   l = 0007FC00h

}

SECTIONS
{
    "vectors"   : {} > FLASHBOOT   run = vecs
    "bootload"  : {} > FLASHBOOT   run = boot
    .text       : {} > FLASH   run = IRAM, LOAD_START(FLASH_TEXT_START), RUN_START(RAM_TEXT_START), SIZE(TEXT_SIZE)
    .cinit      : {} > FLASH   run = IRAM, LOAD_START(FLASH_CINIT_START), RUN_START(RAM_CINIT_START), SIZE(CINIT_SIZE)
    .const      : {} > FLASH   run = IRAM, LOAD_START(FLASH_CONST_START), RUN_START(RAM_CONST_START), SIZE(CONST_SIZE)
    .switch     : {} > FLASH   run = IRAM, LOAD_START(FLASH_SWITCH_START), RUN_START(RAM_SWITCH_START), SIZE(SWITCH_SIZE)
    .tables     : {} > FLASH   run = IRAM, LOAD_START(FLASH_TABLES_START), RUN_START(RAM_TABLES_START), SIZE(TABLES_SIZE)
    .stack      : {} > IRAM
    .bss        : {} > IRAM
    .data       : {} > IRAM
    .far        : {} > IRAM
    .sysmem     : {} > IRAM
    .cio        : {} > IRAM
}
