#include "dsk6713.h"
#include "dsk6713_aic23.h"
#define beta 1E-12            //rate of convergence     
#define N 30 
short int adaptive_filter(short int ,short int );
float delay[N];
float w[N];


//union{unsigned int uint; short channel[2];} AIC23_data;

DSK6713_AIC23_Config config = {\
    0x001C,  /* 0 DSK6713_AIC23_LEFTINVOL  Left line input channel volume */ \
    0x00C3,  /* 1 DSK6713_AIC23_RIGHTINVOL Right line input channel volume */\
    0x00d8,  /* 2 DSK6713_AIC23_LEFTHPVOL  Left channel headphone volume */  \
    0x00d8,  /* 3 DSK6713_AIC23_RIGHTHPVOL Right channel headphone volume */ \
    0x0011,  /* 4 DSK6713_AIC23_ANAPATH    Analog audio path control */      \
    0x0000,  /* 5 DSK6713_AIC23_DIGPATH    Digital audio path control */     \
    0x0000,  /* 6 DSK6713_AIC23_POWERDOWN  Power down control */             \
    0x0043,  /* 7 DSK6713_AIC23_DIGIF      Digital audio interface format */ \
    0x0081,  /* 8 DSK6713_AIC23_SAMPLERATE Sample rate control */            \
    0x0001   /* 9 DSK6713_AIC23_DIGACT     Digital interface activation */   \
};


/*
*  main() - Main code routine, initializes BSL and generates tone
*/
void main()
{
    DSK6713_AIC23_CodecHandle hCodec;
  
    int l_input, r_input;
    int l_output, r_output, T;
    
    /* Initialize the board support library, must be called first */
    DSK6713_init();
     
    /* Start the codec */
    hCodec = DSK6713_AIC23_openCodec(0, &config);
        
    DSK6713_AIC23_setFreq(hCodec, 1);

for (T = 0; T < 30; T++)
   {
       w[T] = 0;                  //init buffer for weights
       delay[T] = 0;              //init buffer for delay samples
   }  

        while(1)
        {
             
            /* Read a sample to the left channel */
            while (!DSK6713_AIC23_read(hCodec,&l_input));
            
            /* Read a sample to the right channel */
            while (!DSK6713_AIC23_read(hCodec, &r_input));          
                
            l_output=(short int)adaptive_filter(l_input,r_input);
            r_output=l_output;
            
            /* Send a sample to the left channel */
            while (!DSK6713_AIC23_write(hCodec, -l_output));

            /* Send a sample to the right channel */
            while (!DSK6713_AIC23_write(hCodec, -r_output));
        }
           
    /* Close the codec */
    //DSK6713_AIC23_closeCodec(hCodec);
}
short int adaptive_filter(short l_input1,short r_input1)            //ISR
{                         
  short i,output;
  float yn=0, E=0, dplusn=0, desired=0, noise=0;    
  
  desired = l_input1;
  noise = r_input1;
  dplusn = -(desired + noise);         //desired+noise
  delay[0] = noise;                //noise as input to adapt FIR
    
  for (i = 0; i < N; i++)          //to calculate out of adapt FIR
    yn += (w[i] * delay[i]);       //output of adaptive filter
  E = (desired + noise) - yn;      //"error" signal=(d+n)-yn   
  for (i = N-1; i >= 0; i--)       //to update weights and delays
   {            
    w[i] = w[i] + beta*E*delay[i]; //update weights   
       delay[i] = delay[i-1];       //update delay samples   
   }  
         output=((short)E);    //error signal as overall output  
  
      //output=((short)dplusn);//output (desired+noise)
              //overall output result    
  return(output);
}



