/*
 * Decompiled with CFR 0.152.
 */
package ti.uia.runtime;

import ti.uia.runtime.UIAPacket;

public class EventPacketHeader
extends UIAPacket {
    boolean payloadLittleEndian = true;
    private int payloadEndian = 0;
    int eventLength = 0;
    int seqNum = 0;
    int priority = 0;
    int loggerId = 0;
    int instanceId = 0;
    int destAddr = 0;
    int srcAddr = 0;
    static final int PAYLOAD_ENDIAN_MASK = 0x8000000;
    static final int EVENT_LENGTH_MASK = 0x7FFFFFF;
    static final int SEQ_NUM_MASK = -65536;
    static final int PRIORITY_MASK = 3;
    static final int LOGGER_ID_MASK = 65535;
    static final int INSTANCE_ID_MASK = -65536;
    static final int DEST_ADDR_MASK = -65536;
    static final int SRC_ADDR_MASK = 65535;

    public EventPacketHeader() {
        this.hdrType = 10;
    }

    public static int getHeaderSize() {
        return 16;
    }

    @Override
    public void read(byte[] byArray, int n) throws UIAPacket.IllegalMessageException {
        if (byArray == null || byArray.length - n < EventPacketHeader.getHeaderSize()) {
            throw new UIAPacket.IllegalMessageException(new UIAPacket.IllegalSize(byArray.length - n));
        }
        int n2 = (int)this.hdrDec.decodeBytes(byArray, n, 4, false);
        int n3 = (int)this.hdrDec.decodeBytes(byArray, n + 4, 4, false);
        int n4 = (int)this.hdrDec.decodeBytes(byArray, n + 8, 4, false);
        int n5 = (int)this.hdrDec.decodeBytes(byArray, n + 12, 4, false);
        this.setPayloadEndian(EventPacketHeader.readVal(n2, 0x8000000));
        this.eventLength = EventPacketHeader.readVal(n2, 0x7FFFFFF);
        this.seqNum = EventPacketHeader.readVal(n3, -65536);
        this.priority = EventPacketHeader.readVal(n3, 3);
        this.loggerId = EventPacketHeader.readVal(n4, 65535);
        this.instanceId = EventPacketHeader.readVal(n4, -65536) - 1;
        this.destAddr = EventPacketHeader.readVal(n5, -65536);
        this.srcAddr = EventPacketHeader.readVal(n5, 65535);
    }

    public void printHeader() {
        System.out.println("======================================");
        System.out.println("Event Packet Header");
        System.out.println("  seqNum: " + this.seqNum + " payloadEndian: " + this.getPayloadEndian() + " eventLength: " + this.eventLength);
        System.out.println("  logger moduleId: " + this.loggerId + " instanceId: " + (this.instanceId + 1) + " priority: " + this.priority);
        System.out.println("  destAddr: " + this.destAddr + " srcAddr: " + this.srcAddr);
        System.out.println("======================================");
    }

    public void write(byte[] byArray, int n) {
        int n2 = this.hdrType << EventPacketHeader.getShiftCount(-268435456) | this.getPayloadEndian() << EventPacketHeader.getShiftCount(0x8000000) | this.eventLength << EventPacketHeader.getShiftCount(0x7FFFFFF);
        int n3 = this.seqNum << EventPacketHeader.getShiftCount(-65536) | this.priority << EventPacketHeader.getShiftCount(3);
        int n4 = this.loggerId << EventPacketHeader.getShiftCount(65535) | this.instanceId << EventPacketHeader.getShiftCount(-65536);
        int n5 = this.destAddr << EventPacketHeader.getShiftCount(-65536) | this.srcAddr << EventPacketHeader.getShiftCount(65535);
        this.hdrEnc.encodeBytes(byArray, n, (long)n2, 4);
        this.hdrEnc.encodeBytes(byArray, n + 4, (long)n3, 4);
        this.hdrEnc.encodeBytes(byArray, n + 8, (long)n4, 4);
        this.hdrEnc.encodeBytes(byArray, n + 12, (long)n5, 4);
    }

    public int getEventLength() {
        return this.eventLength;
    }

    public void setEventLength(int n) {
        this.eventLength = n;
    }

    public int getPacketSeqNum() {
        return this.seqNum;
    }

    public void setPacketSeqNum(int n) {
        this.seqNum = n;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public int getLoggerId() {
        return this.loggerId;
    }

    public void setLoggerId(int n) {
        this.loggerId = n;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(int n) {
        this.instanceId = n;
    }

    public int getSenderAddr() {
        return this.srcAddr;
    }

    public void setSenderAddr(int n) {
        this.srcAddr = n;
    }

    public int getDestAdrs() {
        return this.destAddr;
    }

    public void setDestAdrs(int n) {
        this.destAddr = n;
    }

    public int getPayloadSize() {
        return this.eventLength - 16;
    }

    public void setPayloadEndian(int n) {
        this.payloadEndian = n;
    }

    public int getPayloadEndian() {
        return this.payloadEndian;
    }
}

