/*
 * Decompiled with CFR 0.152.
 */
package ti.uia.runtime;

import ti.uia.runtime.UIAPacket;

public class MessagePacketHeader
extends UIAPacket {
    int payloadEndian = 0;
    int msgLen = 0;
    EnumMsgType msgType = EnumMsgType.CMD;
    int serviceId = 0;
    int seqNum;
    int cmdId;
    int tag = 0;
    int srcAddr = 0;
    int destAddr = 0;
    boolean payloadLittleEndian = true;
    static final int PAYLOAD_ENDIAN_MASK = 0x8000000;
    static final int MESSAGE_LENGTH_MASK = 0x7FF0000;
    static final int MESSAGE_TYPE_MASK = 61440;
    static final int SERVICE_ID_MASK = 4095;
    static final int SEQ_NUM_MASK = -65536;
    static final int COMMAND_ID_MASK = 65535;
    static final int DEST_ADDR_MASK = -65536;
    static final int SRC_ADDR_MASK = 65535;

    public Object clone() throws CloneNotSupportedException {
        MessagePacketHeader messagePacketHeader = new MessagePacketHeader();
        messagePacketHeader.hdrType = this.hdrType;
        messagePacketHeader.payloadEndian = this.payloadEndian;
        messagePacketHeader.msgLen = this.msgLen;
        messagePacketHeader.msgType = this.msgType;
        messagePacketHeader.serviceId = this.serviceId;
        messagePacketHeader.seqNum = this.seqNum;
        messagePacketHeader.cmdId = this.cmdId;
        messagePacketHeader.tag = this.tag;
        messagePacketHeader.srcAddr = this.srcAddr;
        messagePacketHeader.destAddr = this.destAddr;
        return messagePacketHeader;
    }

    public MessagePacketHeader() {
        this.hdrType = 9;
    }

    @Override
    public void read(byte[] byArray, int n) throws UIAPacket.IllegalMessageException {
        if (byArray == null || byArray.length - n < MessagePacketHeader.getHeaderSize()) {
            throw new UIAPacket.IllegalMessageException(new UIAPacket.IllegalSize(byArray.length - n));
        }
        int n2 = (int)this.hdrDec.decodeBytes(byArray, n, 4, false);
        int n3 = (int)this.hdrDec.decodeBytes(byArray, n + 4, 4, false);
        int n4 = (int)this.hdrDec.decodeBytes(byArray, n + 8, 4, false);
        int n5 = (int)this.hdrDec.decodeBytes(byArray, n + 12, 4, false);
        this.hdrType = MessagePacketHeader.readVal(n2, -268435456);
        this.payloadEndian = MessagePacketHeader.readVal(n2, 0x8000000);
        this.msgLen = MessagePacketHeader.readVal(n2, 0x7FF0000);
        this.msgType = EnumMsgType.fromInt(MessagePacketHeader.readVal(n2, 61440));
        this.serviceId = MessagePacketHeader.readVal(n2, 4095);
        this.seqNum = MessagePacketHeader.readVal(n3, -65536);
        this.cmdId = MessagePacketHeader.readVal(n3, 65535);
        this.tag = n4;
        this.destAddr = MessagePacketHeader.readVal(n5, -65536);
        this.srcAddr = MessagePacketHeader.readVal(n5, 65535);
    }

    public void write(byte[] byArray, int n) throws UIAPacket.IllegalMessageException {
        int n2 = this.hdrType << MessagePacketHeader.getShiftCount(-268435456) | this.payloadEndian << MessagePacketHeader.getShiftCount(0x8000000) | this.msgLen << MessagePacketHeader.getShiftCount(0x7FF0000) | this.msgType.getInt() << MessagePacketHeader.getShiftCount(61440) | this.serviceId << MessagePacketHeader.getShiftCount(4095);
        int n3 = this.seqNum << MessagePacketHeader.getShiftCount(-65536) | this.cmdId << MessagePacketHeader.getShiftCount(65535);
        int n4 = this.tag;
        int n5 = this.destAddr << MessagePacketHeader.getShiftCount(-65536) | this.srcAddr << MessagePacketHeader.getShiftCount(65535);
        this.hdrEnc.encodeBytes(byArray, n, (long)n2, 4);
        this.hdrEnc.encodeBytes(byArray, n + 4, (long)n3, 4);
        this.hdrEnc.encodeBytes(byArray, n + 8, (long)n4, 4);
        this.hdrEnc.encodeBytes(byArray, n + 12, (long)n5, 4);
    }

    public int getPayloadEndian() {
        return this.payloadEndian;
    }

    public void setPayloadEndian(int n) {
        this.payloadEndian = n;
    }

    public int getMsgLength() {
        return this.msgLen;
    }

    public void setMsgLength(int n) {
        this.msgLen = n;
    }

    public static int getHeaderSize() {
        return 16;
    }

    public EnumMsgType getMsgType() {
        return this.msgType;
    }

    public void setMsgType(EnumMsgType enumMsgType) {
        this.msgType = enumMsgType;
    }

    public int getCmdId() {
        return this.cmdId;
    }

    public void setCmdId(int n) {
        this.cmdId = n;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(int n) {
        this.serviceId = n;
    }

    public int getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(int n) {
        this.seqNum = n;
    }

    public int getTag() {
        return this.tag;
    }

    public void setTag(int n) {
        this.tag = n;
    }

    public int getSrcAddr() {
        return this.srcAddr;
    }

    public void setSrcAddr(int n) {
        this.srcAddr = n;
    }

    public int getDestAddr() {
        return this.destAddr;
    }

    public void setDestAddr(int n) {
        this.destAddr = n;
    }

    public static enum EnumMsgType {
        ACK(0, "Ack"),
        CMD(1, "Command"),
        RESULT(2, "Result"),
        PARTIAL_RESULT(3, "Partial Resulot"),
        NOTIFY(4, "Notify"),
        FLOW_CONTROL(5, "Flow control"),
        DATA(6, "Data"),
        RESERVED7(7, "Reserved"),
        RESERVED8(8, "Reserved"),
        RESERVED9(9, "Reserved"),
        RESERVED10(10, "Reserved"),
        RESERVED11(11, "Reserved"),
        RESERVED12(12, "Reserved"),
        RESERVED13(13, "Reserved"),
        NACK_BAD_DATA(14, "NACK: Bad Data"),
        NACK_WITH_ERROR_CODE(15, "NACK With Error Code");

        private String caption;
        int msgType;

        private EnumMsgType(int n2, String string2) {
            this.msgType = n2;
            this.caption = string2;
        }

        public String getString() {
            return this.caption;
        }

        public int getMsgType() {
            return this.msgType;
        }

        public String toString() {
            return this.caption;
        }

        public int getInt() {
            return this.msgType;
        }

        public static EnumMsgType fromInt(int n) {
            for (EnumMsgType enumMsgType : EnumMsgType.values()) {
                if (enumMsgType.getMsgType() != n) continue;
                return enumMsgType;
            }
            throw new IndexOutOfBoundsException("itemMsgType.fromInt: Invalid integer value (" + Integer.toString(n) + ")");
        }

        public static EnumMsgType fromString(String string) {
            for (EnumMsgType enumMsgType : EnumMsgType.values()) {
                if (!enumMsgType.caption.contentEquals(string)) continue;
                return enumMsgType;
            }
            throw new IndexOutOfBoundsException("EnumMsgType.fromString(" + string + "): Invalid String value for EnumMsgType");
        }
    }
}

