/*
 * Decompiled with CFR 0.152.
 */
package ti.uia.runtime;

import xdc.rta.HostEvent;
import xdc.rta.MetaData;

public class SequenceAdjust {
    private CoreSequenceData[] cores;
    private long maxSeqNum = 65535L;

    public SequenceAdjust(MetaData metaData) {
        int n = metaData.getLoggerNames().length;
        int n2 = 8;
        this.cores = new CoreSequenceData[n2];
        for (int i = 0; i < n2; ++i) {
            this.cores[i] = new CoreSequenceData();
            this.cores[i].loggers = new LoggerSequenceData[n];
            for (int j = 0; j < n; ++j) {
                this.cores[i].loggers[j] = new LoggerSequenceData();
                this.cores[i].loggers[j].prevTime = 0L;
                this.cores[i].loggers[j].prevSeqNum = 0L;
                this.cores[i].loggers[j].curAdjAmnt = 0L;
            }
        }
    }

    public void adjustSeqNum(HostEvent hostEvent, int n, int n2) {
        CoreSequenceData coreSequenceData = this.cores[n];
        LoggerSequenceData loggerSequenceData = coreSequenceData.loggers[n2];
        if (hostEvent.sequenceNum < loggerSequenceData.prevSeqNum) {
            if (hostEvent.timestamp < loggerSequenceData.prevTime) {
                System.out.println("\n**************Detected out of order record!!!****************\n");
            } else {
                loggerSequenceData.curAdjAmnt += this.maxSeqNum;
            }
        }
        loggerSequenceData.prevSeqNum = hostEvent.sequenceNum;
        loggerSequenceData.prevTime = hostEvent.timestamp;
        hostEvent.sequenceNum += loggerSequenceData.curAdjAmnt;
    }

    public class CoreSequenceData {
        public LoggerSequenceData[] loggers;
    }

    public class LoggerSequenceData {
        public long prevTime;
        public long prevSeqNum;
        public long curAdjAmnt;
    }
}

