/*
 * Decompiled with CFR 0.152.
 */
package ti.uia.runtime;

import xdc.rov.TargetDecoder;
import xdc.rov.TargetEncoder;
import xdc.rov.TargetType;

public abstract class UIAPacket {
    public static final int HDR_TYPE_MASK = -268435456;
    public static final int HDR_TYPE_RESERVED_0 = 0;
    public static final int HDR_TYPE_RESERVED_1 = 1;
    public static final int HDR_TYPE_RESERVED_2 = 2;
    public static final int HDR_TYPE_RESERVED_3 = 3;
    public static final int HDR_TYPE_RESERVED_4 = 4;
    public static final int HDR_TYPE_RESERVED_5 = 5;
    public static final int HDR_TYPE_RESERVED_6 = 6;
    public static final int HDR_TYPE_RESERVED_7 = 7;
    public static final int HDR_TYPE_CHANNELIZED_DATA = 8;
    public static final int HDR_TYPE_MSG = 9;
    public static final int HDR_TYPE_EVENT_REC = 10;
    public static final int HDR_TYPE_CPU_TRACE = 11;
    public static final int HDR_TYPE_STM_TRACE = 12;
    public static final int HDR_TYPE_USER1 = 13;
    public static final int HDR_TYPE_USER2 = 14;
    public static final int HDR_TYPE_USER3 = 15;
    protected int hdrType = 0;
    protected TargetDecoder hdrDec = new TargetDecoder(TargetType.Endianess.BIG, 8);
    protected TargetEncoder hdrEnc = new TargetEncoder(TargetType.Endianess.BIG, 8);
    protected TargetDecoder payloadDec;
    protected TargetEncoder payloadEnc;
    static final int DEST_ADDR_MASK = -65536;
    static final int SRC_ADDR_MASK = 65535;

    public int getHdrType() {
        return this.hdrType;
    }

    public static Endianess getEndianess(TargetType.Endianess endianess) {
        if (endianess == TargetType.Endianess.LITTLE) {
            return Endianess.LITTLE;
        }
        return Endianess.BIG;
    }

    public static int getEndianessValue(Endianess endianess) {
        if (endianess == Endianess.LITTLE) {
            return 0;
        }
        return 1;
    }

    public abstract void read(byte[] var1, int var2) throws IllegalMessageException;

    public static int peekHeaderType(int n) {
        int n2 = UIAPacket.readVal(n, -268435456);
        return n2;
    }

    public static int peekHeaderType(TargetDecoder targetDecoder, byte[] byArray, int n) {
        if (targetDecoder == null) {
            return -1;
        }
        int n2 = (int)targetDecoder.decodeBytes(byArray, n, 4, false);
        return UIAPacket.peekHeaderType(n2);
    }

    public static int peekSrcAddr(TargetDecoder targetDecoder, byte[] byArray, int n) {
        if (targetDecoder == null) {
            return -1;
        }
        int n2 = (int)targetDecoder.decodeBytes(byArray, n + 12, 4, false);
        int n3 = UIAPacket.readVal(n2, 65535);
        return n3;
    }

    public static int peekDestAddr(TargetDecoder targetDecoder, byte[] byArray, int n) {
        if (targetDecoder == null) {
            return -1;
        }
        int n2 = (int)targetDecoder.decodeBytes(byArray, n + 12, 4, false);
        int n3 = UIAPacket.readVal(n2, -65536);
        return n3;
    }

    protected static int getShiftCount(int n) {
        int n2 = 0;
        while ((n & 1) == 0) {
            n >>= 1;
            ++n2;
        }
        return n2;
    }

    protected static int readVal(int n, int n2) {
        long l = (long)n & 0xFFFFFFFFL;
        return (int)((l & (long)n2) >> UIAPacket.getShiftCount(n2));
    }

    public static class UnsupportedType
    extends Throwable {
        private static final long serialVersionUID = 1L;

        public UnsupportedType(int n) {
            super("UIA - Unsupported header type: " + n);
        }
    }

    public static class IllegalSize
    extends Throwable {
        private static final long serialVersionUID = 1L;

        public IllegalSize(int n) {
            super("UIA - Illegal raw message size: " + n);
        }
    }

    public static class IllegalMessageException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalMessageException() {
        }

        public IllegalMessageException(String string) {
            super(string);
        }

        public IllegalMessageException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public IllegalMessageException(Throwable throwable) {
            super(throwable);
        }
    }

    public static enum Endianess {
        LITTLE,
        BIG;

    }
}

