/*
 * Decompiled with CFR 0.152.
 */
package ti.uia.services;

import ti.uia.runtime.MessagePacketHeader;
import ti.uia.runtime.UIAPacket;
import xdc.rov.TargetEncoder;

public class RtaService {
    public int rtaServiceId = 3;
    public static final int CMD_READ_MASK = 0;
    public static final int CMD_WRITE_MASK = 1;
    public static final int CMD_LOGGER_DISABLE = 2;
    public static final int CMD_LOGGER_ENABLE = 3;
    public static final int CMD_GET_CPU_SPEED = 4;
    public static final int CMD_LOGGER_RESET = 5;
    public static final int CMD_CHANGE_PERIOD = 6;
    public static final int CMD_START_TX = 7;
    public static final int CMD_STOP_TX = 8;
    public static final int CMD_LOGGER_DISABLE_ALL = 9;
    public static final int CMD_LOGGER_ENABLE_ALL = 10;
    public static final int CMD_LOGGER_RESET_ALL = 11;
    public static final int CMD_SNAPSHOT_ALL = 12;
    private int endianVal;
    private TargetEncoder enc;

    public RtaService(TargetEncoder targetEncoder, UIAPacket.Endianess endianess) {
        this.enc = targetEncoder;
        this.endianVal = UIAPacket.getEndianessValue((UIAPacket.Endianess)endianess);
    }

    public byte[] getStartCmd(int n) {
        long[] lArray = new long[]{};
        return this.getCommand(n, 7, lArray);
    }

    public byte[] getStopCmd(int n) {
        long[] lArray = new long[]{};
        return this.getCommand(n, 8, lArray);
    }

    public byte[] getSetPeriodCmd(int n, int n2) {
        long[] lArray = new long[]{n2};
        return this.getCommand(n, 6, lArray);
    }

    public byte[] getWriteMaskCmd(int n, long l, long l2) {
        long[] lArray = new long[]{l, l2};
        return this.getCommand(n, 1, lArray);
    }

    public byte[] getReadMaskCmd(int n, long l) {
        long[] lArray = new long[]{l};
        return this.getCommand(n, 0, lArray);
    }

    public byte[] getCpuFreqCmd(int n) {
        long[] lArray = new long[]{};
        return this.getCommand(n, 4, lArray);
    }

    public byte[] getLoggerDisableCmd(int n, int n2) {
        long[] lArray = new long[]{n2};
        return this.getCommand(n, 2, lArray);
    }

    public byte[] getLoggerEnableCmd(int n, int n2) {
        long[] lArray = new long[]{n2};
        return this.getCommand(n, 3, lArray);
    }

    public byte[] getLoggerResetCmd(int n, int n2) {
        long[] lArray = new long[]{n2};
        return this.getCommand(n, 5, lArray);
    }

    public byte[] getLoggerDisableAllCmd(int n) {
        long[] lArray = new long[]{};
        return this.getCommand(n, 9, lArray);
    }

    public byte[] getLoggerEnableAllCmd(int n) {
        long[] lArray = new long[]{};
        return this.getCommand(n, 10, lArray);
    }

    public byte[] getLoggerResetAllCmd(int n) {
        long[] lArray = new long[]{};
        return this.getCommand(n, 11, lArray);
    }

    public byte[] getLoggerSnapshotAll(int n, long l, long l2) {
        long[] lArray = new long[]{l, l2};
        return this.getCommand(n, 12, lArray);
    }

    public byte[] getCommand(int n, int n2, long[] lArray) {
        MessagePacketHeader messagePacketHeader = new MessagePacketHeader();
        int n3 = MessagePacketHeader.getHeaderSize() + 4 * lArray.length;
        messagePacketHeader.setPayloadEndian(this.endianVal);
        messagePacketHeader.setMsgType(MessagePacketHeader.EnumMsgType.CMD);
        messagePacketHeader.setServiceId(this.rtaServiceId);
        messagePacketHeader.setTag(305419896);
        messagePacketHeader.setSrcAddr(65535);
        messagePacketHeader.setSeqNum(1);
        messagePacketHeader.setDestAddr(n);
        messagePacketHeader.setCmdId(n2);
        messagePacketHeader.setMsgLength(n3);
        byte[] byArray = new byte[n3];
        try {
            messagePacketHeader.write(byArray, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n4 = MessagePacketHeader.getHeaderSize();
        int n5 = 4;
        for (int i = 0; i < lArray.length; ++i) {
            this.enc.encodeBytes(byArray, n4 + n5 * i, lArray[i], n5);
        }
        return byArray;
    }
}

