/*
 * Decompiled with CFR 0.152.
 */
package ti.uia.sysbios;

import xdc.rov.MemoryImage;
import xdc.rov.TargetDecoder;
import xdc.rov.TargetType;
import xdc.rta.HostEvent;
import xdc.rta.IEventMetaData;
import xdc.rta.MetaData;

public class LoggerIdleDecoder {
    private static boolean isDebugPrintEnabled = false;
    private TargetDecoder targDec;
    private IEventMetaData meta;
    private int bitsPerChar;
    private boolean isBigEndian;
    private static final int UIAPACKET_HDRSIZE = 16;
    private static final int EVENTHDR_WORDSIZE = 4;
    private static final int UIAPACKET_HDRTYPE_MASK = 240;
    private static final int UIAPACKET_ENDIANNESS_MASK = 8;
    private static final int UIAPACKET_LENGTH_MASK = -249;
    private static final int UIAPACKET_HDRTYPE_MASK_BE = -268435456;
    private static final int UIAPACKET_ENDIANNESS_MASK_BE = 0x8000000;
    private static final int UIAPACKET_LENGTH_MASK_BE = 0x7FFFFFF;
    private static final int EVENTHDR_HDRTYPE_MASK = -134217728;
    private static final int EVENTHDR_LENGTH_MASK = 0x7FF0000;
    private static final int EVENTHDR_SEQCOUNT_MASK = 65535;
    private static final int EVENTHDR_EVENTID_MASK = -65536;
    private static final int EVENTHDR_MODULEID_MASK = 65535;
    private static final int EVENTHDR_HDRTYPE_EVENT = 0;
    private static final int EVENTHDR_HDRTYPE_EVENT_TIMESTAMP64 = 1;

    public LoggerIdleDecoder(MetaData metaData) {
        this.meta = metaData;
        this.bitsPerChar = metaData.getBitsPerChar();
        this.targDec = new TargetDecoder(metaData.getEndianess(), this.bitsPerChar);
        this.isBigEndian = metaData.getEndianess() == TargetType.Endianess.BIG;
    }

    public LoggerIdleDecoder(TargetType.Endianess endianess, int n, IEventMetaData iEventMetaData) {
        this.meta = iEventMetaData;
        this.bitsPerChar = n;
        this.targDec = new TargetDecoder(endianess, n);
        this.isBigEndian = endianess == TargetType.Endianess.BIG;
    }

    public int getPacketHdrType(MemoryImage memoryImage, long l) throws Exception {
        byte[] byArray = memoryImage.readBytes(l, 16, true);
        long l2 = this.targDec.decodeBytes(byArray, 0, 4, false);
        LoggerIdleDecoder.debugPrint("getPacketHdrType: word1 = 0x" + Long.toHexString(l2));
        long l3 = this.isBigEndian ? LoggerIdleDecoder.readVal(l2, -268435456L) : LoggerIdleDecoder.readVal(l2, 240L);
        LoggerIdleDecoder.debugPrint("getPacketHdrType: hdrType = 0x" + Long.toHexString(l3));
        return (int)l3;
    }

    public HostEvent decodeEvent(byte[] byArray, int n, int n2) {
        int n3;
        HostEvent hostEvent = new HostEvent(this.meta);
        if (n2 < n + 8) {
            System.out.println("ERROR: event header was less than two words!");
            return null;
        }
        long l = this.targDec.decodeBytes(byArray, n, 4, false);
        LoggerIdleDecoder.debugPrint("UIA: in decodeEvent: word1 = 0x" + Long.toHexString(l));
        long l2 = this.targDec.decodeBytes(byArray, n + 4, 4, false);
        LoggerIdleDecoder.debugPrint("UIA: in decodeEvent: word2 = 0x" + Long.toHexString(l2));
        long l3 = LoggerIdleDecoder.readVal(l, -134217728L);
        long l4 = LoggerIdleDecoder.readVal(l, 0x7FF0000L);
        if (l4 == 0L) {
            System.out.println("ERROR: Decoded event with event length of 0!");
            return null;
        }
        hostEvent.sequenceNum = LoggerIdleDecoder.readVal(l, 65535L);
        LoggerIdleDecoder.debugPrint("UIA: in decodeEvent: hdrType = " + l3 + ", event length = " + l4);
        if (l3 == 1L) {
            long l5 = this.targDec.decodeBytes(byArray, n + 8, 4, false);
            LoggerIdleDecoder.debugPrint("UIA: in decodeEvent: word3 = 0x" + Long.toHexString(l5));
            long l6 = this.targDec.decodeBytes(byArray, n + 12, 4, false);
            LoggerIdleDecoder.debugPrint("UIA: in decodeEvent: word4 = 0x" + Long.toHexString(l6));
            hostEvent.timestamp = (double)l5 >= Math.pow(2.0, 31.0) ? -1L : (long)((double)l5 * Math.pow(2.0, 32.0) + (double)l2);
            hostEvent.eventId = Math.abs((int)LoggerIdleDecoder.readVal(l6, -65536L));
            hostEvent.moduleId = Math.abs((int)LoggerIdleDecoder.readVal(l6, 65535L));
            n3 = 16;
        } else if (l3 == 0L) {
            hostEvent.eventId = Math.abs((int)LoggerIdleDecoder.readVal(l2, -65536L));
            hostEvent.moduleId = Math.abs((int)LoggerIdleDecoder.readVal(l2, 65535L));
            n3 = 8;
        } else {
            LoggerIdleDecoder.debugPrint("UIA: ERROR in decodeEvent: Unsupported event type " + l3);
            return null;
        }
        int n4 = 0;
        while ((long)n3 < l4 && n3 + n < n2) {
            hostEvent.args[n4] = (int)this.targDec.decodeBytes(byArray, n + n3, 4, true);
            if (hostEvent.eventId == 0 && n4 == 0) {
                hostEvent.formatAddr = this.targDec.decodeBytes(byArray, n + n3, 4, false);
            }
            LoggerIdleDecoder.debugPrint("UIA: in decodeEvent: args[" + n4 + "] = 0x" + Integer.toHexString(hostEvent.args[n4]));
            n3 += 4;
            ++n4;
        }
        LoggerIdleDecoder.debugPrint("UIA: returning from decodeEvent");
        return hostEvent;
    }

    public byte[] readTargetBuffer(MemoryImage memoryImage, long l, long l2, long l3, long l4) throws Exception {
        LoggerIdleDecoder.debugPrint("LoggerIdleDecoder: bufferAddr = 0x" + Long.toHexString(l) + ", readPtr = 0x" + Long.toHexString(l2) + " writePtr = 0x" + Long.toHexString(l3));
        int n = this.bitsPerChar / 8;
        if (l3 > l2) {
            int n2 = (int)(l3 - l2) * n;
            LoggerIdleDecoder.debugPrint("LoggerIdleDecoder: writePtr > readPtr. Reading at 0x" + Long.toHexString(l2) + ", " + n2 + " bytes.");
            return memoryImage.readBytes(l2, n2, true);
        }
        int n3 = (int)l4 + 4 / n;
        int n4 = (int)((long)n3 - l2) * n;
        int n5 = (int)(l3 - l) * n;
        if (n4 < 0 || n5 < 0 || n4 == 0 && n5 == 0) {
            LoggerIdleDecoder.debugPrint("LoggerIdleDecoder: Unable to read buffer with given input: bufferAddr = " + Long.toHexString(l) + ", writePtr: " + Long.toHexString(l3) + ", readPtr: " + Long.toHexString(l2) + ", bufferEnd: " + Long.toHexString(l4));
            return null;
        }
        int n6 = (int)((long)n3 - l);
        byte[] byArray = memoryImage.readBytes(l, n6, true);
        byte[] byArray2 = new byte[n4 + n5];
        int n7 = (int)(l2 - l) * n;
        if (n4 > 0) {
            System.arraycopy(byArray, n7, byArray2, 0, n4);
        }
        if (n5 > 0) {
            System.arraycopy(byArray, 0, byArray2, n4, n5);
        }
        return byArray2;
    }

    public int getEventLength(byte[] byArray, int n) {
        long l = this.targDec.decodeBytes(byArray, n, 4, false);
        long l2 = LoggerIdleDecoder.readVal(l, 0x7FF0000L);
        LoggerIdleDecoder.debugPrint("eventLen = 0x" + Long.toHexString(l2));
        return (int)l2;
    }

    public int getEventHdrType(byte[] byArray, int n) {
        long l = this.targDec.decodeBytes(byArray, n, 4, false);
        long l2 = LoggerIdleDecoder.readVal(l, -134217728L);
        LoggerIdleDecoder.debugPrint("eventHdrType = 0x" + Long.toHexString(l2));
        return (int)l2;
    }

    public int getNumRecords(byte[] byArray, int n) {
        long l;
        int n2;
        int n3 = 0;
        for (int i = 0; i < n && (n2 = (int)LoggerIdleDecoder.readVal(l = this.targDec.decodeBytes(byArray, i, 4, false), 0x7FF0000L)) > 0; i += n2) {
            ++n3;
        }
        return n3;
    }

    public static long readVal(long l, long l2) {
        return (l & l2) >> LoggerIdleDecoder.getShiftCount(l2);
    }

    public static String getDebugMsg(HostEvent hostEvent) {
        String string = "#" + hostEvent.sequenceNum + ": EvtID=0x" + Integer.toHexString(hostEvent.eventId) + " cyc=" + hostEvent.timestamp + " modID=0x" + Integer.toHexString(hostEvent.moduleId) + " [";
        for (int i = 0; i < hostEvent.args.length; ++i) {
            if (i < 8) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + "0x" + Integer.toHexString(Math.abs(hostEvent.args[i]));
                continue;
            }
            if (i != 8) continue;
            string = string + "...";
        }
        string = string + "]";
        return string;
    }

    public static int getShiftCount(long l) {
        int n = 0;
        while ((l & 1L) == 0L) {
            l >>= 1;
            ++n;
        }
        return n;
    }

    public String getReadableEvent(HostEvent hostEvent) {
        return "[" + hostEvent.timestamp + "] #" + hostEvent.sequenceNum + ": " + this.getShortModName(this.meta.lookupModuleName(hostEvent.moduleId)) + " " + hostEvent.getEventMsg();
    }

    public String getShortModName(String string) {
        String string2 = string;
        string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        return string2;
    }

    private static void debugPrint(String string) {
        if (isDebugPrintEnabled) {
            System.out.println(string);
        }
    }
}

