/*
 * Decompiled with CFR 0.152.
 */
package ti.uia.scripts;

import java.io.File;
import java.io.FileInputStream;
import ti.uia.runtime.EventPacketHeader;
import ti.uia.scripts.PacketProcessor;
import xdc.rta.HostEvent;

public class FileProcessor
extends PacketProcessor {
    FileInputStream fis = null;

    public FileProcessor(String string, String string2, String string3, String string4) throws Exception {
        super(string, string2, string4);
        if (string3 == null || string3.equals("")) {
            throw new Exception("inputFile must be specified.");
        }
        if (!new File(string3).exists()) {
            throw new Exception("inputFile: " + string3 + " does not exist.");
        }
        File file = new File(string3);
        this.fis = new FileInputStream(file);
    }

    public EventPacketHeader readNextEventHeader(boolean bl) throws Exception {
        if (this.fis.available() == 0) {
            return null;
        }
        byte[] byArray = new byte[16];
        this.fis.read(byArray, 0, 16);
        EventPacketHeader eventPacketHeader = this.readEventHeader(byArray, bl);
        return eventPacketHeader;
    }

    public HostEvent[] readPacketBody(EventPacketHeader eventPacketHeader, PacketProcessor.PrintLevel printLevel) throws Exception {
        int n = eventPacketHeader.getEventLength() - 16;
        byte[] byArray = new byte[n];
        this.fis.read(byArray, 0, n);
        return this.readPacketBody(eventPacketHeader, byArray, 0, printLevel);
    }

    public void discardNextPacket() throws Exception {
        EventPacketHeader eventPacketHeader = this.readNextEventHeader(false);
        int n = eventPacketHeader.getEventLength() - 16;
        this.fis.skip(n);
    }

    @Override
    public void close() throws Exception {
        if (this.fis != null) {
            this.fis.close();
        }
        if (this.fw != null) {
            this.fw.close();
        }
    }
}

