/*
 * Decompiled with CFR 0.152.
 */
package ti.uia.scripts;

import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import ti.uia.runtime.EventPacketHeader;
import ti.uia.runtime.SequenceAdjust;
import ti.uia.sysbios.LoggerIdleDecoder;
import xdc.rta.HostEvent;
import xdc.rta.MetaData;

public class PacketProcessor {
    private String executable;
    private String rtaXml;
    private MetaData meta;
    private LoggerIdleDecoder loggerDec;
    private SequenceAdjust seqAdj;
    FileWriter fw = null;

    public PacketProcessor(String string, String string2, String string3) throws Exception {
        this.executable = string;
        this.rtaXml = string2;
        this.meta = new MetaData();
        String string4 = "";
        string4 = this.rtaXml != null ? this.meta.parse(this.rtaXml, this.executable) : this.meta.parseFromExec(this.executable);
        if (!string4.equals("")) {
            throw new Exception("MetaData.parse failed: " + string4);
        }
        this.loggerDec = new LoggerIdleDecoder(this.meta);
        this.seqAdj = new SequenceAdjust(this.meta);
        if (string3 != null) {
            File file = new File(string3);
            this.fw = new FileWriter(file);
            this.fw.write("Core,PacketNum,Timestamp,SeqNum,Msg,Logger\n");
        }
    }

    public EventPacketHeader readEventHeader(byte[] byArray, boolean bl) throws Exception {
        EventPacketHeader eventPacketHeader = new EventPacketHeader();
        eventPacketHeader.read(byArray, 0);
        if (bl) {
            eventPacketHeader.printHeader();
        }
        return eventPacketHeader;
    }

    public HostEvent[] readPacketBody(EventPacketHeader eventPacketHeader, byte[] byArray, int n, PrintLevel printLevel) throws Exception {
        Vector<HostEvent> vector = new Vector<HostEvent>();
        int n2 = eventPacketHeader.getEventLength() - 16;
        int n3 = n + n2;
        while (n < n3) {
            HostEvent hostEvent = this.loggerDec.decodeEvent(byArray, n, n3);
            if (hostEvent == null) {
                throw new Exception("PacketProcessor received null event!");
            }
            this.seqAdj.adjustSeqNum(hostEvent, eventPacketHeader.getSenderAddr(), eventPacketHeader.getInstanceId());
            vector.add(hostEvent);
            n += this.loggerDec.getEventLength(byArray, n);
            if (printLevel == PrintLevel.DEBUG) {
                System.out.println(LoggerIdleDecoder.getDebugMsg((HostEvent)hostEvent));
            } else if (printLevel == PrintLevel.READABLE) {
                System.out.println(this.loggerDec.getReadableEvent(hostEvent));
            }
            if (this.fw == null) continue;
            this.fw.write(eventPacketHeader.getSenderAddr() + "," + eventPacketHeader.getPacketSeqNum() + "," + hostEvent.timestamp + "," + hostEvent.sequenceNum + "," + hostEvent.getEventMsg() + "," + eventPacketHeader.getInstanceId() + "\n");
        }
        return vector.toArray(new HostEvent[0]);
    }

    public void close() throws Exception {
        if (this.fw != null) {
            this.fw.close();
        }
    }

    public MetaData getMetaData() {
        return this.meta;
    }

    public LoggerIdleDecoder getDecoder() {
        return this.loggerDec;
    }

    public static enum PrintLevel {
        DEBUG,
        READABLE,
        NONE;

    }
}

