/*
 * Decompiled with CFR 0.152.
 */
package ti.uia.loggers;

import xdc.rov.MemoryImage;
import xdc.rov.TargetDecoder;
import xdc.rov.TargetType;
import xdc.rta.HostEvent;
import xdc.rta.IEventMetaData;
import xdc.rta.MetaData;

public class LoggerMinDecoder {
    private static boolean isDebugPrintEnabled = true;
    private TargetDecoder targDec;
    private IEventMetaData meta;
    private int bitsPerChar;
    private boolean isBigEndian;
    private static final int UIAPACKET_HDRSIZE = 4;
    private static final int EVENTHDR_WORDSIZE = 4;
    private static final int UIAPACKET_HDRTYPE_MASK = 240;
    private static final int UIAPACKET_ENDIANNESS_MASK = 8;
    private static final int UIAPACKET_LENGTH_MASK = -65536;
    private static final int UIAPACKET_HDRTYPE_MASK_BE = -268435456;
    private static final int UIAPACKET_ENDIANNESS_MASK_BE = 0x8000000;
    private static final int UIAPACKET_LENGTH_MASK_BE = 65535;
    private static final int EVENTHDR_HDRTYPE_MASK = -134217728;
    private static final int EVENTHDR_LENGTH_MASK = 0x7FF0000;
    private static final int EVENTHDR_SEQCOUNT_MASK = 31;
    private static final int EVENTHDR_PREVLEN_MASK = 4064;
    private static final int EVENTHDR_EVENTID_MASK = -65536;
    private static final int EVENTHDR_MODULEID_MASK = 65535;
    private static final int EVENTHDR_HDRTYPE_EVENTWITHPREVLEN = 8;
    private static final int EVENTHDR_HDRTYPE_EVENTWITHPREVLEN_TIMESTAMP32 = 9;
    private static final int EVENTHDR_HDRTYPE_EVENTWITHPREVLEN_TIMESTAMP64 = 10;

    public LoggerMinDecoder(MetaData metaData) {
        this.meta = metaData;
        this.bitsPerChar = metaData.getBitsPerChar();
        this.targDec = new TargetDecoder(metaData.getEndianess(), this.bitsPerChar);
        this.isBigEndian = metaData.getEndianess() == TargetType.Endianess.BIG;
    }

    public LoggerMinDecoder(TargetType.Endianess endianess, int n, IEventMetaData iEventMetaData) {
        this.meta = iEventMetaData;
        this.bitsPerChar = n;
        this.targDec = new TargetDecoder(endianess, n);
        this.isBigEndian = endianess == TargetType.Endianess.BIG;
    }

    public int getPacketHdrType(MemoryImage memoryImage, long l) throws Exception {
        byte[] byArray = memoryImage.readBytes(l, 4, true);
        long l2 = this.targDec.decodeBytes(byArray, 0, 4, false);
        LoggerMinDecoder.debugPrint("getPacketHdrType: word1 = 0x" + Long.toHexString(l2));
        long l3 = this.isBigEndian ? LoggerMinDecoder.readVal(l2, -268435456L) : LoggerMinDecoder.readVal(l2, 240L);
        LoggerMinDecoder.debugPrint("getPacketHdrType: hdrType = 0x" + Long.toHexString(l3));
        return (int)l3;
    }

    public int getPacketLength(MemoryImage memoryImage, long l) throws Exception {
        long l2;
        byte[] byArray = memoryImage.readBytes(l, 4, true);
        long l3 = this.targDec.decodeBytes(byArray, 0, 4, false);
        LoggerMinDecoder.debugPrint("word1 = 0x" + Long.toHexString(l3));
        if (this.isBigEndian) {
            l2 = LoggerMinDecoder.readVal(l3, 65535L);
        } else {
            l2 = LoggerMinDecoder.readVal(l3, -65536L);
            long l4 = l2 >> 8 & 0xFFL;
            LoggerMinDecoder.debugPrint("packetLength >> 8 = 0x" + Long.toHexString(l4));
            l4 = l2 << 8 & 0xFF00L;
            LoggerMinDecoder.debugPrint("packetLength << 8 = 0x" + Long.toHexString(l4));
            l4 = l2;
            l2 = (l4 >> 8 & 0xFFL) + (l4 << 8 & 0xFF00L);
            LoggerMinDecoder.debugPrint("packetLength = 0x" + Long.toHexString(l2));
        }
        LoggerMinDecoder.debugPrint("packetLength = 0x" + Long.toHexString(l2));
        return (int)l2;
    }

    public HostEvent decodeEvent(byte[] byArray, int n, int n2) {
        int n3;
        long l;
        HostEvent hostEvent = new HostEvent(this.meta);
        if (n2 < n + 8) {
            System.out.println("ERROR: event header was less than two words!");
            return null;
        }
        long l2 = this.targDec.decodeBytes(byArray, n, 4, false);
        LoggerMinDecoder.debugPrint("UIA: in decodeEvent: word1 = 0x" + Long.toHexString(l2));
        long l3 = this.targDec.decodeBytes(byArray, n + 4, 4, false);
        LoggerMinDecoder.debugPrint("UIA: in decodeEvent: word2 = 0x" + Long.toHexString(l3));
        long l4 = LoggerMinDecoder.readVal(l2, -134217728L);
        long l5 = LoggerMinDecoder.readVal(l2, 0x7FF0000L);
        if (l5 == 0L) {
            System.out.println("ERROR: Decoded event with event length of 0!");
            return null;
        }
        hostEvent.sequenceNum = LoggerMinDecoder.readVal(l2, 31L);
        LoggerMinDecoder.debugPrint("UIA: in decodeEvent: hdrType = " + l4 + ", event length = " + l5);
        if (l4 == 10L) {
            l = this.targDec.decodeBytes(byArray, n + 8, 4, false);
            LoggerMinDecoder.debugPrint("UIA: in decodeEvent: word3 = 0x" + Long.toHexString(l));
            long l6 = this.targDec.decodeBytes(byArray, n + 12, 4, false);
            LoggerMinDecoder.debugPrint("UIA: in decodeEvent: word4 = 0x" + Long.toHexString(l6));
            hostEvent.timestamp = (double)l >= Math.pow(2.0, 31.0) ? -1L : (long)((double)l * Math.pow(2.0, 32.0) + (double)l3);
            hostEvent.eventId = Math.abs((int)LoggerMinDecoder.readVal(l6, -65536L));
            hostEvent.moduleId = Math.abs((int)LoggerMinDecoder.readVal(l6, 65535L));
            n3 = 16;
        } else if (l4 == 9L) {
            l = this.targDec.decodeBytes(byArray, n + 8, 4, false);
            LoggerMinDecoder.debugPrint("UIA: in decodeEvent: word3 = 0x" + Long.toHexString(l));
            hostEvent.timestamp = l3;
            hostEvent.eventId = Math.abs((int)LoggerMinDecoder.readVal(l, -65536L));
            hostEvent.moduleId = Math.abs((int)LoggerMinDecoder.readVal(l, 65535L));
            n3 = 12;
        } else if (l4 == 8L) {
            hostEvent.eventId = Math.abs((int)LoggerMinDecoder.readVal(l3, -65536L));
            hostEvent.moduleId = Math.abs((int)LoggerMinDecoder.readVal(l3, 65535L));
            n3 = 8;
        } else {
            LoggerMinDecoder.debugPrint("UIA: ERROR in decodeEvent: Unknown event type " + l4);
            return null;
        }
        int n4 = 0;
        while ((long)n3 < l5 && n3 + n < n2) {
            hostEvent.args[n4] = (int)this.targDec.decodeBytes(byArray, n + n3, 4, true);
            if (hostEvent.eventId == 0 && n4 == 0) {
                hostEvent.formatAddr = this.targDec.decodeBytes(byArray, n + n3, 4, false);
            }
            LoggerMinDecoder.debugPrint("UIA: in decodeEvent: args[" + n4 + "] = 0x" + Integer.toHexString(hostEvent.args[n4]));
            n3 += 4;
            ++n4;
        }
        LoggerMinDecoder.debugPrint("UIA: returning from decodeEvent");
        return hostEvent;
    }

    public byte[] readTargetBuffer(MemoryImage memoryImage, long l, long l2) throws Exception {
        int n = this.bitsPerChar / 8;
        int n2 = this.getPacketLength(memoryImage, l);
        long l3 = l + (long)(4 / n);
        long l4 = l + (long)(n2 / n);
        if (l2 > l4) {
            int n3 = (int)(l2 - l3) * n;
            LoggerMinDecoder.debugPrint("LoggerMinDecoder: Write > packet length. Reading at 0x" + Long.toHexString(l3) + ", " + n3 + " bytes.");
            return memoryImage.readBytes(l3, n3, true);
        }
        long l5 = l4 + (long)(4 / n);
        int n4 = n2 - 4 + 4;
        int n5 = (int)(l2 - l3) * n;
        LoggerMinDecoder.debugPrint("LoggerMinDecoder: writePtr < packet length. Reading " + n4 + " bytes from 0x" + Long.toHexString(l3) + " to 0x" + Long.toHexString(l5));
        byte[] byArray = memoryImage.readBytes(l3, n4, true);
        int n6 = n4 - 4;
        int n7 = this.getReadPtr(byArray, n5, n6);
        LoggerMinDecoder.debugPrint("LoggerMinDecoder: readPtr = 0x" + Long.toHexString(l3 + (long)(n7 / n)));
        int n8 = 0;
        int n9 = n5;
        if (n7 >= n5) {
            n8 = n6 - n7;
        }
        byte[] byArray2 = new byte[n8 + n9];
        if (n7 >= n5) {
            System.arraycopy(byArray, n7, byArray2, 0, n8);
        }
        System.arraycopy(byArray, 0, byArray2, n8, n9);
        return byArray2;
    }

    public int getEventLength(byte[] byArray, int n) {
        long l = this.targDec.decodeBytes(byArray, n, 4, false);
        long l2 = LoggerMinDecoder.readVal(l, 0x7FF0000L);
        LoggerMinDecoder.debugPrint("eventLen = 0x" + Long.toHexString(l2));
        return (int)l2;
    }

    public int getEventHdrType(byte[] byArray, int n) {
        long l = this.targDec.decodeBytes(byArray, n, 4, false);
        long l2 = LoggerMinDecoder.readVal(l, -134217728L);
        LoggerMinDecoder.debugPrint("eventHdrType = 0x" + Long.toHexString(l2));
        return (int)l2;
    }

    public int getNumRecords(byte[] byArray, int n) {
        long l;
        int n2;
        int n3 = 0;
        for (int i = 0; i < n && (n2 = (int)LoggerMinDecoder.readVal(l = this.targDec.decodeBytes(byArray, i, 4, false), 0x7FF0000L)) > 0; i += n2) {
            ++n3;
        }
        return n3;
    }

    public int getPrevEventLength(byte[] byArray, int n) {
        long l = this.targDec.decodeBytes(byArray, n, 4, false);
        long l2 = LoggerMinDecoder.readVal(l, 4064L);
        LoggerMinDecoder.debugPrint("getPrevEventLength(): word1 = 0x" + Long.toHexString(l));
        LoggerMinDecoder.debugPrint("getPrevEventLength: prevEventLen = 0x" + Long.toHexString(l2));
        return (int)l2;
    }

    public int getReadPtr(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            LoggerMinDecoder.debugPrint("getReadPtr(): Returning start of buffer");
            return 0;
        }
        int n3 = n2;
        int n4 = n2;
        long l = this.targDec.decodeBytes(byArray, n3, 4, false);
        long l2 = LoggerMinDecoder.readVal(l, 4064L);
        long l3 = 0L;
        LoggerMinDecoder.debugPrint("getReadPtr(): word1 = 0x" + Long.toHexString(l));
        LoggerMinDecoder.debugPrint("prevEventLen = 0x" + Long.toHexString(l2));
        while (n4 > n) {
            if ((n3 -= (int)l2) < n) {
                LoggerMinDecoder.debugPrint("No more records");
                break;
            }
            l3 = this.getEventLength(byArray, n3);
            if (l3 == l2) {
                int n5 = this.getEventHdrType(byArray, n3);
                if (n5 != 10 && n5 != 9 && n5 != 8) {
                    LoggerMinDecoder.debugPrint("eventType not good: 0x" + Long.toHexString(n5));
                    break;
                }
                n4 = n3;
                l2 = this.getPrevEventLength(byArray, n3);
                LoggerMinDecoder.debugPrint("Found whole record, setting readPtrOffset to 0x" + Long.toHexString(n4));
                LoggerMinDecoder.debugPrint("Next prevEventLen = 0x" + Long.toHexString(l2));
                continue;
            }
            LoggerMinDecoder.debugPrint("Did not find whole record");
            break;
        }
        if (n4 == n2) {
            n4 = 0;
        }
        return n4;
    }

    public static long readVal(long l, long l2) {
        return (l & l2) >> LoggerMinDecoder.getShiftCount(l2);
    }

    public static int getShiftCount(long l) {
        int n = 0;
        while ((l & 1L) == 0L) {
            l >>= 1;
            ++n;
        }
        return n;
    }

    public String getReadableEvent(HostEvent hostEvent) {
        return "[" + hostEvent.timestamp + "] #" + hostEvent.sequenceNum + ": " + this.getShortModName(this.meta.lookupModuleName(hostEvent.moduleId)) + " " + hostEvent.getEventMsg();
    }

    public String getShortModName(String string) {
        String string2 = string;
        string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        return string2;
    }

    private static void debugPrint(String string) {
        if (isDebugPrintEnabled) {
            System.out.println(string);
        }
    }
}

