/*
 * Decompiled with CFR 0.152.
 */
package ti.uia.loggers;

import xdc.rov.MemoryImage;
import xdc.rov.TargetDecoder;
import xdc.rov.TargetType;
import xdc.rta.HostEvent;
import xdc.rta.IEventMetaData;
import xdc.rta.MetaData;

public class LoggerRunModeDecoder {
    private static boolean isDebugPrintEnabled = true;
    private TargetDecoder targDec;
    private IEventMetaData meta;
    private int bitsPerChar;
    private boolean isBigEndian;
    private static final int UIAPACKET_HDRSIZE = 16;
    private static final int EVENTHDR_WORDSIZE = 4;
    private static final int UIAPACKET_HDRTYPE_MASK = 240;
    private static final int UIAPACKET_ENDIANNESS_MASK = 8;
    private static final int UIAPACKET_EVENT_SEQ_MASK = -65536;
    private static final int UIAPACKET_EVENT_SEQ_SHIFT = 2;
    private static final int UIAPACKET_PACKET_SEQ_MASK = 65535;
    private static final int UIAPACKET_LENGTH_MASK = -249;
    private static final int UIAPACKET_HDRTYPE_MASK_BE = -268435456;
    private static final int UIAPACKET_ENDIANNESS_MASK_BE = 0x8000000;
    private static final int UIAPACKET_LENGTH_MASK_BE = 0x7FFFFFF;
    private static final int UIAPACKET_EVENT_SEQ_MASK_BE = 65535;
    private static final int UIAPACKET_PACKET_SEQ_MASK_BE = -65536;
    private static final int EVENTHDR_HDRTYPE_MASK = -134217728;
    private static final int EVENTHDR_LENGTH_MASK = 0x7FF0000;
    private static final int EVENTHDR_SEQCOUNT_MASK = 31;
    private static final int EVENTHDR_PREVLEN_MASK = 4064;
    private static final int EVENTHDR_EVENTID_MASK = -65536;
    private static final int EVENTHDR_MODULEID_MASK = 65535;
    private static final int EVENTHDR_HDRTYPE_EVENTWITHPREVLEN = 8;
    private static final int EVENTHDR_HDRTYPE_EVENTWITHPREVLEN_TIMESTAMP64 = 10;
    private static final int EVENTHDR_HDRTYPE_SNAPSHOT_EVENTWITHPREVLEN = 11;
    private static final int EVENTHDR_HDRTYPE_SNAPSHOT_EVENTWITHPREVLEN_TIMESTAMP64 = 12;

    public LoggerRunModeDecoder(MetaData metaData) {
        this.meta = metaData;
        this.bitsPerChar = metaData.getBitsPerChar();
        this.targDec = new TargetDecoder(metaData.getEndianess(), this.bitsPerChar);
        this.isBigEndian = metaData.getEndianess() == TargetType.Endianess.BIG;
    }

    public LoggerRunModeDecoder(TargetType.Endianess endianess, int n, IEventMetaData iEventMetaData) {
        this.meta = iEventMetaData;
        this.bitsPerChar = n;
        this.targDec = new TargetDecoder(endianess, n);
        this.isBigEndian = endianess == TargetType.Endianess.BIG;
    }

    public int getPacketHdrType(MemoryImage memoryImage, long l) throws Exception {
        byte[] byArray = memoryImage.readBytes(l, 16, true);
        long l2 = this.targDec.decodeBytes(byArray, 0, 4, false);
        LoggerRunModeDecoder.debugPrint("getPacketHdrType: word1 = 0x" + Long.toHexString(l2));
        long l3 = this.isBigEndian ? LoggerRunModeDecoder.readVal(l2, -268435456L) : LoggerRunModeDecoder.readVal(l2, 240L);
        LoggerRunModeDecoder.debugPrint("getPacketHdrType: hdrType = 0x" + Long.toHexString(l3));
        return (int)l3;
    }

    public int getPacketLength(MemoryImage memoryImage, long l) throws Exception {
        long l2;
        byte[] byArray = memoryImage.readBytes(l, 16, true);
        long l3 = this.targDec.decodeBytes(byArray, 0, 4, false);
        LoggerRunModeDecoder.debugPrint("word1 = 0x" + Long.toHexString(l3));
        if (this.isBigEndian) {
            l2 = LoggerRunModeDecoder.readVal(l3, 0x7FFFFFFL);
        } else {
            l2 = LoggerRunModeDecoder.readVal(l3, -249L);
            LoggerRunModeDecoder.debugPrint("packetLength = 0x" + Long.toHexString(l2));
            long l4 = l2 >> 8 & 0xFF00L;
            LoggerRunModeDecoder.debugPrint("packetLength >> 8 = 0x" + Long.toHexString(l4));
            l4 = l2 << 8 & 0xFF0000L;
            LoggerRunModeDecoder.debugPrint("packetLength << 8 = 0x" + Long.toHexString(l4));
            l4 = (l2 & 0xFFL) << 24 & 0xFFFFFFFFFF000000L;
            LoggerRunModeDecoder.debugPrint("packetLength << 24 = 0x" + Long.toHexString(l4));
            l4 = l2;
            l2 = (l4 >> 24 & 0xFFL) + (l4 >> 8 & 0xFF00L) + (l4 << 8 & 0xFF0000L) + ((l4 & 0xFFL) << 24 & 0xFFFFFFFFFF000000L);
        }
        LoggerRunModeDecoder.debugPrint("packetLength = 0x" + Long.toHexString(l2));
        if (l2 > 0L) {
            l2 -= 4L;
        }
        return (int)l2;
    }

    public int getPacketSequenceNum(MemoryImage memoryImage, long l) throws Exception {
        long l2;
        byte[] byArray = memoryImage.readBytes(l, 16, true);
        long l3 = this.targDec.decodeBytes(byArray, 4, 4, false);
        LoggerRunModeDecoder.debugPrint("getPacketSequenceNum: word2 = 0x" + Long.toHexString(l3));
        if (this.isBigEndian) {
            l2 = LoggerRunModeDecoder.readVal(l3, -65536L);
        } else {
            long l4 = LoggerRunModeDecoder.readVal(l3, 65535L);
            l2 = (l4 >> 8 & 0xFFL) + (l4 << 8 & 0xFF00L);
        }
        LoggerRunModeDecoder.debugPrint("getPacketSequenceNum: packetSeqNum = 0x" + Long.toHexString(l2));
        return (int)l2;
    }

    public int getPacketEventSequenceNum(MemoryImage memoryImage, long l) throws Exception {
        long l2;
        byte[] byArray = memoryImage.readBytes(l, 16, true);
        long l3 = this.targDec.decodeBytes(byArray, 4, 4, false);
        LoggerRunModeDecoder.debugPrint("getPacketSequenceNum: word2 = 0x" + Long.toHexString(l3));
        if (this.isBigEndian) {
            l2 = LoggerRunModeDecoder.readVal(l3, 65535L);
            l2 >>= 2;
        } else {
            long l4 = LoggerRunModeDecoder.readVal(l3, -65536L);
            l2 = (l4 >> 8 & 0xFFL) + (l4 << 8 & 0xFF00L);
            l2 >>= 2;
        }
        LoggerRunModeDecoder.debugPrint("getPacketSequenceNum: eventSeqNum = 0x" + Long.toHexString(l2));
        return (int)l2;
    }

    public HostEvent decodeEvent(byte[] byArray, int n, int n2) {
        int n3;
        HostEvent hostEvent = new HostEvent(this.meta);
        if (n2 < n + 8) {
            System.out.println("ERROR: event header was less than two words!");
            return null;
        }
        long l = this.targDec.decodeBytes(byArray, n, 4, false);
        LoggerRunModeDecoder.debugPrint("UIA: in decodeEvent: word1 = 0x" + Long.toHexString(l));
        long l2 = this.targDec.decodeBytes(byArray, n + 4, 4, false);
        LoggerRunModeDecoder.debugPrint("UIA: in decodeEvent: word2 = 0x" + Long.toHexString(l2));
        long l3 = LoggerRunModeDecoder.readVal(l, -134217728L);
        long l4 = LoggerRunModeDecoder.readVal(l, 0x7FF0000L);
        if (l4 == 0L) {
            System.out.println("ERROR: Decoded event with event length of 0!");
            return null;
        }
        hostEvent.sequenceNum = LoggerRunModeDecoder.readVal(l, 31L);
        LoggerRunModeDecoder.debugPrint("UIA: in decodeEvent: hdrType = " + l3 + ", event length = " + l4);
        if (l3 == 10L || l3 == 12L) {
            long l5 = this.targDec.decodeBytes(byArray, n + 8, 4, false);
            LoggerRunModeDecoder.debugPrint("UIA: in decodeEvent: word3 = 0x" + Long.toHexString(l5));
            long l6 = this.targDec.decodeBytes(byArray, n + 12, 4, false);
            LoggerRunModeDecoder.debugPrint("UIA: in decodeEvent: word4 = 0x" + Long.toHexString(l6));
            hostEvent.timestamp = (double)l5 >= Math.pow(2.0, 31.0) ? -1L : (long)((double)l5 * Math.pow(2.0, 32.0) + (double)l2);
            hostEvent.eventId = Math.abs((int)LoggerRunModeDecoder.readVal(l6, -65536L));
            hostEvent.moduleId = Math.abs((int)LoggerRunModeDecoder.readVal(l6, 65535L));
            n3 = 16;
        } else if (l3 == 8L || l3 == 11L) {
            hostEvent.eventId = Math.abs((int)LoggerRunModeDecoder.readVal(l2, -65536L));
            hostEvent.moduleId = Math.abs((int)LoggerRunModeDecoder.readVal(l2, 65535L));
            n3 = 8;
        } else {
            LoggerRunModeDecoder.debugPrint("UIA: ERROR in decodeEvent: Unsupported event type " + l3);
            return null;
        }
        int n4 = 0;
        while ((long)n3 < l4 && n3 + n < n2) {
            hostEvent.args[n4] = (int)this.targDec.decodeBytes(byArray, n + n3, 4, true);
            if (hostEvent.eventId == 0 && n4 == 0) {
                hostEvent.formatAddr = this.targDec.decodeBytes(byArray, n + n3, 4, false);
            }
            LoggerRunModeDecoder.debugPrint("UIA: in decodeEvent: args[" + n4 + "] = 0x" + Integer.toHexString(hostEvent.args[n4]));
            n3 += 4;
            ++n4;
        }
        LoggerRunModeDecoder.debugPrint("UIA: returning from decodeEvent");
        return hostEvent;
    }

    public byte[] readTargetBuffer(MemoryImage memoryImage, long l, long l2, long l3) throws Exception {
        int n = this.bitsPerChar / 8;
        int n2 = this.getPacketLength(memoryImage, l);
        LoggerRunModeDecoder.debugPrint("LoggerRunModeDecoder: bufferLen = " + Long.toHexString(l2));
        long l4 = l + (long)(16 / n);
        long l5 = l + l2;
        long l6 = l + (long)(n2 / n);
        if (l3 < l || l3 >= l5) {
            if (n2 > 0) {
                int n3 = n2;
                LoggerRunModeDecoder.debugPrint("LoggerRunModeDecoder: startAddr = " + Long.toHexString(l4) + ", endAddr = " + Long.toHexString(l6) + ", writePtr = " + Long.toHexString(l3));
                LoggerRunModeDecoder.debugPrint("LoggerRunModeDecoder: startAddr = " + Long.toHexString(l4) + ", lengthBytes = " + n3);
                return memoryImage.readBytes(l4, n3, true);
            }
            return null;
        }
        int n4 = (int)(l3 - l4) * n;
        LoggerRunModeDecoder.debugPrint("LoggerRunModeDecoder: Write > packet length. Reading at 0x" + Long.toHexString(l4) + ", " + n4 + " bytes.");
        return memoryImage.readBytes(l4, n4, true);
    }

    public int getEventLength(byte[] byArray, int n) {
        long l = this.targDec.decodeBytes(byArray, n, 4, false);
        long l2 = LoggerRunModeDecoder.readVal(l, 0x7FF0000L);
        long l3 = LoggerRunModeDecoder.readVal(l, -134217728L);
        LoggerRunModeDecoder.debugPrint("LoggerRunModeDecoder.getEventLength: eventHdrType = 0x" + Long.toHexString(l3));
        LoggerRunModeDecoder.debugPrint("LoggerRunModeDecoder.getEventLength: eventLen = 0x" + Long.toHexString(l2));
        return (int)l2;
    }

    public int getEventHdrType(byte[] byArray, int n) {
        long l = this.targDec.decodeBytes(byArray, n, 4, false);
        long l2 = LoggerRunModeDecoder.readVal(l, -134217728L);
        LoggerRunModeDecoder.debugPrint("eventHdrType = 0x" + Long.toHexString(l2));
        return (int)l2;
    }

    public int getNumRecords(byte[] byArray, int n) {
        int n2;
        int n3 = 0;
        for (int i = 0; i < n; i += n2) {
            long l = this.targDec.decodeBytes(byArray, i, 4, false);
            n2 = (int)LoggerRunModeDecoder.readVal(l, 0x7FF0000L);
            long l2 = LoggerRunModeDecoder.readVal(l, -134217728L);
            if (l2 != 10L && l2 != 8L && l2 != 12L && l2 != 11L) break;
            LoggerRunModeDecoder.debugPrint("LoggerRunModeDecoder.getNumRecords(): eventLen = " + n2);
            if (n2 <= 0) break;
            ++n3;
        }
        return n3;
    }

    public int getPrevEventLength(byte[] byArray, int n) {
        long l = this.targDec.decodeBytes(byArray, n, 4, false);
        long l2 = LoggerRunModeDecoder.readVal(l, 4064L);
        LoggerRunModeDecoder.debugPrint("getPrevEventLength(): word1 = 0x" + Long.toHexString(l));
        LoggerRunModeDecoder.debugPrint("getPrevEventLength: prevEventLen = 0x" + Long.toHexString(l2));
        return (int)l2;
    }

    public int getReadPtr(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            LoggerRunModeDecoder.debugPrint("getReadPtr(): Returning start of buffer");
            return 0;
        }
        int n3 = n2;
        int n4 = n2;
        long l = this.targDec.decodeBytes(byArray, n3, 4, false);
        long l2 = LoggerRunModeDecoder.readVal(l, 4064L);
        long l3 = 0L;
        LoggerRunModeDecoder.debugPrint("getReadPtr(): word1 = 0x" + Long.toHexString(l));
        LoggerRunModeDecoder.debugPrint("prevEventLen = 0x" + Long.toHexString(l2));
        while (n4 > n) {
            if ((n3 -= (int)l2) < n) {
                LoggerRunModeDecoder.debugPrint("No more records");
                break;
            }
            l3 = this.getEventLength(byArray, n3);
            if (l3 == l2) {
                int n5 = this.getEventHdrType(byArray, n3);
                if (n5 != 10 && n5 != 8) {
                    LoggerRunModeDecoder.debugPrint("eventType not good: 0x" + Long.toHexString(n5));
                    break;
                }
                n4 = n3;
                l2 = this.getPrevEventLength(byArray, n3);
                LoggerRunModeDecoder.debugPrint("Found whole record, setting readPtrOffset to 0x" + Long.toHexString(n4));
                LoggerRunModeDecoder.debugPrint("Next prevEventLen = 0x" + Long.toHexString(l2));
                continue;
            }
            LoggerRunModeDecoder.debugPrint("Did not find whole record");
            break;
        }
        if (n4 == n2) {
            n4 = 0;
        }
        return n4;
    }

    public static long readVal(long l, long l2) {
        return (l & l2) >> LoggerRunModeDecoder.getShiftCount(l2);
    }

    public static int getShiftCount(long l) {
        int n = 0;
        while ((l & 1L) == 0L) {
            l >>= 1;
            ++n;
        }
        return n;
    }

    public static String getDebugMsg(HostEvent hostEvent) {
        String string = "#" + hostEvent.sequenceNum + ": EvtID=0x" + Integer.toHexString(hostEvent.eventId) + " cyc=" + hostEvent.timestamp + " modID=0x" + Integer.toHexString(hostEvent.moduleId) + " [";
        for (int i = 0; i < hostEvent.args.length; ++i) {
            if (i < 8) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + "0x" + Integer.toHexString(Math.abs(hostEvent.args[i]));
                continue;
            }
            if (i != 8) continue;
            string = string + "...";
        }
        string = string + "]";
        return string;
    }

    public String getReadableEvent(HostEvent hostEvent) {
        return "[" + hostEvent.timestamp + "] #" + hostEvent.sequenceNum + ": " + this.getShortModName(this.meta.lookupModuleName(hostEvent.moduleId)) + " " + hostEvent.getEventMsg();
    }

    public String getShortModName(String string) {
        String string2 = string;
        string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        return string2;
    }

    private static void debugPrint(String string) {
        if (isDebugPrintEnabled) {
            System.out.println(string);
        }
    }
}

