/*
 * Decompiled with CFR 0.152.
 */
package ti.uia.scripts.ndk;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import ti.uia.runtime.MessagePacketHeader;
import ti.uia.runtime.UIAPacket;
import ti.uia.services.RtaService;
import xdc.rov.TargetDecoder;
import xdc.rov.TargetEncoder;
import xdc.rov.TargetType;
import xdc.rta.MetaData;

public class NdkAgent {
    public String address;
    public int msgUdpPort = 1234;
    public int eventUdpPort = 1235;
    public int numProcessors = 6;
    private Socket cmdSocket;
    private DatagramSocket eventSocket;
    private OutputStream outMsg;
    private InputStream inMsg;
    private RtaService service;
    private TargetDecoder dec;

    public NdkAgent(MetaData metaData) {
        TargetEncoder targetEncoder = new TargetEncoder(metaData.getEndianess(), metaData.getBitsPerChar());
        this.service = new RtaService(targetEncoder, UIAPacket.getEndianess((TargetType.Endianess)metaData.getEndianess()));
        this.dec = new TargetDecoder(metaData.getEndianess(), metaData.getBitsPerChar());
    }

    public NdkAgent() {
        TargetEncoder targetEncoder = new TargetEncoder(TargetType.Endianess.LITTLE, 8);
        this.service = new RtaService(targetEncoder, UIAPacket.Endianess.LITTLE);
        this.dec = new TargetDecoder(TargetType.Endianess.LITTLE, 8);
    }

    public void openSockets(Boolean bl) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(this.address);
        if (bl.booleanValue()) {
            this.cmdSocket = new Socket(inetAddress, this.msgUdpPort);
            this.outMsg = this.cmdSocket.getOutputStream();
            this.inMsg = this.cmdSocket.getInputStream();
        }
        this.eventSocket = new DatagramSocket(this.eventUdpPort);
        this.eventSocket.setReceiveBufferSize(65536);
    }

    public void startAllCores() throws Exception {
        for (int i = 0; i < this.numProcessors; ++i) {
            this.sendStartCmd(i);
        }
    }

    public void setPeriodAllCores(int n) throws Exception {
        for (int i = 0; i < this.numProcessors; ++i) {
            this.sendSetPeriodCmd(i, n);
        }
    }

    public void sendStartCmd(int n) throws Exception {
        byte[] byArray = this.service.getStartCmd(n);
        System.out.println("Sending start command to core " + n);
        this.sendCmd(byArray, MessagePacketHeader.EnumMsgType.ACK, 7);
    }

    public void sendStopCmd(int n) throws Exception {
        byte[] byArray = this.service.getStopCmd(n);
        System.out.println("Sending stop command to core " + n);
        this.sendCmd(byArray, MessagePacketHeader.EnumMsgType.ACK, 8);
    }

    public void sendSetPeriodCmd(int n, int n2) throws Exception {
        byte[] byArray = this.service.getSetPeriodCmd(n, n2);
        System.out.println("Sending set period command to core " + n);
        this.sendCmd(byArray, MessagePacketHeader.EnumMsgType.ACK, 6);
    }

    public void sendLoggerEnableCmd(int n, int n2) throws Exception {
        byte[] byArray = this.service.getLoggerEnableCmd(n, n2);
        System.out.println("Sending logger enable command to core " + n + " logger " + n2);
        this.sendCmd(byArray, MessagePacketHeader.EnumMsgType.ACK, 3);
    }

    public void sendLoggerDisableCmd(int n, int n2) throws Exception {
        byte[] byArray = this.service.getLoggerDisableCmd(n, n2);
        System.out.println("Sending logger disable command to core " + n + " logger " + n2);
        this.sendCmd(byArray, MessagePacketHeader.EnumMsgType.ACK, 2);
    }

    public void sendLoggerResetCmd(int n, int n2) throws Exception {
        byte[] byArray = this.service.getLoggerResetCmd(n, n2);
        System.out.println("Sending logger reset command to core " + n + " logger " + n2);
        this.sendCmd(byArray, MessagePacketHeader.EnumMsgType.ACK, 5);
    }

    public void sendLoggerEnableAllCmd(int n) throws Exception {
        byte[] byArray = this.service.getLoggerEnableAllCmd(n);
        System.out.println("Sending logger enable all command to core " + n);
        this.sendCmd(byArray, MessagePacketHeader.EnumMsgType.ACK, 10);
    }

    public void sendLoggerDisableAllCmd(int n) throws Exception {
        byte[] byArray = this.service.getLoggerDisableAllCmd(n);
        System.out.println("Sending logger disable all command to core " + n);
        this.sendCmd(byArray, MessagePacketHeader.EnumMsgType.ACK, 9);
    }

    public void sendLoggerResetAllCmd(int n) throws Exception {
        byte[] byArray = this.service.getLoggerResetAllCmd(n);
        System.out.println("Sending logger reset all command to core " + n);
        this.sendCmd(byArray, MessagePacketHeader.EnumMsgType.ACK, 11);
    }

    public void sendWriteMaskCmd(int n, long l, long l2) throws Exception {
        byte[] byArray = this.service.getWriteMaskCmd(n, l, l2);
        System.out.println("Sending write mask command to core " + n + " addr = " + Long.toHexString(l) + " mask = " + Long.toHexString(l2));
        this.sendCmd(byArray, MessagePacketHeader.EnumMsgType.ACK, 1);
    }

    public void sendSnapshotCmd(int n, long l, long l2) throws Exception {
        byte[] byArray = this.service.getLoggerSnapshotAll(n, l, l2);
        System.out.println("Sending snapshot command to core " + n + " resetFlag = " + l + " periodInMs = " + l2);
        this.sendCmd(byArray, MessagePacketHeader.EnumMsgType.ACK, 12);
    }

    public void sendReadMaskCmd(int n, long l) throws Exception {
        byte[] byArray = this.service.getReadMaskCmd(n, l);
        System.out.println("Sending read mask command to core " + n + " addr = 0x" + Long.toHexString(l));
        byte[] byArray2 = this.sendCmd(byArray, MessagePacketHeader.EnumMsgType.ACK, 0);
        long l2 = this.dec.decodeBytes(byArray2, MessagePacketHeader.getHeaderSize(), 4, false);
        System.out.println("diagsMask__C = 0x" + Long.toHexString(l2));
    }

    public void sendGetCpuFreqCmd(int n) throws Exception {
        byte[] byArray = this.service.getCpuFreqCmd(n);
        System.out.println("Sending get CPU frequency to core " + n);
        byte[] byArray2 = this.sendCmd(byArray, MessagePacketHeader.EnumMsgType.ACK, 4);
        long l = this.dec.decodeBytes(byArray2, MessagePacketHeader.getHeaderSize(), 4, false);
        long l2 = this.dec.decodeBytes(byArray2, MessagePacketHeader.getHeaderSize() + 4, 4, false);
        long l3 = (long)((double)l * Math.pow(2.0, 32.0)) + l2;
        System.out.println("CPU Frequency = " + Long.toString(l3));
    }

    public byte[] sendCmd(byte[] byArray, MessagePacketHeader.EnumMsgType enumMsgType, int n) throws Exception {
        this.outMsg.write(byArray, 0, byArray.length);
        System.out.println("sent message cmdId - " + n);
        while (true) {
            byte[] byArray2 = this.readResponse();
            MessagePacketHeader messagePacketHeader = new MessagePacketHeader();
            messagePacketHeader.read(byArray2, 0);
            if (messagePacketHeader.getCmdId() == n) {
                System.out.println("Received cmd ACK");
                return byArray2;
            }
            System.out.println("Received message " + messagePacketHeader.getMsgType() + " " + messagePacketHeader.getCmdId());
            System.out.println("Received something other than an ACK for the response...");
        }
    }

    public byte[] readResponse() throws Exception {
        byte[] byArray = new byte[1500];
        int n = this.inMsg.read(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public DatagramPacket readEvents() throws Exception {
        byte[] byArray = new byte[1500];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        this.eventSocket.receive(datagramPacket);
        return datagramPacket;
    }
}

