/* --COPYRIGHT--,EPL
 *  Copyright (c) 2009 Texas Instruments and others.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 *  Contributors:
 *      Texas Instruments - initial implementation
 * 
 * --/COPYRIGHT--*/


import xdc.tools.product.IProduct;                          
import xdc.tools.product.IProductView;

metaonly module UiactoolsProduct inherits IProduct {
    
    override config String name = "System Analyzer (UIA cTools Target)";

    override config String id   = "com.ti.uiactools";

    override config String version = "1.01.00.09";  

    override config String companyName = "Texas Instruments";

    override config IProduct.UrlDescriptor productDescriptor = {
        url: "http://www.ti.com",
        text: "UIA cTools"
    };

    override config IProduct.UrlDescriptor licenseDescriptor = {
        text: "Texas Instruments Incorporated - Technology Software Publicly Available license"
    };

    override config String copyRightNotice =
        "Copyright Texas Instruments 2012";

    override config String repositoryArr[] = ["packages"];

    override config String docsLocArr[] = [
        ".",
        "docs",
        "docs/cdoc"
    ];

    override config String templateModule = 
	"ti.uiactools.examples.Examples";

    override config String productViewModule = "ti.uiactools.productview.UiactoolsProductView";

    override config String bundleName = "uiactools";
    override config IProduct.HelpToc helpTocArr[] = [
        {
         label: "uiactools Release Notes",
         filePath: "uiactools_1_01_00_09_release_notes.html",         
        },
        {
         label: "System Analyzer WIKI",
         filePath: "http://processors.wiki.ti.com/index.php/Multicore_System_Analyzer",         
        },
        {
         label: "uiactools API Reference (cdoc)",
         filePath: "cdoc/toc.xml",
         tocFile:true
        }
    ];

}
