/* 
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * */

/*
 *  ======== Examples.xdc ========
 */
import xdc.tools.product.IProductTemplate;

metaonly module Examples inherits IProductTemplate 
{
    config String name = "System Analyzer (UIAcTools) Examples";

    config IProductTemplate.TemplateGroup root = {
        id          : "ti.uiactools.examples.root",
        name        : "System Analyzer (UIAcTools)",
        description : "System Analyzer (UIAcTools) Tutorials, Examples and Project Templates"
    };

    config IProductTemplate.TemplateGroup level1 = {
        id          : "ti.uiactools.examples.root.level1",
        name        : "Single-core Examples",
        description : "System Analyzer (UIAcTools) Single-core Examples",
        groups      : ["ti.uiactools.examples.root"]
    };

    override config IProductTemplate.TemplateGroup templateGroupArr [] =
                                  [root, level1];

   
    config IProductTemplate.TemplateInfo logger = {
        title: "LoggerSTM Example",
        fileList: [
            { path: "./single/stairstep.c" },
            { path: "./single/logger.cfg" },
        ],
        description: "Example showing the usage of LoggerSTM",
        buildProfile: "release",
        groups:["ti.uiactools.examples.root.level1"],
        isHybrid: true,
        filterArr: [
            { deviceFamily: "C6000", toolChain: "TI" },
        ],
        requiredProducts: [ "com.ti.uia", "com.ti.rtsc.SYSBIOS", "com.ti.rtsc.IPC" ],
        linkerCommandFile: ""
    };
    
 

    override config IProductTemplate.TemplateInfo templateArr[] = [
        logger
    ];
}


