/* 
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * */

/*
 *  ======== BufferPacketizer.xs ========
 */

var BufferPacketizer = null;
var isEnableDebugPrintf = false;
var UIAMetaData;

/*
 *  ======== module$use ========
 */
function module$use() {
    var System = xdc.useModule('xdc.runtime.System');
    var Defaults = xdc.useModule('xdc.runtime.Defaults');
    var Diags = xdc.module("xdc.runtime.Diags");
    var Types = xdc.useModule('xdc.runtime.Types');    
    var QueueDescriptor = xdc.useModule('ti.uia.runtime.QueueDescriptor');
    var IUIAPacketTransfer = xdc.useModule('ti.uiactools.runtime.IUIAPacketTransfer');
    var UIAPacket = xdc.useModule('ti.uiactools.runtime.UIAPacket');
    var Memory = xdc.useModule('xdc.runtime.Memory');
    var Timestamp = xdc.useModule('xdc.runtime.Timestamp');
	var SyncSTM = xdc.useModule('ti.uiactools.runtime.SyncSTM');
	
    var Memory = xdc.useModule('xdc.runtime.Memory');     
    /* Ensure that UIAMetaData is used (e.g. for JTAG transports with no target-side services) */
    UIAMetaData = xdc.useModule('ti.uia.runtime.UIAMetaData');
    BufferPacketizer = this;

    /* Memory module is needed only if memoryPolicy is not STATIC_POLICY. */
    if (Defaults.getCommon(BufferPacketizer, "memoryPolicy") != 
        Types.STATIC_POLICY) {
        xdc.useModule('xdc.runtime.Memory');
    }

    /* disable trace on timestamp proxy to prevent recursive callbacks */
    var modName = Timestamp.SupportProxy.delegate$.$name;
    Diags.setMaskMeta(modName, Diags.ALL & (~Diags.ASSERT), Diags.ALWAYS_OFF);
}

/*
 *  ======== module$static$init ========
 */
function module$static$init(mod, params)
{
    /*
     *  Until System Analyzer changes, we need to pass in ETHERNET instead
     *  of UDP.
     * setTransportFields(isMultiCoreTransport, mode, transportType, format,
     *                       supportControl, customFields)     
     */
  
	var customTransportType = "transport=UDP";
	
	if (params.customTransportType != null){
		customTransportType = params.customTransportType;
	}
    if (params.transportType == BufferPacketizer.TransportType_UDP) {
        UIAMetaData.setTransportFields(false,  "NONJTAGTRANSPORT", "ETHERNET", "UIAPacket",
                false,  customTransportType);
    }
    else {
        UIAMetaData.setTransportFields(false, "NONJTAGTRANSPORT",params.transportType,"UIAPacket",
                 false, customTransportType);
    }    
}

/*
 *  ======== instance$static$init ========
 */
function instance$static$init( obj, params) {

    var QueueDescriptor = xdc.module('ti.uia.runtime.QueueDescriptor');
    var BufferPacketizer = xdc.module('ti.uiactools.runtime.BufferPacketizer');
    var IUIAPacketTransfer = xdc.module('ti.uiactools.runtime.IUIAPacketTransfer');
    var moduleName = this.$name;
    var UIAPacket = xdc.module('ti.uiactools.runtime.UIAPacket');
    var Program = xdc.module('xdc.cfg.Program');
    var sizeOfInt32 = Program.build.target.stdTypes.t_Int32.size;
     
    /*
     *  Validate that the buffer size (in MAU) is valid. 16 words is the minimum
     *  size, equal to the maximum size of an 8 word event(12 words) plus the four word
     *  UIA header.  The packetSizeInMAUs must also be a multiple of words.  The buffer size
     *  must also be  >= (maxEventSize + 16 words).
     */
    if (params.packetSizeInMAUs < ( 16 * Program.build.target.stdTypes.t_Int32.size)) {
//TODO: figure out how to support calls to $logError	
//        this.$logError("The packetSizeInMAUs parameter must be 16 words or larger", this);
		  print("Error (BufferPacketizer): The packetSizeInMAUs parameter must be 16 words or larger.");
    }
    if (params.packetSizeInMAUs % Program.build.target.stdTypes.t_Int32.size != 0) {
//TODO: figure out how to support calls to $logError	
//        this.$logError("The packetSizeInMAUs parameter must be a multiple of a word", this);
		  print("Error (BufferPacketizer): The packetSizeInMAUs parameter must be a multiple of a word");
    }

    /* Check for prime and exchance functions */
    if (params.primeFxn == null) {
//TODO: figure out how to support calls to $logWarning 
//        this.$logWarning("The primeFxn parameter is not set, you must call prime yourself", this);
		  print("Warning (BufferPacketizer): The primeFxn parameter is not set, you must call prime yourself");
		
    }
    if (params.exchangeFxn == null) {
//TODO: figure out how to support calls to $logError 
//        this.$logError("The exchangeFxn parameter must be set", this);
		  print("Error (BufferPacketizer): The exchangeFxn parameter must be set");
    }

    /*
     *  The buffer pointers are initialized to null and set during start up
     *    when the configured prime function is called.
     */
    obj.pPacketBuffer = null;
    obj.rdUploadBuffer = null;
    obj.wrPacket = null;
    obj.pPacketEndPlusOne = null;
	obj.serial = 1;
	obj.snapshotNumber = 0;
	obj.transferNumber = 0;
	obj.endpointNumber = params.endpointNumber;
	obj.isFirstPacket = true;
	obj.tracePktDownCount = 0;
	obj.tracePktUpCount = 0;
    obj.bufType = params.bufferType;
    obj.printDebugMessages = false;
    switch (obj.bufType){
    case BufferPacketizer.BufferType_STM_ETB:
       obj.traceHdrType = UIAPacket.HdrType_STMTrace;
       break;
     case BufferPacketizer.BufferType_CPUTRACE_ETB:
       obj.traceHdrType = UIAPacket.HdrType_CPUTrace;
       break;
     case BufferPacketizer.BufferType_MEMORY:
       obj.traceHdrType = UIAPacket.HdrType_MemoryBuffer;
       break;	   
     default:
       obj.traceHdrType = UIAPacket.HdrType_InvalidData;
       break;
     
     }
    obj.transferType = params.transferType;
    obj.packetSizeInMAUs = params.packetSizeInMAUs;
    obj.etbCoreId = params.etbCoreId;
    obj.pUploaderContext = null;
    obj.uploadBufferSizeInWords = 0;
    obj.pUploadBuffer = null;
    obj.primeStatus = false;
    obj.exchangeFxn = params.exchangeFxn;
    obj.primeFxn = params.primeFxn;
    obj.enabled = true;
    obj.isInitialized = false;
}



/*
 *  ======== validate ========
 *  This function is called by this package's validate() method (defined
 *  in package.xs).
 */
function validate() {
    /* this is the module's object */
    if (!this.$used) {
        return;
    }
}

/*
 *  ======== viewInitModule ========
 *  Initializes the Module view in ROV.
 */
function viewInitModule(view, mod)
{
    BufferPacketizer  = xdc.module("ti.uiactools.runtime.BufferPacketizer");

    var BufferPacketizerModConfig = Program.getModuleConfig(BufferPacketizer.$name);
}

/*
 *  ======== writeUIAMetaData ========
 *  Writes any UIA metadata required to support the module 
 *
 *  NOTE: This should only be called by ti.uia.runtime.UIAMetaData.xs in 
 *  order to ensure that the UIA xml file has been properly opened and is 
 *  ready for writing.     
 *  inst   - instance of the module to generate data for, null for 
 *     module-level info 
 *  instNum - the instance number used in .h files
 *  indent  - the number of spaces to preceed the xml tag with 
 */
function writeUIAMetaData(inst, instNum, indent){
    var mod = xdc.module('ti.uiactools.runtime.BufferPacketizer');
    var UIAMetaData = xdc.module('ti.uia.runtime.UIAMetaData');
    var IUIAPacketTransfer = xdc.module('ti.uiactools.runtime.IUIAPacketTransfer');    
    UIAMetaData.genXmlComment(indent,"ti/uiactools/runtimeBufferPacketizer:")
    UIAMetaData.genXmlEntryOpen(indent,"BufferPacketizer");
    UIAMetaData.genXmlEntry(indent+3,"moduleName", mod.$name);
    UIAMetaData.genXmlEntry(indent+3,"moduleId", mod.Module__id.toString());
    UIAMetaData.genXmlEntryOpenWithKey(indent+3,"BufferPacketizerInstance","InstNum",""+instNum,0);
    var strExchangeFxn = ""+inst.exchangeFxn;
    var indexOfAmp = strExchangeFxn.indexOf("&");
    if (indexOfAmp >= 0){
            strExchangeFxn = strExchangeFxn.substring(indexOfAmp+1);
    }  
    UIAMetaData.genXmlEntry(indent+6,"exchangeFxn",strExchangeFxn);
    UIAMetaData.genXmlEntry(indent+6,"packetSizeInMAUs",""+inst.packetSizeInMAUs);
    UIAMetaData.genXmlComment(indent+6,"ETB core ID: STM=255, CPU0=0");
    UIAMetaData.genXmlEntry(indent+6,"etbCoreId",""+inst.etbCoreId);
    UIAMetaData.genXmlComment(indent+6,"Buffer types: [MemoryBuffer, STMTrace, CPUTrace]");
    switch(inst.bufferType){
    case BufferPacketizer.BufferType_STM_ETB:
        UIAMetaData.genXmlEntry(indent+6,"bufType","STMTrace");
       break;
     case BufferPacketizer.BufferType_CPUTRACE_ETB:
        UIAMetaData.genXmlEntry(indent+6,"bufType","CPUTrace");
       break;
     default:
        UIAMetaData.genXmlEntry(indent+6,"bufType","MemoryBuffer");
       break;
     }
    UIAMetaData.genXmlComment(indent+6,"Endpoint number: 0xFF means use DNUM value.")     
    UIAMetaData.genXmlEntry(indent+6,"endpointNumber",""+inst.endpointNumber);
    UIAMetaData.genXmlEntryClose(indent+3,"BufferPacketizerInstance");
    UIAMetaData.genXmlEntryClose(indent,"BufferPacketizer");
}

/*
 *  ======== viewInitInstances ========
 *  Initializes the Instances view in ROV.
 */
function viewInitInstances(view, obj)
{
    /* Retrieve the BufferPacketizer instance's name */
    view.label = Program.getShortName(obj.$label);
    
    view.enabled = obj.enabled;
    view.droppedSnapshots = obj.droppedSnapshots;
    view.serial = obj.serial;
    view.bufType = obj.bufType;    
    view.snapshotNumber = obj.snapshotNumber;
    view.tracePktUpCount = obj.tracePktUpCount;
    view.tracePktDownCount = obj.tracePktDownCount;
    view.transferType = obj.transferType;    
}


