/* 
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * */

/*
 *  ======== EtbDrainer.xs ========
 */

var EtbDrainer = null;
var isEnableDebugPrintf = false;
var UIAMetaData;

/*
 *  ======== module$use ========
 */
function module$use() {
    var System = xdc.useModule('xdc.runtime.System');
    var Defaults = xdc.useModule('xdc.runtime.Defaults');
    var Diags = xdc.module("xdc.runtime.Diags");
    var Types = xdc.useModule('xdc.runtime.Types');    
    var QueueDescriptor = xdc.useModule('ti.uia.runtime.QueueDescriptor');
    var IUIAPacketTransfer = xdc.useModule('ti.uiactools.runtime.IUIAPacketTransfer');
    var UIAPacket = xdc.useModule('ti.uiactools.runtime.UIAPacket');
    var Memory = xdc.useModule('xdc.runtime.Memory');
    var Timestamp = xdc.useModule('xdc.runtime.Timestamp');
    var Etb = xdc.useModule('ti.ctools.etbLib.Etb');
	var SyncSTM = xdc.useModule('ti.uiactools.runtime.SyncSTM');
	
 //   var EtbLib = xdc.loadPackage('ti.ctools.etbLib');
    var Memory = xdc.useModule('xdc.runtime.Memory');     
    /* Ensure that UIAMetaData is used (e.g. for JTAG transports with no target-side services) */
    UIAMetaData = xdc.useModule('ti.uia.runtime.UIAMetaData');
    EtbDrainer = this;

    /* Memory module is needed only if memoryPolicy is not STATIC_POLICY. */
    if (Defaults.getCommon(EtbDrainer, "memoryPolicy") != 
        Types.STATIC_POLICY) {
        xdc.useModule('xdc.runtime.Memory');
    }

    /* disable trace on timestamp proxy to prevent recursive callbacks */
    var modName = Timestamp.SupportProxy.delegate$.$name;
    Diags.setMaskMeta(modName, Diags.ALL & (~Diags.ASSERT), Diags.ALWAYS_OFF);
}

/*
 *  ======== module$static$init ========
 */
function module$static$init(mod, params)
{
    /*
     *  Until System Analyzer changes, we need to pass in ETHERNET instead
     *  of UDP.
     * setTransportFields(isMultiCoreTransport, mode, transportType, format,
     *                       supportControl, customFields)     
     */
  
	var customTransportType = "transport=UDP";
	
	if (params.customTransportType != null){
		customTransportType = params.customTransportType;
	}
    if (params.transportType == EtbDrainer.TransportType_UDP) {
        UIAMetaData.setTransportFields(false,  "NONJTAGTRANSPORT", "ETHERNET", "UIAPacket",
                false,  customTransportType);
    }
    else {
        UIAMetaData.setTransportFields(false, "NONJTAGTRANSPORT",params.transportType,"UIAPacket",
                 false, customTransportType);
    }    
}

/*
 *  ======== instance$static$init ========
 */
function instance$static$init( obj, params) {

    var QueueDescriptor = xdc.module('ti.uia.runtime.QueueDescriptor');
    var EtbDrainer = xdc.module('ti.uiactools.runtime.EtbDrainer');
    var IUIAPacketTransfer = xdc.module('ti.uiactools.runtime.IUIAPacketTransfer');
    var moduleName = this.$name;
    var UIAPacket = xdc.module('ti.uiactools.runtime.UIAPacket');
    var Program = xdc.module('xdc.cfg.Program');
    var sizeOfInt32 = Program.build.target.stdTypes.t_Int32.size;
	var Etb = xdc.module('ti.ctools.etbLib.Etb');
    var Memory = xdc.module('xdc.runtime.Memory');
     
    /*
     *  Validate that the buffer size (in MAU) is valid. 16 words is the minimum
     *  size, equal to the maximum size of an 8 word event(12 words) plus the four word
     *  UIA header.  The packetSizeInMAUs must also be a multiple of words.  The buffer size
     *  must also be  >= (maxEventSize + 16 words).
     */
    if (params.packetSizeInMAUs < ( 16 * Program.build.target.stdTypes.t_Int32.size)) {
//TODO: figure out how to support calls to $logError	
//        this.$logError("The packetSizeInMAUs parameter must be 16 words or larger", this);
		  print("Error (EtbDrainer): The packetSizeInMAUs parameter must be 16 words or larger.");
    }
    if (params.packetSizeInMAUs % Program.build.target.stdTypes.t_Int32.size != 0) {
//TODO: figure out how to support calls to $logError	
//        this.$logError("The packetSizeInMAUs parameter must be a multiple of a word", this);
		  print("Error (EtbDrainer): The packetSizeInMAUs parameter must be a multiple of a word");
    }

    /* Check for prime and exchance functions */
    if (params.primeFxn == null) {
//TODO: figure out how to support calls to $logWarning 
//        this.$logWarning("The primeFxn parameter is not set, you must call prime yourself", this);
		  print("Warning (EtbDrainer): The primeFxn parameter is not set, you must call prime yourself");
		
    }
    if (params.exchangeFxn == null) {
//TODO: figure out how to support calls to $logError 
//        this.$logError("The exchangeFxn parameter must be set", this);
		  print("Error (EtbDrainer): The exchangeFxn parameter must be set");
    }

    /*
     *  The buffer pointers are initialized to null and set during start up
     *    when the configured prime function is called.
     */
    obj.buffer = null;
    obj.write = null;
    obj.end = null;
	obj.serial = 1;
	obj.snapshotNumber = 0;
	obj.transferNumber = 0;
	obj.endpointNumber = params.endpointNumber;
	obj.isFirstPacket = true;
	obj.tracePktDownCount = 0;
	obj.tracePktUpCount = 0;
	obj.droppedSnapshots = 0;
    obj.etbType = params.etbType;
    obj.printDebugMessages = false;
    switch (params.etbType){
    case EtbDrainer.EtbType_STM:
       obj.traceHdrType = UIAPacket.HdrType_STMTrace;
       break;
     case EtbDrainer.EtbType_CPUTRACE:
       obj.traceHdrType = UIAPacket.HdrType_CPUTrace;
       break;
     default:
       obj.traceHdrType = UIAPacket.HdrType_InvalidData;
       break;
     
     }
    obj.etbBaseAdrs = params.etbBaseAdrs;
    obj.transferType = params.transferType;
    obj.packetSizeInMAUs = params.packetSizeInMAUs;
    obj.etbSizeInWords = 0;  /* initialized by ETB Library open call */
    obj.etbCoreId = params.etbCoreId;
    obj.etbBaseAdrs = params.etbBaseAdrs;
    obj.etbHandle = null;
        /*
         *  The following will place a memory buffer into section name. This
         *  buffer is the memory that this instance will manage.
         */
    if ((params.drainBufSizeInMAUs % sizeOfInt32) > 0){
    	obj.drainBufSizeInWords = 1 + (params.drainBufSizeInMAUs/sizeOfInt32);
   	} else {
    	obj.drainBufSizeInWords = (params.drainBufSizeInMAUs/sizeOfInt32);
   	} 
   	// Pad the drain buffer in case the flush operation causes too many words to be read out.
    obj.drainBuf1.length = obj.drainBufSizeInWords+obj.etbSizeInWords;
    // align the memory to ensure that it is word aligned and cache line aligned (128 bytes)
    Memory.staticPlace(obj.drainBuf1, 32*sizeOfInt32, params.bufSection);    
//    obj.drainBuf2.length = obj.drainBufSizeInWords/2;
//    Memory.staticPlace(obj.drainBuf2, 32*sizeOfInt32, params.bufSection);    
    obj.bufHeap = null;
	obj.dmaConfig.cc = 0;           /*!< EDMA3 channel controller number */
    obj.dmaConfig.clrChannel = 0;   /*!< 1st DMA channel number for DMA draining (needs to
                                 be able to access CPINTC). Application must have
                                 configured the channel to PaRAM mapping for this
                                 channel before using this API.
                            */
    obj.dmaConfig.etbChannel = 0;   /*!< 2nd DMA channel number for DMA draining (needs to
                                 be able to access the ETB). Application must have
                                 configured the channel to PaRAM mapping for this
                                 channel before using this API.
                            */
    obj.dmaConfig.linkparam[0] = 0;
    obj.dmaConfig.linkparam[1] = 0;
    obj.dmaConfig.linkparam[2] = 0;
     /*!< 3 additional parameter RAM entry numbers (used for
                                 linking by the library). Thses must be different
                                 PaRAM entries than thos mapped to channel 1 & 2.
                            */
    obj.dmaConfig.dbufAddress = 0;  /*!< DMA Drain buffer address: to be filled in by init function */
    obj.dmaConfig.dbufWords = obj.drainBufSizeInWords/2;    /*!< DMA Drain buffer size in 32-bit words */
    obj.dmaConfig.mode = Etb.eDMA_Stop_Buffer;        /*!< DMA Drain buffer mode (only eDMA_Circular and
                                 eDMA_Stop_Buffer are valid values)  */
    
    obj.primeStatus = false;
    obj.exchangeFxn = params.exchangeFxn;
    obj.primeFxn = params.primeFxn;
        
    if (params.packetSizeInMAUs > 0){
        obj.enabled = true;
    }
    else {
        obj.enabled = false;
    }
    obj.usingBuffer1 = true;
    obj.atbMsgHdrPointer[0] = 0; 
    obj.atbMsgHdrPointer[1] = 0; 
    obj.dmaStatus[0].startAddr = 0; /* Current starting lcoation address in DMA drain buffer.*/
    obj.dmaStatus[0].availableWords = 0; /*!< Total number of 32-bit words that have been written into the DMA drain buffer.*/
    obj.dmaStatus[0].isWrapped = 0;  /* DMA Drain buffer is full and has started writing over previously written words. */
    obj.dmaStatus[0].dbufAddress = 0; /* DMA Drain buffer address */
    obj.dmaStatus[0].dbufWords = 0;  /* DMA Drain buffer size in 32-bit words */
    obj.dmaStatus[0].flushRequired = 0;        /* Only allow flushing ETB once related to DMA */
    obj.dmaStatus[1].startAddr = 0; /* Current starting lcoation address in DMA drain buffer.*/
    obj.dmaStatus[1].availableWords = 0; /*!< Total number of 32-bit words that have been written into the DMA drain buffer.*/
    obj.dmaStatus[1].isWrapped = 0;  /* DMA Drain buffer is full and has started writing over previously written words. */
    obj.dmaStatus[1].dbufAddress = 0; /* DMA Drain buffer address */
    obj.dmaStatus[1].dbufWords = 0;  /* DMA Drain buffer size in 32-bit words */
    obj.dmaStatus[1].flushRequired = 0;        /* Only allow flushing ETB once related to DMA */
    obj.isInitialized = false;
}



/*
 *  ======== validate ========
 *  This function is called by this package's validate() method (defined
 *  in package.xs).
 */
function validate() {
    /* this is the module's object */
    if (!this.$used) {
        return;
    }
}

/*
 *  ======== viewInitModule ========
 *  Initializes the Module view in ROV.
 */
function viewInitModule(view, mod)
{
    EtbDrainer  = xdc.module("ti.uiactools.runtime.EtbDrainer");

    var EtbDrainerModConfig = Program.getModuleConfig(EtbDrainer.$name);
}

/*
 *  ======== writeUIAMetaData ========
 *  Writes any UIA metadata required to support the module 
 *
 *  NOTE: This should only be called by ti.uia.runtime.UIAMetaData.xs in 
 *  order to ensure that the UIA xml file has been properly opened and is 
 *  ready for writing.     
 *  inst   - instance of the module to generate data for, null for 
 *     module-level info 
 *  instNum - the instance number used in .h files
 *  indent  - the number of spaces to preceed the xml tag with 
 */
function writeUIAMetaData(inst, instNum, indent){
    var mod = xdc.module('ti.uiactools.runtime.EtbDrainer');
    var UIAMetaData = xdc.module('ti.uia.runtime.UIAMetaData');
    var IUIAPacketTransfer = xdc.module('ti.uiactools.runtime.IUIAPacketTransfer');    
    UIAMetaData.genXmlComment(indent,"ti/uiactools/runtimeETBDrainer:")
    UIAMetaData.genXmlEntryOpen(indent,"EtbDrainer");
    UIAMetaData.genXmlEntry(indent+3,"moduleName", mod.$name);
    UIAMetaData.genXmlEntry(indent+3,"moduleId", mod.Module__id.toString());
    UIAMetaData.genXmlEntryOpenWithKey(indent+3,"EtbDrainerInstance","InstNum",""+instNum,0);
    var strExchangeFxn = ""+inst.exchangeFxn;
    var indexOfAmp = strExchangeFxn.indexOf("&");
    if (indexOfAmp >= 0){
            strExchangeFxn = strExchangeFxn.substring(indexOfAmp+1);
    }  
    UIAMetaData.genXmlEntry(indent+6,"exchangeFxn",strExchangeFxn);
    UIAMetaData.genXmlEntry(indent+6,"packetSizeInMAUs",""+inst.packetSizeInMAUs);
    UIAMetaData.genXmlEntry(indent+6,"etbBaseAdrs","0x"+Number(inst.etbBaseAdrs).toString(16));
    UIAMetaData.genXmlComment(indent+6,"ETB core ID: STM=255, CPU0=0");
    UIAMetaData.genXmlEntry(indent+6,"etbCoreId",""+inst.etbCoreId);
    UIAMetaData.genXmlEntry(indent+6,"drainBufSizeInMAUs",""+inst.drainBufSizeInMAUs);
    UIAMetaData.genXmlComment(indent+6,"ETB types: [STMTrace, CPUTrace]");
    switch(inst.etbType){
    case EtbDrainer.EtbType_STM:
        UIAMetaData.genXmlEntry(indent+6,"etbType","STMTrace");
       break;
     case EtbDrainer.EtbType_CPUTRACE:
        UIAMetaData.genXmlEntry(indent+6,"etbType","CPUTrace");
       break;
     default:
        UIAMetaData.genXmlEntry(indent+6,"etbType","Invalid");
       break;
     }
    UIAMetaData.genXmlComment(indent+6,"Endpoint number: 0xFF means use DNUM value.")     
    UIAMetaData.genXmlEntry(indent+6,"endpointNumber",""+inst.endpointNumber);
    UIAMetaData.genXmlEntryClose(indent+3,"EtbDrainerInstance");
    UIAMetaData.genXmlEntryClose(indent,"EtbDrainer");
}

/*
 *  ======== viewInitInstances ========
 *  Initializes the Instances view in ROV.
 */
function viewInitInstances(view, obj)
{
    /* Retrieve the EtbDrainer instance's name */
    view.label = Program.getShortName(obj.$label);
    
    view.enabled = obj.enabled;
    view.droppedSnapshots = obj.droppedSnapshots;
    view.serial = obj.serial;
    view.etbType = obj.etbType;    
    view.snapshotNumber = obj.snapshotNumber;
    view.tracePktUpCount = obj.tracePktUpCount;
    view.tracePktDownCount = obj.tracePktDownCount;
    view.transferType = obj.transferType;    
}


