/* 
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * */
import ti.uia.events.IUIAMetaProvider;
/*!
 *  ======== IUIAPacketTransfer ========
 */
interface IUIAPacketTransfer inherits IUIAMetaProvider {

    
    enum TransferType {
        TransferType_RELIABLE = 0,
        TransferType_LOSSY = 1
    }
    
    /*!  @_nodoc
     * ======== Logger Priority enumeration ========
     */
    enum Priority {
        Priority_LOW = 0,       /*! low priority */   
        Priority_STANDARD = 1,  /*! default priority */
        Priority_HIGH = 2,      /*! use for critical errors, etc. */   
        Priority_SYNC = 3       /*! used only by LogSync's logger */
    };

   

instance:

    /*!
     *  ======== enable ========
     *  Enable packet upload
     *
     *  @a(returns)
     *  The function returns the state of the packet upload (`TRUE` if enabled,
     *  `FALSE` if disabled) before the call. This return value allows 
     *  clients to restore the previous state.  
     *  Note: not thread safe.
     */
    Bool enable();
    
   /*!
     *  ======== disable ========
     *  Disable packet upload
     *
     *  @a(returns)
     *  The function returns the state of the packet upload (`TRUE` if enabled,
     *  `FALSE` if disabled) before the call. This return value allows 
     *  clients to restore the previous state.
     *  Note: not thread safe.
     */
    Bool disable(); 
    
    config TransferType transferType = TransferType_LOSSY;
    TransferType getTransferType();


    
    /*! 
     *  ======== isEmpty =========
     *  Returns true if the transfer buffer has no unread data
     *
     *  @a(return)  true if no unread data
     */
    @DirectCall
    Bool isEmpty();
    
    
    /*! @_nodoc
     *  ======== priority ========
     *  The priority of the logger is used to detrmine which event packets to
     *  transfer to the host first.
     *
     *  A value of Priority_STANDARD (default) indicates normal priority.  
     *  Higher values indicate higher priority.  
     *  @see #Priority
     */
    config IUIAPacketTransfer.Priority priority = Priority_STANDARD;
    

    
    /*!
     *  ======== poll ========
     *  Check if data is ready and, if so, trigger buffer exchange to send the data as packets.
     *  Call readyToSend after this call to check if there is data available to send.
     * @a(returns)  0 if success, else error code 
     */
    @DirectCall
    UInt32 poll(); 
    
    /*!
     * ======== EtbDrain_readyToSend ========
     * check to see if the ETB drain buffer contains unsent data.
     * If true, call transferData API to send the data
     * @a(returns) TRUE if there is unsent data.
     */    
    @DirectCall
    Bool readyToSend();       
    
    	/*!
	 * ======== transferData ========
	 * Read and Transfer ETB data
	 * move the binary data to PC host via event packets for further
	 * decoding and analysis
	 * @param(maxNumPackets)  maximum number of packets to send in context of this API call
	 */
	@DirectCall
    Bool transferData(UInt32 maxNumPackets);
    
	/*
	 *  ======== Prime =========
     *  If PrimeFxn is not set the user must call prime with the first buffer.	 
	 */    
    @DirectCall
    Bool prime(Ptr buffer);
    
}

