/* 
 * Copyright (c) 2010, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * */

/*
 *  ======== LoggerSTM.xs ========
 */

var Logger = null;
var UIAMetaData;
var isEnableDebugPrintf = false;

/*
 *  ======== module$use ========
 */
function module$use() {
    var System = xdc.useModule('xdc.runtime.System');
    var Defaults = xdc.module('xdc.runtime.Defaults');
    var Types = xdc.module('xdc.runtime.Types');
    var Timestamp = xdc.module('xdc.runtime.Timestamp');
    var StmLib = xdc.loadPackage('ti.ctools.stmLib');
    UIAMetaData = xdc.useModule('ti.uia.runtime.UIAMetaData');
    
    Logger = this;

    /* bind LoggerSTM.TimestampProxy to whatever Timestamp is using,
     * unless LoggerSTM.TimestampProxy was set already.
     */
    if (Logger.TimestampProxy == null) {
        Logger.TimestampProxy = Timestamp.SupportProxy.delegate$;
    }

    /* Memory module is needed only if memoryPolicy is not STATIC_POLICY. */
    if (Defaults.getCommon(Logger, "memoryPolicy") != Types.STATIC_POLICY) {
        xdc.useModule('xdc.runtime.Memory');
    }

    /* disable trace on timestamp proxy to prevent recursive callbacks */
    var Diags = xdc.module("xdc.runtime.Diags");
    var modName = Logger.TimestampProxy.delegate$.$name;
    Diags.setMaskMeta(modName, Diags.ALL & (~Diags.ASSERT), Diags.ALWAYS_OFF);
}

/*
 *  ======== instance$static$init ========
 */
function instance$static$init( obj, prms) {
    obj.enabled = false;
    obj.maxEventSizeInBits32 = prms.maxEventSize;
    obj.stmChannel = prms.stmChannelRangeMin;
    obj.stmChannelRangeMin = prms.stmChannelRangeMin;
    obj.stmChannelRangeMax = prms.stmChannelRangeMax;
	 
    if (isEnableDebugPrintf) {
        print("\nUIACTOOLS LoggerSTM.staticInit: calling  UIAMetaData.setTransportFields(minChannel="+
                  obj.stmChannelRangeMin+",maxChannel="+obj.stmChannelRangeMax+")");       
    }
    UIAMetaData.setTransportFields(false, "NONJTAGTRANSPORT", "STM", "STM", false,
         "minChannel="+obj.stmChannelRangeMin+",maxChannel="+obj.stmChannelRangeMax);
	
}
/*
 *  ======== module$static$init ========
 */
function module$static$init(module, params) {
    module.level1 = params.level1Mask;
    module.level2 = params.level2Mask;
    module.level3 = params.level3Mask;  
    module.sequenceNum = 0;
    module.stmBaseAdrs = params.stmBaseAdrs;
    module.stmChannelResolution = params.stmChannelResolution;
    module.endpointId = params.endpointId;
    module.processId = 0;
    module.isInitialized = false;
    module.majorVersion = 3;
    module.minorVersion = 1;
   
}


/*
 *  ======== validate ========
 *  This function is called by this package's validate() method (defined
 *  in package.xs).
 */
function validate() {
    /* this is the module's object */
    if (!this.$used) {
        return;
    }
    if (this.isStringOutputModeEnabled && this.isGenerateSTMLibSupportFnsEnabled) {
       print("WARNING: Overriding LoggerSTM.isGenerateSTMLibSupportFnsEnabled = true configuration because ",
          " LoggerSTM.isStringOutputModeEnabled is set to true.  Application must provide implementation of cTools helper functions."+
          " (Please see ti/ctools/stmlib/StmLibrary.h for more information)");
    }
}

/*
 *  ======== getLoggerInstanceId ========
 *  Parses the string returned from the instance (e.g. Mod.Instance#1) 
 *  Returns the trailing number +1 as the instance ID.  This can then 
 *  be used to look up the instance using mod.$instances[instanceId].
 *  It is also used as a unique identifier in the Queue Descriptor header
 *  and UIA Metadata to identify which instance of a logger is being used
 *  for a specific purpose within UIA. Note that a LoggerInstanceId of 0 
 *  is reserved for dynamically created instances of the logger - the
 *  target code can test to see if the logger's queue descriptor header
 *  has an ID field of 0, and scan through the list of queue descriptors
 *  to determine what the maximum logger ID that is in use is in order
 *  to initialize the instance ID to a unique value for that logger module.
 */
function getLoggerInstanceId(inst){
   return (1);
}

/*
 *  ======== getLoggerPriority ========
 *  returns the priority of this logger instance.  
 */
function getLoggerPriority(inst){
   var IUIATransfer = xdc.module('ti.uia.runtime.IUIATransfer');
   return (IUIATransfer.Priority_STANDARD);
}

/* 
 *  ======== setLoggerPriority ========
 *  sets the priority of this logger instance.  
 */
function setLoggerPriority(inst, priority){
}

/*
 *  ======== getPtrToQueueDescriptorMeta ========
 */
function getPtrToQueueDescriptorMeta(inst){
   return(null);
}

/*
 *  ======== setPtrToQueueDescriptorMeta ========
 */
function setPtrToQueueDescriptorMeta(inst,queueDescriptorAdrs){
    
}

/*
 *  ======== getMetaArgs ========
 *  Returns meta data to support stop-mode RTA.
 */
function getMetaArgs(inst, instNum) {
    return(null);
}
