/* 
 * Copyright (c) 2010, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * */

/*
 *  ======== STMHelper.h ========
 * STM Helper public API Definitions.
*/

#ifndef TI_uiactools_runtime_STMHELPER_H_
#define TI_uiactools_runtime_STMHELPER_H_

extern void STMLog_ErrHandler( eSTM_STATUS stmStatus );
extern void STMLog_SendInfo();
extern void STMLog_CallBack(eSTM_STATUS stmStatus);
extern void STMLog_EnableBufMode(unsigned int maxHeapAllowed, unsigned int dmaBase_Address, int dmaCh_Msg, int dmaCh_Ts, unsigned int STM_BaseAddress, unsigned int STM_ChannelResolution, STMXport_callback arg_pCalBack);
extern void STMLog_EnableBlkMode(unsigned int STM_BaseAddress, unsigned int STM_ChannelResolution, int OptPrintf);
extern void STMLog_checkFlush();
extern void STMLog_exit();

extern STMBufObj ti_uiactools_runtime_StmHelper_STMBufObj;

void * STM_memAlloc(size_t sizeInBytes);
int  STM_memFree(void *p);
void * STM_memMap(unsigned int phyAddress, size_t mapSizeInBytes);
int STM_memUnMap(void * vAddress, size_t mapSizeInBytes);
/*void STMLog_ErrHandler( eSTM_STATUS stmStatus );        */

#endif

/*
 */

/*
 *  @(#) ti.uia.stm; 1, 0, 0, 0,46; 9-16-2010 17:37:53; /db/vtree/library/trees/uia/uia.git/src/ null
 */

