/* 
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * */

/*
 * ======== SyncSTM.xdc ========
 */
package ti.uiactools.runtime;
import ti.uia.runtime.IUIATraceSyncProvider;
import ti.uia.events.UIASync;

/*!
 *  ======== SyncSTM.xdc ========
 *  code for injecting sync point info into the System Trace (STM) stream
 *
 */ 

@Gated
module SyncSTM inherits ti.uia.runtime.IUIATraceSyncProvider {

   /*!
     * ====== injectIntoTrace ======
     * Inject syncPoint info into System Trace
     *
     * This method logs a sync point event and injects
     * correlation info into the System Trace stream (if available)
     * to enable correlation between software events and System trace events.
     *
     * @param(serialNumber) a sync point serial number to inject into the trace
     *    stream
     * @param(ctxType) the CtxChg_ContextType constant that describes what 
     *    context info the 2 words contain
     */
    @DirectCall
    override Void injectIntoTrace(UInt32 serialNum, 
               IUIATraceSyncProvider.ContextType ctxType); 

    /*!
     *  ======== isC6XTraceSyncEnabled ========
     *  Configures whether Sync point information is injected into the C6X hardware trace or not.
     *
     */
    config Bool isC6XTraceSyncEnabled = false;	
	
	/*! @_nodoc
	 * ======== putSyncPoint ========
	 * Logs sync point information to STM.  used internally.
	 */
    @DirectCall	 
	Void putSyncPoint(UInt32 serialNum);

        
    /*! @_nodoc
     * ======== hasMetaData ========
     * Indicates that the SyncSTM module generates content for the uia.xml file.
     */
    override metaonly config Bool hasMetaData = true;    
}

