/* 
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * */

/*
 *  ======== UIAPacket__epilogue.h ========
 */

#ifdef xdc_target__bigEndian
#define UIAPacket_ISBIGENDIAN (TRUE)
#endif

#define UIAPacket_HDRTYPE_WORD    word1
#define UIAPacket_ENDIAN_WORD     word1
#define UIAPacket_MSGLEN_WORD     word1
#define UIAPacket_MSGTYPE_WORD    word1
#define UIAPacket_SERVICEID_WORD  word1
#define UIAPacket_SEQCOUNT_WORD   word2
#define UIAPacket_CMDID_WORD      word2
#define UIAPacket_TAG_WORD        word3
#define UIAPacket_DESTADRS_WORD   word4
#define UIAPacket_SENDERADRS_WORD word4
#define UIAPacket_PROCESSID_WORD  word5
#define UIAPacket_ENDPTNUM_WORD   word6
#define UIAPacket_FIRSTPKTFLAG_WORD word6
#define UIAPacket_TRACEDOWNCOUNT_WORD word6
#define UIAPacket_SNAPSHOTNUM_WORD word7

#define UIAPacket_EVENTLEN_WORD   word1
#define UIAPacket_PRIORITY_WORD   word2
#define UIAPacket_MODULEID_WORD   word3
#define UIAPacket_INSTANCEID_WORD   word3

#ifdef UIAPacket_ISBIGENDIAN
#define ti_uiactools_runtime_UIAPacket_swizzle(a)   (a)
#define ti_uiactools_runtime_UIAPacket_swizzle16(a) (a)

#define UIAPacket_HDRTYPE_BIT_SHIFT           28
#define UIAPacket_HDRTYPE_MASK        0xF0000000

#define UIAPacket_ENDIAN_BIT_SHIFT            27
#define UIAPacket_ENDIAN_MASK         0x08000000

#define UIAPacket_MSGLEN_BIT_SHIFT            16
#define UIAPacket_MSGLEN_MASK         0x07FF0000

#define UIAPacket_MSGTYPE_BIT_SHIFT           12
#define UIAPacket_MSGTYPE_MASK        0x0000F000

#define UIAPacket_SERVICEID_BIT_SHIFT          0
#define UIAPacket_SERVICEID_MASK      0x00000FFF

#define UIAPacket_SEQCOUNT_BIT_SHIFT          16
#define UIAPacket_SEQCOUNT_MASK       0xFFFF0000

#define UIAPacket_PRIORITY_BIT_SHIFT           0
#define UIAPacket_PRIORITY_MASK             0x03

#define UIAPacket_CMDID_BIT_SHIFT              0
#define UIAPacket_CMDID_MASK              0xFFFF

#define UIAPacket_DESTADRS_BIT_SHIFT          16
#define UIAPacket_DESTADRS_MASK       0xFFFF0000

#define UIAPacket_SENDERADRS_BIT_SHIFT         0
#define UIAPacket_SENDERADRS_MASK         0xFFFF

#define UIAPacket_EVENTLEN_BIT_SHIFT           0
#define UIAPacket_EVENTLEN_MASK       0x07FFFFFF

#define UIAPacket_MODULEID_BIT_SHIFT           0
#define UIAPacket_MODULEID_MASK           0xFFFF

#define UIAPacket_INSTANCEID_BIT_SHIFT        16
#define UIAPacket_INSTANCEID_MASK     0xFFFF0000

#define UIAPacket_TRACEDOWNCOUNT_BIT_SHIFT     0
#define UIAPacket_TRACEDOWNCOUNT_MASK     0x7FFF

#define UIAPacket_ENDPTNUM_BIT_SHIFT          16
#define UIAPacket_ENDPTNUM_MASK       0xFFFF0000

#define UIAPacket_FIRSTPKTFLAG_BIT_SHIFT      15
#define UIAPacket_FIRSTPKTFLAG_MASK   0x00008000

#define UIAPacket_SNAPSHOTNUM_BIT_SHIFT        0
#define UIAPacket_SNAPSHOTNUM_MASK    0x00FFFFFF

#define UIAPacket_FOOTER_MAGIC_NUMBER 0x00007777

#else
/* Little endian bit shift and mask definitions:
 * Byte 0  Byte 1  Byte 2  Byte 3
 * 31..24  23..16  15..8    7..0  Big Endian
 *  7..0   15..8   23..16  31..24 Little Endian
 */
#define ti_uiactools_runtime_UIAPacket_swizzle(a) \
        (((((Bits32)a)>>24)&0xff) + ((((Bits32)a)>>8)&0xff00) + \
     ((((Bits32)a)<<8)&0x00ff0000) + ((((Bits32)a)<<24)&0xff000000))

#define ti_uiactools_runtime_UIAPacket_swizzle16(a) \
        (((((Bits32)a)<<8) & 0xff00) + ((((Bits32)a)>>8)& 0xff))

#define UIAPacket_HDRTYPE_BIT_SHIFT           4
#define UIAPacket_HDRTYPE_MASK             0xF0

#define UIAPacket_ENDIAN_BIT_SHIFT            3
#define UIAPacket_ENDIAN_MASK              0x08

#define UIAPacket_MSGLEN_BIT_SHIFT            0
#define UIAPacket_MSGLEN_MASK            0xFF07

#define UIAPacket_MSGTYPE_BIT_SHIFT          20
#define UIAPacket_MSGTYPE_MASK       0x00F00000

#define UIAPacket_SERVICEID_BIT_SHIFT        16
#define UIAPacket_SERVICEID_MASK     0xFF0F0000

#define UIAPacket_SEQCOUNT_BIT_SHIFT          0
#define UIAPacket_SEQCOUNT_MASK          0xFFFF

#define UIAPacket_PRIORITY_BIT_SHIFT         24
#define UIAPacket_PRIORITY_MASK      0x03000000

#define UIAPacket_CMDID_BIT_SHIFT            16
#define UIAPacket_CMDID_MASK         0xFFFF0000

#define UIAPacket_DESTADRS_BIT_SHIFT          0
#define UIAPacket_DESTADRS_MASK          0xFFFF

#define UIAPacket_SENDERADRS_BIT_SHIFT       16
#define UIAPacket_SENDERADRS_MASK    0xFFFF0000

#define UIAPacket_EVENTLEN_BIT_SHIFT          0
#define UIAPacket_EVENTLEN_MASK      0xFFFFFF07

#define UIAPacket_MODULEID_BIT_SHIFT         16
#define UIAPacket_MODULEID_MASK      0xFFFF0000

#define UIAPacket_INSTANCEID_BIT_SHIFT        0
#define UIAPacket_INSTANCEID_MASK        0xFFFF

#define UIAPacket_TRACEDOWNCOUNT_BIT_SHIFT   16
#define UIAPacket_TRACEDOWNCOUNT_MASK 0x0FF7F0000

#define UIAPacket_ENDPTNUM_BIT_SHIFT          0
#define UIAPacket_ENDPTNUM_MASK          0xFFFF

#define UIAPacket_FIRSTPKTFLAG_BIT_SHIFT      23
#define UIAPacket_FIRSTPKTFLAG_MASK   0x00800000

#define UIAPacket_SNAPSHOTNUM_BIT_SHIFT        0
#define UIAPacket_SNAPSHOTNUM_MASK    0x0FFFFFF00

#define UIAPacket_FOOTER_MAGIC_NUMBER 0x77770000

#endif

/*
 *  ======== UIAPacket_getHdrType ========
 *  gets the message header type from the message header
 */
#define ti_uiactools_runtime_UIAPacket_getHdrType(pPktHdr)                           \
    ((UIAPacket_HdrType)                                                       \
     (((Bits32)((pPktHdr)->UIAPacket_HDRTYPE_WORD) & UIAPacket_HDRTYPE_MASK) >> \
     UIAPacket_HDRTYPE_BIT_SHIFT))

/*
 *  ======== UIAPacket_setHdrType ========
 *  sets the message header type in the message header
 */
#define ti_uiactools_runtime_UIAPacket_setHdrType(pPktHdr, hdrType) \
   ((pPktHdr)->UIAPacket_HDRTYPE_WORD =                       \
       ((((Bits32)hdrType  << UIAPacket_HDRTYPE_BIT_SHIFT) &  \
         UIAPacket_HDRTYPE_MASK) |                            \
        ((Bits32)(pPktHdr)->UIAPacket_HDRTYPE_WORD & ~UIAPacket_HDRTYPE_MASK)))

/*
 *  ======== UIAPacket_getPayloadEndianness ========
 *  gets the payload endianness
 */
#define ti_uiactools_runtime_UIAPacket_getPayloadEndianness(pPktHdr) \
    (((Bits32)((pPktHdr)->UIAPacket_ENDIAN_WORD) & UIAPacket_ENDIAN_MASK) >> \
    UIAPacket_ENDIAN_BIT_SHIFT)

/*
 *  ======== UIAPacket_setHdrType ========
 *  sets the message header type in the message header
 */
#define ti_uiactools_runtime_UIAPacket_setPayloadEndianness(pPktHdr, endianness) \
   ((pPktHdr)->UIAPacket_ENDIAN_WORD =                       \
       ((((Bits32)endianness  << UIAPacket_ENDIAN_BIT_SHIFT) &  \
         UIAPacket_ENDIAN_MASK) |                            \
        ((Bits32)(pPktHdr)->UIAPacket_ENDIAN_WORD & ~UIAPacket_ENDIAN_MASK)))

/*
 *  ======== UIAPacket_getMsgLength ========
 *  gets the message length (in bytes) from the message header
 */
#define ti_uiactools_runtime_UIAPacket_getMsgLength(pPktHdr)                          \
    (ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)                                \
        (((Bits32)((pPktHdr)->UIAPacket_MSGLEN_WORD) & UIAPacket_MSGLEN_MASK) >> \
        UIAPacket_MSGLEN_BIT_SHIFT)))

/*
 *  ======== UIAPacket_setMsgLength ========
 *  sets the message length (in bytes) in the message header
 */
#define ti_uiactools_runtime_UIAPacket_setMsgLength(pPktHdr, msgLen)           \
   ((pPktHdr)->UIAPacket_MSGLEN_WORD =                                   \
       (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)msgLen) <<   \
        UIAPacket_MSGLEN_BIT_SHIFT) & UIAPacket_MSGLEN_MASK) |           \
        ((Bits32)(pPktHdr)->UIAPacket_MSGLEN_WORD & ~UIAPacket_MSGLEN_MASK))
/*
 *  ======== UIAPacket_getMsgType ========
 *  gets the message type from the message header
 */
#define ti_uiactools_runtime_UIAPacket_getMsgType(pPktHdr)                           \
    ((UIAPacket_MsgType)                                                       \
     (((Bits32)((pPktHdr)->UIAPacket_MSGTYPE_WORD) & UIAPacket_MSGTYPE_MASK) >> \
     UIAPacket_MSGTYPE_BIT_SHIFT))

/*
 *  ======== UIAPacket_setMsgType ========
 *  sets the message type in the message header
 */
#define ti_uiactools_runtime_UIAPacket_setMsgType(pPktHdr, msgType) \
    ((pPktHdr)->UIAPacket_MSGTYPE_WORD =                      \
       ((((Bits32)msgType  << UIAPacket_MSGTYPE_BIT_SHIFT) &  \
         UIAPacket_MSGTYPE_MASK) |                            \
        ((Bits32)(pPktHdr)->UIAPacket_MSGTYPE_WORD & ~UIAPacket_MSGTYPE_MASK)))

/*
 *  ======== UIAPacket_getServiceId ========
 *  gets the message type from the message header
 */
#define ti_uiactools_runtime_UIAPacket_getServiceId(pPktHdr)                           \
    (ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)                                 \
     (((Bits32)(pPktHdr)->UIAPacket_SERVICEID_WORD & UIAPacket_SERVICEID_MASK) >> \
      UIAPacket_SERVICEID_BIT_SHIFT)))

/*
 *  ======== UIAPacket_setServiceId ========
 *  sets the message type in the message header
 */
#define ti_uiactools_runtime_UIAPacket_setServiceId(pPktHdr, serviceId)          \
    ((pPktHdr)->UIAPacket_SERVICEID_WORD =                                 \
     (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)serviceId) <<    \
      UIAPacket_SERVICEID_BIT_SHIFT) & UIAPacket_SERVICEID_MASK) |         \
     ((Bits32)(pPktHdr)->UIAPacket_SERVICEID_WORD & ~UIAPacket_SERVICEID_MASK))

/*
 *  ======== UIAPacket_getSequenceCount ========
 *  gets the sequence count from the message header
 */
#define ti_uiactools_runtime_UIAPacket_getSequenceCount(pPktHdr)                      \
    (ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)                                \
     (((Bits32)(pPktHdr)->UIAPacket_SEQCOUNT_WORD & UIAPacket_SEQCOUNT_MASK) >> \
      UIAPacket_SEQCOUNT_BIT_SHIFT)))

/*
 *  ======== UIAPacket_setSequenceCount ========
 *  sets the sequence count in the message header
 */
#define ti_uiactools_runtime_UIAPacket_setSequenceCount(pPktHdr, seqCount)       \
    ((pPktHdr)->UIAPacket_SEQCOUNT_WORD =                                  \
     (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)seqCount) <<     \
      UIAPacket_SEQCOUNT_BIT_SHIFT) & UIAPacket_SEQCOUNT_MASK) |           \
     ((Bits32)(pPktHdr)->UIAPacket_SEQCOUNT_WORD & ~UIAPacket_SEQCOUNT_MASK))

/*
 *  ======== UIAPacket_getLoggerPriority ========
 * 
 *  gets the priority field from the event packet header
 */
#define ti_uiactools_runtime_UIAPacket_getLoggerPriority(pPktHdr)                    \
    ((IUIATransfer_Priority)                                                   \
    (((Bits32)((pPktHdr)->UIAPacket_PRIORITY_WORD & UIAPacket_PRIORITY_MASK)>> \
     UIAPacket_PRIORITY_BIT_SHIFT)))

/*
 *  ======== UIAPacket_setLoggerPriority ========
 *  sets the priority in the event packet header
 */
#define ti_uiactools_runtime_UIAPacket_setLoggerPriority(pPktHdr, priority)  \
    ((pPktHdr)->UIAPacket_PRIORITY_WORD =                              \
     ((((Bits32)priority) << UIAPacket_PRIORITY_BIT_SHIFT) &           \
     UIAPacket_PRIORITY_MASK) |                                        \
     ((Bits32)(pPktHdr)->UIAPacket_PRIORITY_WORD & ~UIAPacket_PRIORITY_MASK))

/*
 *  ======== UIAPacket_getCmdId ========
 *  gets the message type from the message header
 */
#define ti_uiactools_runtime_UIAPacket_getCmdId(pPktHdr)                        \
    (ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)                          \
     (((Bits32)(pPktHdr)->UIAPacket_CMDID_WORD & UIAPacket_CMDID_MASK) >> \
      UIAPacket_CMDID_BIT_SHIFT)))

/*
 *  ======== UIAPacket_setCmdId ========
 *  sets the command Id in the message header
 */
#define ti_uiactools_runtime_UIAPacket_setCmdId(pPktHdr, cmdId)            \
    ((pPktHdr)->UIAPacket_CMDID_WORD =                               \
    (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)cmdId) <<   \
      UIAPacket_CMDID_BIT_SHIFT) & UIAPacket_CMDID_MASK) |           \
     ((Bits32)(pPktHdr)->UIAPacket_CMDID_WORD & ~UIAPacket_CMDID_MASK))

/*
 * ======== UIAPacket_getTag =========
 * gets the 32b tag field from the message header
 */
#define ti_uiactools_runtime_UIAPacket_getTag(pPktHdr) \
        ( (Bits32)ti_uiactools_runtime_UIAPacket_swizzle((pPktHdr)->UIAPacket_TAG_WORD))

/*
 * ======== UIAPacket_setTag =========
 * sets the 32b tag field in the message header
 */
#define ti_uiactools_runtime_UIAPacket_setTag(pPktHdr, tagValue) \
        ((pPktHdr)->UIAPacket_TAG_WORD = ti_uiactools_runtime_UIAPacket_swizzle(tagValue))

/*!
 *  ======== UIAPacket_getLoggerModuleId ========
 *  gets the logger ID from the event packet header
 */
#define ti_uiactools_runtime_UIAPacket_getLoggerModuleId(pPktHdr)                          \
    (ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)                               \
     (((Bits32)(pPktHdr)->UIAPacket_MODULEID_WORD & UIAPacket_MODULEID_MASK) >> \
      UIAPacket_MODULEID_BIT_SHIFT)))

/*!
 *  ======== UIAPacket_setLoggerModuleId ========
 *  sets the module ID in the event packet header
 */
#define ti_uiactools_runtime_UIAPacket_setLoggerModuleId(pPktHdr, moduleId) \
    ((pPktHdr)->UIAPacket_MODULEID_WORD =                             \
     (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16(moduleId) <<        \
      UIAPacket_MODULEID_BIT_SHIFT) & UIAPacket_MODULEID_MASK) |      \
     ((Bits32)(pPktHdr)->UIAPacket_MODULEID_WORD & ~UIAPacket_MODULEID_MASK))

/*!
 *  ======== UIAPacket_getLoggerInstanceId ========
 *  gets the logger instance ID from the event packet header
 */
#define ti_uiactools_runtime_UIAPacket_getLoggerInstanceId(pPktHdr)                          \
    (ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)                               \
     (((Bits32)(pPktHdr)->UIAPacket_INSTANCEID_WORD & UIAPacket_INSTANCEID_MASK) >> \
      UIAPacket_INSTANCEID_BIT_SHIFT)))

/*!
 *  ======== UIAPacket_setLoggerInstanceId ========
 *  sets the sequence count in the packet header
 */
#define ti_uiactools_runtime_UIAPacket_setLoggerInstanceId(pPktHdr, instanceId) \
    ((pPktHdr)->UIAPacket_INSTANCEID_WORD =                               \
     (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16(instanceId) <<          \
      UIAPacket_INSTANCEID_BIT_SHIFT) & UIAPacket_INSTANCEID_MASK) |      \
     ((Bits32)(pPktHdr)->UIAPacket_INSTANCEID_WORD & ~UIAPacket_INSTANCEID_MASK))     

/*
 *  ======== UIAPacket_getEventLength ========
 *  gets the len of the event from the message header
 */
#define ti_uiactools_runtime_UIAPacket_getEventLength(pPktHdr) \
    (ti_uiactools_runtime_UIAPacket_swizzle((Bits32)           \
         ((pPktHdr)->UIAPacket_EVENTLEN_WORD & UIAPacket_EVENTLEN_MASK)))

/*
 *  ======== UIAPacket_setEventLength ========
 *  sets the len of the event from the message header
 */
#define ti_uiactools_runtime_UIAPacket_setEventLength(pPktHdr, eventLength)     \
    ((pPktHdr)->UIAPacket_EVENTLEN_WORD =                                 \
     (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle(eventLength) <<           \
      UIAPacket_EVENTLEN_BIT_SHIFT) & UIAPacket_EVENTLEN_MASK) |          \
     ((Bits32)(pPktHdr)->UIAPacket_EVENTLEN_WORD & ~UIAPacket_EVENTLEN_MASK))

/*
 *  ======== UIAPacket_getDestAdrs ========
 *  gets the message destination address from the message header
 */
#define ti_uiactools_runtime_UIAPacket_getDestAdrs(pPktHdr)                           \
    (ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)                                \
     (((Bits32)(pPktHdr)->UIAPacket_DESTADRS_WORD & UIAPacket_DESTADRS_MASK) >> \
      UIAPacket_DESTADRS_BIT_SHIFT)))

/*
 *  ======== UIAPacket_setDestAdrs ========
 *  sets the message destination address in the message header
 */
#define ti_uiactools_runtime_UIAPacket_setDestAdrs(pPktHdr, destAdrs)      \
    ((pPktHdr)->UIAPacket_DESTADRS_WORD =                            \
     (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16(destAdrs)  <<      \
      UIAPacket_DESTADRS_BIT_SHIFT) & UIAPacket_DESTADRS_MASK) |     \
     ((Bits32)(pPktHdr)->UIAPacket_DESTADRS_WORD & ~UIAPacket_DESTADRS_MASK))

/*
 *  ======== UIAPacket_getSenderAdrs ========
 *  gets the message sender address from the message header
 */
#define ti_uiactools_runtime_UIAPacket_getSenderAdrs(pPktHdr)                   \
    (ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)                          \
     (((Bits32)(pPktHdr)->UIAPacket_SENDERADRS_WORD & UIAPacket_SENDERADRS_MASK) >> \
      UIAPacket_SENDERADRS_BIT_SHIFT)))

/*
 *  ======== UIAPacket_setSenderAdrs ========
 *  sets the message sender address in the message header
 */
#define ti_uiactools_runtime_UIAPacket_setSenderAdrs(pPktHdr, senderAdrs)     \
    ((pPktHdr)->UIAPacket_SENDERADRS_WORD =                             \
     (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16(senderAdrs)  <<       \
      UIAPacket_SENDERADRS_BIT_SHIFT) & UIAPacket_SENDERADRS_MASK) |    \
     ((Bits32)(pPktHdr)->UIAPacket_SENDERADRS_WORD & ~UIAPacket_SENDERADRS_MASK))

/*
 * ======== UIAPacket_initMsgHdr ========
 * initializes all bitfields in the message header
 */
#define ti_uiactools_runtime_UIAPacket_initMsgHdr(pPktHdr, endianness, msgType,     \
            msgLength, serviceId, seqCount, cmdId, tag, destAdrs, senderAdrs) \
    {(pPktHdr)->word1 = (                                                     \
        ((Bits32)(ti_uiactools_runtime_UIAPacket_HdrType_Msg) <<                    \
          UIAPacket_HDRTYPE_BIT_SHIFT)                             |          \
        (((Bits32)(endianness) <<                                             \
          UIAPacket_ENDIAN_BIT_SHIFT) & UIAPacket_ENDIAN_MASK)     |          \
        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)msgLength) <<    \
          UIAPacket_MSGLEN_BIT_SHIFT) & UIAPacket_MSGLEN_MASK)     |          \
        (((Bits32)(msgType) <<                                                \
          UIAPacket_MSGTYPE_BIT_SHIFT) & UIAPacket_MSGTYPE_MASK)   |          \
        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)serviceId) <<    \
          UIAPacket_SERVICEID_BIT_SHIFT) & UIAPacket_SERVICEID_MASK));        \
                                                                              \
    (pPktHdr)->word2 =                                                        \
        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)seqCount) <<     \
          UIAPacket_SEQCOUNT_BIT_SHIFT) & UIAPacket_SEQCOUNT_MASK) |          \
        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)cmdId) <<        \
          UIAPacket_CMDID_BIT_SHIFT) & UIAPacket_CMDID_MASK);                 \
                                                                              \
    (pPktHdr)->word3 =                                                        \
        ti_uiactools_runtime_UIAPacket_swizzle(tag);                                \
                                                                              \
    (pPktHdr)->word4 =                                                        \
        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16(destAdrs)  <<            \
          UIAPacket_DESTADRS_BIT_SHIFT) & UIAPacket_DESTADRS_MASK) |          \
        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16(senderAdrs)  <<          \
          UIAPacket_SENDERADRS_BIT_SHIFT) & UIAPacket_SENDERADRS_MASK);       \
    }

/*
 * ======== UIAPacket_initEventRecHdr ========
 * initializes all bitfields in the event record header
 */
#define ti_uiactools_runtime_UIAPacket_initEventRecHdr(pPktHdr, endianness,         \
            eventLength, seqCount, priority, moduleId, instanceId, destAdrs, senderAdrs) \
    {(pPktHdr)->word1 = (                                                     \
        ((Bits32)(ti_uiactools_runtime_UIAPacket_HdrType_EventPkt) <<               \
          UIAPacket_HDRTYPE_BIT_SHIFT)                             |          \
        (((Bits32)(endianness) <<                                             \
          UIAPacket_ENDIAN_BIT_SHIFT) & UIAPacket_ENDIAN_MASK)     |          \
        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle(eventLength) <<            \
          UIAPacket_EVENTLEN_BIT_SHIFT) & UIAPacket_EVENTLEN_MASK));          \
                                                                              \
    (pPktHdr)->word2 =                                                        \
        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)seqCount) <<     \
          UIAPacket_SEQCOUNT_BIT_SHIFT) & UIAPacket_SEQCOUNT_MASK) |          \
        ((((Bits32)priority) <<                                               \
          UIAPacket_PRIORITY_BIT_SHIFT) & UIAPacket_PRIORITY_MASK);           \
                                                                              \
    (pPktHdr)->word3 =                                                        \
        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)moduleId) <<     \
          UIAPacket_MODULEID_BIT_SHIFT) & UIAPacket_MODULEID_MASK) |          \
        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)instanceId) <<   \
          UIAPacket_INSTANCEID_BIT_SHIFT) & UIAPacket_INSTANCEID_MASK);       \
                                                                              \
    (pPktHdr)->word4 =                                                        \
        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16(destAdrs)  <<            \
          UIAPacket_DESTADRS_BIT_SHIFT) & UIAPacket_DESTADRS_MASK) |          \
        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16(senderAdrs)  <<          \
          UIAPacket_SENDERADRS_BIT_SHIFT) & UIAPacket_SENDERADRS_MASK);       \
    }

/*
 * ======== getFooter ========
 * returns the integer to use as the packet footer
 */
#ifdef UIAPacket_ISBIGENDIAN
#define ti_uiactools_runtime_UIAPacket_getFooter(pPktHdr) \
        (((Int32)(pPktHdr)->UIAPacket_MSGLEN_WORD & UIAPacket_LENGTH_SHIFTED_MASK) | UIAPacket_FOOTER_MAGIC_NUMBER)
#else
#define ti_uiactools_runtime_UIAPacket_getFooter(pPktHdr) \
        ((Int32)(pPktHdr)->UIAPacket_MSGLEN_WORD & (UIAPacket_LENGTH_WORDMASK_0 | UIAPacket_LENGTH_WORDMASK_1) | UIAPacket_FOOTER_MAGIC_NUMBER)
#endif


/*
 *  ======== UIAPacket_setInvalidHdr ========
 *  sets the len of the event from the invalid header
 *
 *  Using the fact that HdrType_InvalidData is zero and we don't care about the 
 *  endianness of the payload.
 */
#define ti_uiactools_runtime_UIAPacket_setInvalidHdr(pPktHdr, eventLength)     \
    *((Bits32 *)(pPktHdr)) = (Bits32)ti_uiactools_runtime_UIAPacket_swizzle(eventLength)

/*
 *  ======== UIAPacket_getEndpointNumber ========
 *  gets the endpoint number from the trace packet header
 */
#define ti_uiactools_runtime_UIAPacket_getEndpointNumber(pPktHdr7 ) \
    (ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)                                \
     (((Bits32)(pPktHdr7)->UIAPacket_ENDPTNUM_WORD & UIAPacket_ENDPTNUM_MASK) >> \
      UIAPacket_ENDPTNUM_BIT_SHIFT)))

/*
 *  ======== UIAPacket_setEndpointNumber ========
 *  sets the endpoint number in the trace packet header
 */
#define ti_uiactools_runtime_UIAPacket_setEndpointNumber(pPktHdr, ENDPTNUM)       \
    ((pPktHdr)->UIAPacket_ENDPTNUM_WORD =                                  \
     (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)ENDPTNUM) <<     \
      UIAPacket_ENDPTNUM_BIT_SHIFT) & UIAPacket_ENDPTNUM_MASK) |           \
     ((Bits32)(pPktHdr)->UIAPacket_ENDPTNUM_WORD & ~UIAPacket_ENDPTNUM_MASK))

 /*
  * *  ======== UIAPacket_getFirstPktFlag ========
  *  gets the first packet flag from the trace packet header
  */
#define ti_uiactools_runtime_UIAPacket_getFirstPktFlag(pPktHdr7)                   \
    ((Bool)(((Bits32)(pPktHdr7)->UIAPacket_FIRSTPKTFLAG_WORD & UIAPacket_FIRSTPKTFLAG_MASK) >> \
    		UIAPacket_FIRSTPKTFLAG_BIT_SHIFT))


/*
 *  ======== UIAPacket_getTracePktDownCount ========
 *  gets the endpoint number from the trace packet header
 */
#define ti_uiactools_runtime_UIAPacket_getTracePktDownCount(pPktHdr7 ) \
    (ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)                                \
     (((Bits32)(pPktHdr7)->UIAPacket_TRACEDOWNCOUNT_WORD & UIAPacket_TRACEDOWNCOUNT_MASK) >> \
      UIAPacket_TRACEDOWNCOUNT_BIT_SHIFT)))

/*
 * ======== UIAPacket_getSnapshotNumber =========
 * gets the 32b snapshot number from the trace packet header
 */
#define ti_uiactools_runtime_UIAPacket_getSnapshotNumber(pPktHdr7) \
        (ti_uiactools_runtime_UIAPacket_swizzle( \
		((Bits32)(pPktHdr7)->UIAPacket_SNAPSHOTNUM_WORD & UIAPacket_SNAPSHOTNUM_MASK) >> \
		UIAPacket_SNAPSHOTNUM_BIT_SHIFT))
		
/*
 * ======== UIAPacket_initTraceRecHdr ========
 * initializes all bitfields in word5 and word6 of the trace packet header.
 * Use initEventRecHdr to initialize the first 4 words of the trace packet header.
 *
 *  pHdr:   pointer to the 6-word trace packet header
 *  endpointNumber: the endpoint number of the ETB that the data is from
 *  isFirstPacket:  true for the first packet in the trace snapshot
 *  tracePktDownCount: the number of packets left to send in the trace snapshot (15b)
 *  traceSnapshotNumber: the trace snapshot number (24b)
 */
#define ti_uiactools_runtime_UIAPacket_initTraceRecHdr(pPktHdr, traceHdrType, endianness,         \
            eventLength, seqCount, priority, moduleId, instanceId, destAdrs, senderAdrs, \
            endpointNumber, isFirstPacket, tracePktDownCount, traceSnapshotNumber) \
                                    {(pPktHdr)->word1 = (                                                     \
                                        ((Bits32)(traceHdrType) <<               \
                                          UIAPacket_HDRTYPE_BIT_SHIFT)                             |          \
                                        (((Bits32)(endianness) <<                                             \
                                          UIAPacket_ENDIAN_BIT_SHIFT) & UIAPacket_ENDIAN_MASK)     |          \
                                        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle(eventLength) <<            \
                                          UIAPacket_EVENTLEN_BIT_SHIFT) & UIAPacket_EVENTLEN_MASK));          \
                                                                                                              \
                                    (pPktHdr)->word2 =                                                        \
                                        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)seqCount) <<     \
                                          UIAPacket_SEQCOUNT_BIT_SHIFT) & UIAPacket_SEQCOUNT_MASK) |          \
                                        ((((Bits32)priority) <<                                               \
                                          UIAPacket_PRIORITY_BIT_SHIFT) & UIAPacket_PRIORITY_MASK);           \
                                                                                                              \
                                    (pPktHdr)->word3 =                                                        \
                                        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)moduleId) <<     \
                                          UIAPacket_MODULEID_BIT_SHIFT) & UIAPacket_MODULEID_MASK) |          \
                                        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)instanceId) <<   \
                                          UIAPacket_INSTANCEID_BIT_SHIFT) & UIAPacket_INSTANCEID_MASK);       \
                                                                                                              \
                                    (pPktHdr)->word4 =                                                        \
                                        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16(destAdrs)  <<            \
                                          UIAPacket_DESTADRS_BIT_SHIFT) & UIAPacket_DESTADRS_MASK) |          \
                                        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16(senderAdrs)  <<          \
                                          UIAPacket_SENDERADRS_BIT_SHIFT) & UIAPacket_SENDERADRS_MASK);       \
                                                                                                              \
                                    (pPktHdr)->word5 = 0;                                                     \
                                                                                                              \
									(pPktHdr)->word6 =                                                        \
                                        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)tracePktDownCount) <<     \
                                          UIAPacket_TRACEDOWNCOUNT_BIT_SHIFT) & UIAPacket_TRACEDOWNCOUNT_MASK) |          \
                                        ((Bits32)((isFirstPacket) << \
                                          UIAPacket_FIRSTPKTFLAG_BIT_SHIFT) & UIAPacket_FIRSTPKTFLAG_MASK) |   \
                                        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)endpointNumber) <<   \
                                          UIAPacket_ENDPTNUM_BIT_SHIFT) & UIAPacket_ENDPTNUM_MASK);            \
                                                                                                               \
                                    (pPktHdr)->word7 =                                                         \
                                        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle(traceSnapshotNumber)  <<  \
                                          UIAPacket_SNAPSHOTNUM_BIT_SHIFT) & UIAPacket_SNAPSHOTNUM_MASK);      \
                                    }

/*
 * ======== UIAPacket_initTraceRecHdr ========
 * initializes all bitfields in word5 and word6 of the trace packet header.
 * Use initEventRecHdr to initialize the first 4 words of the trace packet header.
 *
 *  pHdr:   pointer to the 6-word trace packet header
 *  endpointNumber: the endpoint number of the ETB that the data is from
 *  isFirstPacket:  true for the first packet in the trace snapshot
 *  tracePktDownCount: the number of packets left to send in the trace snapshot (15b)
 *  traceSnapshotNumber: the trace snapshot number (24b)
 */
#define ti_uiactools_runtime_UIAPacket_initTraceHdrFields(pPktHdr, traceHdrType,  \
            endpointNumber, isFirstPacket, tracePktDownCount, traceSnapshotNumber) \
                                    {(pPktHdr)->word1 =                                                       \
	                                    ((pPktHdr)->word1 & (~UIAPacket_HDRTYPE_MASK)|                        \
                                        ((Bits32)(traceHdrType) <<                                            \
                                          UIAPacket_HDRTYPE_BIT_SHIFT) );                                     \
                                                                                                              \
                                    (pPktHdr)->word6 =                                                        \
                                        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)tracePktDownCount) <<     \
                                          UIAPacket_TRACEDOWNCOUNT_BIT_SHIFT) & UIAPacket_TRACEDOWNCOUNT_MASK) |          \
                                        ((Bits32)(isFirstPacket <<  \
                                          UIAPacket_FIRSTPKTFLAG_BIT_SHIFT) & UIAPacket_FIRSTPKTFLAG_MASK) |   \
                                        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle16((Bits16)endpointNumber) <<   \
                                          UIAPacket_ENDPTNUM_BIT_SHIFT) & UIAPacket_ENDPTNUM_MASK);            \
                                                                                                               \
                                    (pPktHdr)->word7 =                                                         \
                                        (((Bits32)ti_uiactools_runtime_UIAPacket_swizzle(traceSnapshotNumber)  <<  \
                                          UIAPacket_SNAPSHOTNUM_BIT_SHIFT) & UIAPacket_SNAPSHOTNUM_MASK);      \
                                    }


/*
 *  @(#) ti.uia.runtime; 1, 0, 0, 2,1; 3-27-2012 14:13:11; /db/vtree/library/trees/uia/uia-d04/src/ xlibrary

 */

