/* 
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * */

/*
 *  ======== LoggingSetupSTM.xs ========
 */

var LoggingSetupSTM;
var Logger;
var Load;
var Diags;
var Main;
var isOverflowLoggerAssigned = false;
var isEnableDebugPrintf = false;
var loggerInstance = null;

/*
 *  ======== module$use ========
 */
function module$use()
{
    var logger2;
    /* Use the most common event defintion modules */
    var UIAEvt = xdc.useModule('ti.uia.events.UIAEvt');
    var UIAErr = xdc.useModule('ti.uia.events.UIAErr');
    var UIABenchmark = xdc.useModule('ti.uia.events.UIABenchmark');
    var UIARoundtrip = xdc.useModule('ti.uia.events.UIARoundtrip');
    var UIAStatistic = xdc.useModule('ti.uia.events.UIAStatistic');
    var UIAMetaData = xdc.useModule('ti.uia.runtime.UIAMetaData');
    
    /* Work-around to TimestampProvider plugging issue with pre-BIOS 6.32 */
    var Settings = xdc.module("ti.sysbios.family.Settings");
    xdc.useModule(Settings.getDefaultTimestampDelegate());
    
    LoggingSetupSTM = this;
    
 //   UIAMetaData.setLoggingSetupConfigured();

    Diags = xdc.useModule('xdc.runtime.Diags');
    if (!LoggingSetupSTM.disableMulticoreEventCorrelation){

        /* configure the LogSync module to use the correct 
		 * type of logger to log the sync points with
         */
        var LogSync = xdc.useModule('ti.uia.runtime.LogSync');
        //LogSync.isUsedByLoggingSetup();

        switch (LoggingSetupSTM.eventUploadMode){
        case LoggingSetupSTM.UploadMode_SIMULATOR:
        case LoggingSetupSTM.UploadMode_PROBEPOINT:
            xdc.useModule('ti.uia.runtime.LoggerStopMode');
            LogSync.setSyncLogger('ti.uia.runtime.LoggerStopMode');
            break;
        case LoggingSetupSTM.UploadMode_JTAGSTOPMODE:
            xdc.useModule('ti.uia.runtime.LoggerStopMode');
            LogSync.setSyncLogger('ti.uia.runtime.LoggerStopMode');
            break;
        case LoggingSetupSTM.UploadMode_JTAGRUNMODE:
            xdc.useModule('ti.uia.runtime.LoggerCircBuf');
            LogSync.setSyncLogger('ti.uia.runtime.LoggerCircBuf');
            break;
        case LoggingSetupSTM.UploadMode_NONJTAGTRANSPORT:
        case LoggingSetupSTM.UploadMode_NONJTAG_AND_JTAGSTOPMODE:
            xdc.useModule('ti.uia.runtime.LoggerCircBuf');
            LogSync.setSyncLogger('ti.uia.runtime.LoggerCircBuf');
            break;
        case LoggingSetupSTM.UploadMode_STREAMER:
            xdc.useModule('ti.uia.sysbios.LoggerStreamer');
            LogSync.setSyncLogger('ti.uia.sysbios.LoggerStreamer');
            break;
        case LoggingSetupSTM.UploadMode_IDLE:
            xdc.useModule('ti.uia.sysbios.LoggerStreamer');
            LogSync.setSyncLogger('ti.uia.sysbios.LoggerStreamer');
            break;
        case LoggingSetupSTM.UploadMode_STM:
            xdc.useModule('ti.uiactools.runtime.LoggerSTM');
            LogSync.setSyncLogger('ti.uiactools.runtime.LoggerSTM');
            break;			
        }

    }
	
    /* Setup the Load modules loggers and diags mask */
    if (LoggingSetupSTM.loadLogging == true) {
    
        var setting = getDiagsSetting(LoggingSetupSTM.loadLogging, 
                                  LoggingSetupSTM.loadLoggingRuntimeControl);

        /* Turn on the Load module diags mask */
        var Load = xdc.useModule('ti.sysbios.utils.Load');
        
        if (Load.common$.diags_USER4 === undefined) {
            Load.common$.diags_USER4 = setting;
        }

        /* If no logger supplied to this module, create one */
        if (LoggingSetupSTM.logger == null) {
            /* Create the logger instance */
            logger2 = createLogger("Load Logger",null);
        }
        else {
            logger2 = LoggingSetupSTM.logger;
        }

        /* Plug it*/
        setLogger(Load, logger2);
    }

    /* Setup Main and non-xdc modules loggers and diags mask */
    if (LoggingSetupSTM.mainLogging == true) {
    
        var setting = getDiagsSetting(LoggingSetupSTM.mainLogging, 
                                  LoggingSetupSTM.mainLoggingRuntimeControl);

        /* Turn on the Main module diags mask */
        var Main = xdc.useModule('xdc.runtime.Main');
        
        if (Main.common$.diags_STATUS === undefined) {
            Main.common$.diags_STATUS = setting;
        }
        if (Main.common$.diags_ANALYSIS === undefined) {
            Main.common$.diags_ANALYSIS = setting;
        }
        if (Main.common$.diags_INFO === undefined) {
            Main.common$.diags_INFO = setting;
        }
        if (Main.common$.diags_USER1 === undefined) {
            Main.common$.diags_USER1 = setting;
        }
        if (Main.common$.diags_USER2 === undefined) {
            Main.common$.diags_USER2 = setting;
        }
        if (Main.common$.diags_USER3 === undefined) {
            Main.common$.diags_USER3 = setting;
        }
        if (Main.common$.diags_USER4 === undefined) {
            Main.common$.diags_USER4 = setting;
        }
        if (Main.common$.diags_USER5 === undefined) {
            Main.common$.diags_USER5 = setting;
        }
        if (Main.common$.diags_USER6 === undefined) {
            Main.common$.diags_USER6 = setting;
        }
        
        /* If no logger supplied to this module, create one */
        if (LoggingSetupSTM.logger == null) {
            logger2 = createLogger("Main Logger", null);
        }
        else {
            logger2 = LoggingSetupSTM.logger;
        }
        
        /* Plug it*/
        setLogger(Main, logger2);
        
        /* Plug Registry's logger also if not defined */
        var Registry = xdc.useModule('xdc.runtime.Registry');
        setLogger(Registry, logger2);
    }

    /* Setup SYSBIOS modules loggers and diags mask */
    var createHwiLogger = false;
    var createSwiLogger = false;
    var createTaskLogger = false;

    /* Setup the SYSBIOS Hwi and Clock diags masks */
    if (LoggingSetupSTM.sysbiosHwiLogging == true) {
    
        var setting = getDiagsSetting(LoggingSetupSTM.sysbiosHwiLogging, 
                                  LoggingSetupSTM.sysbiosHwiLoggingRuntimeControl);

        var Hwi = xdc.useModule('ti.sysbios.hal.Hwi');
        var HwiDelegate = Hwi.HwiProxy.delegate$;

        if (HwiDelegate.common$.diags_USER1 === undefined) {
            HwiDelegate.common$.diags_USER1 = setting;
        }
        if (HwiDelegate.common$.diags_USER2 === undefined) {
            HwiDelegate.common$.diags_USER2 = setting;
        }
        if (Hwi.common$.diags_USER1 === undefined) {
            Hwi.common$.diags_USER1 = setting;
        }
        if (Hwi.common$.diags_USER2 === undefined) {
            Hwi.common$.diags_USER2 = setting;
        }

        Clock = xdc.useModule('ti.sysbios.knl.Clock');
        if (Clock.common$.diags_USER1 === undefined) {
            Clock.common$.diags_USER1 = setting;
        }
        if (Clock.common$.diags_USER2 === undefined) {
            Clock.common$.diags_USER2 = setting;
        }
        if (Clock.common$.diags_USER3 === undefined) {
            Clock.common$.diags_USER3 = setting;
        }
        
        /* If no logger supplied to this module, create one */
        if (LoggingSetupSTM.logger == null) {
            createHwiLogger = true;
        }
        else {
            Hwi.common$.logger = LoggingSetupSTM.logger;
            HwiDelegate.common$.logger = LoggingSetupSTM.logger;        
            Clock.common$.logger = LoggingSetupSTM.logger;
        }        
    }

    /* Setup SYSBIOS Swi diags mask */
    if (LoggingSetupSTM.sysbiosSwiLogging == true) {
    
        var setting = getDiagsSetting(LoggingSetupSTM.sysbiosSwiLogging, 
                                  LoggingSetupSTM.sysbiosSwiLoggingRuntimeControl);
                                  
        var Swi = xdc.useModule('ti.sysbios.knl.Swi');

        if (Swi.common$.diags_USER1 === undefined) {
            Swi.common$.diags_USER1 = setting;
        }
        if (Swi.common$.diags_USER2 === undefined) {
            Swi.common$.diags_USER2 = setting;
        }

        /* If no logger supplied to this module, create one */
        if (LoggingSetupSTM.logger == null) {
            createSwiLogger = true;
        }
        else {
            Swi.common$.logger = LoggingSetupSTM.logger;
        }
    }

    /* Setup SYSBIOS Task and related modules diags mask */
    if (LoggingSetupSTM.sysbiosTaskLogging == true) {
        
        var setting = getDiagsSetting(LoggingSetupSTM.sysbiosTaskLogging, 
                                  LoggingSetupSTM.sysbiosTaskLoggingRuntimeControl);
                                  
        Task = xdc.useModule('ti.sysbios.knl.Task');
        if (Task.common$.diags_USER1 === undefined) {
            Task.common$.diags_USER1 = setting;
        }
        if (Task.common$.diags_USER2 === undefined) {
            Task.common$.diags_USER2 = setting;
        }

        Semaphore = xdc.useModule('ti.sysbios.knl.Semaphore');
        if (Semaphore.common$.diags_USER1 === undefined) {
            Semaphore.common$.diags_USER1 = setting;
        }
        if (Semaphore.common$.diags_USER2 === undefined) {
            Semaphore.common$.diags_USER2 = setting;
        }

        Event = xdc.useModule('ti.sysbios.knl.Event');
        if (Event.common$.diags_USER1 === undefined) {
            Event.common$.diags_USER1 = setting;
        }
        if (Event.common$.diags_USER2 === undefined) {
            Event.common$.diags_USER2 = setting;
        }

        /* If no logger supplied to this module, create one */
        if (LoggingSetupSTM.logger == null) {
            createTaskLogger = true;
        }
        else {
            Task.common$.logger = LoggingSetupSTM.logger;
            Semaphore.common$.logger = LoggingSetupSTM.logger;
            Event.common$.logger = LoggingSetupSTM.logger;
        }        
    }

    /* Setup SYSBIOS Task and related modules diags mask */
    if ((createHwiLogger == true) || (createSwiLogger == true) ||
        (createTaskLogger == true)) {

        /* Create the logger for all SYSBIOS modules */
        logger2 = createLogger("SYSBIOS System Logger",null);
    }

    if (createHwiLogger == true) {
        setLogger(Hwi, logger2);
        setLogger(HwiDelegate, logger2);        
        setLogger(Clock, logger2);
    }

    if (createSwiLogger == true) {
        setLogger(Swi, logger2);
    }

    if (createTaskLogger == true) {
        setLogger(Task, logger2);
        setLogger(Semaphore, logger2);
        setLogger(Event, logger2);        
    }

 
}

/*
 * ======== createLogger =========
 * internal helper function that creates a LoggerSTM logger.
 *
 * param loggerInstanceName: the name to assign to the logger instance (for debugging)
 * param loggerPriority: the IUIATransfer.Priority to assign to the logger instance
 * returns the logger instance that was created
 */
function createLogger(loggerInstanceName,loggerPriority){
    /* Create the logger instance */
    var IUIATransfer = xdc.module('ti.uia.runtime.IUIATransfer');
    if (isEnableDebugPrintf){
        print("LoggingSetupSTM: LoggerSTM used for "+loggerInstanceName);
    }
    
	switch (LoggingSetupSTM.eventUploadMode){
	case LoggingSetupSTM.UploadMode_SIMULATOR:
	case LoggingSetupSTM.UploadMode_PROBEPOINT:
		Logger = xdc.module('ti.uia.runtime.LoggerStopMode');
		break;
	case LoggingSetupSTM.UploadMode_JTAGSTOPMODE:
		Logger = xdc.module('ti.uia.runtime.LoggerStopMode');
		break;
	case LoggingSetupSTM.UploadMode_JTAGRUNMODE:
		Logger = xdc.module('ti.uia.runtime.LoggerCircBuf');
		break;
	case LoggingSetupSTM.UploadMode_NONJTAGTRANSPORT:
	case LoggingSetupSTM.UploadMode_NONJTAG_AND_JTAGSTOPMODE:
		Logger = xdc.module('ti.uia.runtime.LoggerCircBuf');
		break;
	case LoggingSetupSTM.UploadMode_STREAMER:
		Logger = xdc.module('ti.uia.sysbios.LoggerStreamer');
		break;
	case LoggingSetupSTM.UploadMode_IDLE:
		Logger = xdc.module('ti.uia.sysbios.LoggerStreamer');
		break;
	case LoggingSetupSTM.UploadMode_STM:
		Logger = xdc.module('ti.uiactools.runtime.LoggerSTM');
		break;			
	}
    if (loggerInstance == null) {
         loggerInstance = Logger.create();
    }
    return loggerInstance;

}

/*
 *  ======== setLogger ========
 *
 */
function setLogger(mod, logger)
{
    /* Warn if the user has already set the logger for this module. */
    if (mod.common$.logger != undefined) {
        mod.$logWarning(mod.$name + ".common$.logger has already " +
                        "been assigned, LoggingSetupSTM reassigning logger to " +
                        logger.instance.name, mod);
    }
    
    mod.common$.logger = logger;
}

/*
 *  ======== getDiagsSetting ========
 */
function getDiagsSetting(enabled, runtimeCtrl)
{
    if (!enabled && !runtimeCtrl) {
        return (Diags.ALWAYS_OFF);
    }
    else if (!enabled && runtimeCtrl) {
        return (Diags.RUNTIME_OFF);
    }
    else if (enabled && !runtimeCtrl) {
        return (Diags.ALWAYS_ON);
    }
    else if (enabled && runtimeCtrl) {
        return (Diags.RUNTIME_ON);
    }
}

/*
 */
/*
 *  @(#) ti.uiactools.sysbios; 1, 0, 0, 0,1; 2-13-2012 15:15:39; /db/vtree/library/trees/uia/uia-c35/src/ xlibrary

 */

