#include <stdint.h>
#include <drivers/epwm.h>
#include <drivers/hw_include/hw_types.h>
#include <drivers/hw_include/csl_types.h>
#include "user_pwm_api.h"

void EPWM_etSocACfg(uint32_t baseAddr, uint32_t socAType)
{
    uint32_t regVal =
        HW_RD_REG16((baseAddr + USER_PWMSS_EPWM_OFFSET) + PWMSS_EPWM_ETSEL);
    regVal &= ~(PWMSS_EPWM_ETSEL_SOCASEL_MASK);

    if (EPWM_ET_SOCASEL_CNT_EQ_ZRO == socAType)
    {
        regVal |= (((PWMSS_EPWM_ETSEL_SOCASEL_CTR_0) << PWMSS_EPWM_ETSEL_SOCASEL_SHIFT)
            & (PWMSS_EPWM_ETSEL_SOCASEL_MASK));
    }
    else if (EPWM_ET_SOCASEL_CNT_EQ_PRD == socAType)
    {
        regVal |= (((PWMSS_EPWM_ETSEL_SOCASEL_CTR_PERIOD) << PWMSS_EPWM_ETSEL_SOCASEL_SHIFT)
            & (PWMSS_EPWM_ETSEL_SOCASEL_MASK));
    }
    else if (EPWM_ET_SOCASEL_CNT_EQ_CMPA_INC == socAType)
    {
        regVal |= (((PWMSS_EPWM_ETSEL_SOCASEL_CTR_CMPA_INCR) << PWMSS_EPWM_ETSEL_SOCASEL_SHIFT)
            & (PWMSS_EPWM_ETSEL_SOCASEL_MASK));
    }
    else if (EPWM_ET_SOCASEL_CNT_EQ_CMPA_DEC == socAType)
    {
        regVal |= (((PWMSS_EPWM_ETSEL_SOCASEL_CTR_CMPA_DECR) << PWMSS_EPWM_ETSEL_SOCASEL_SHIFT)
            & (PWMSS_EPWM_ETSEL_SOCASEL_MASK));
    }
    else if (EPWM_ET_SOCASEL_CNT_EQ_CMPB_INC == socAType)
    {
        regVal |= (((PWMSS_EPWM_ETSEL_SOCASEL_CTR_CMPB_INCR) << PWMSS_EPWM_ETSEL_SOCASEL_SHIFT)
            & (PWMSS_EPWM_ETSEL_SOCASEL_MASK));
    }
    else if (EPWM_ET_SOCASEL_CNT_EQ_CMPB_DEC == socAType)
    {
        regVal |= (((PWMSS_EPWM_ETSEL_SOCASEL_CTR_CMPB_DECR) << PWMSS_EPWM_ETSEL_SOCASEL_SHIFT)
            & (PWMSS_EPWM_ETSEL_SOCASEL_MASK));
    }
    else
    {
        /* This error does not happen because of check done already */
    }

    HW_WR_REG16(((baseAddr + USER_PWMSS_EPWM_OFFSET) + PWMSS_EPWM_ETSEL),
        (uint16_t)regVal);
}

void EPWM_etSocAEnable(uint32_t baseAddr)
{
    HW_WR_FIELD16(((baseAddr + USER_PWMSS_EPWM_OFFSET) + PWMSS_EPWM_ETSEL),
        PWMSS_EPWM_ETSEL_SOCA, (uint16_t)PWMSS_EPWM_ETSEL_SOCA_ENABLE);
}

void EPWM_etSocADisable(uint32_t baseAddr)
{
    HW_WR_FIELD16(((baseAddr + USER_PWMSS_EPWM_OFFSET) + PWMSS_EPWM_ETSEL),
        PWMSS_EPWM_ETSEL_SOCA, (uint16_t)PWMSS_EPWM_ETSEL_SOCA_DISABLE);
}

void EPWM_etSocACntCfg(uint32_t baseAddr, uint32_t cntEvent)
{

    /* Configure the count */
    HW_WR_FIELD16(((baseAddr + USER_PWMSS_EPWM_OFFSET) + PWMSS_EPWM_ETPS),
        PWMSS_EPWM_ETPS_SOCACNT, (uint16_t)cntEvent);
}
