#ifndef USER_PWM_API_H_
#define USER_PWM_API_H_

#include <stdint.h>

#define PWMSS_EPWM_ETSEL_SOCASEL_SHIFT                                                    (8U)
#define PWMSS_EPWM_ETSEL_SOCASEL_MASK                                                     (0x00000700U)
#define PWMSS_EPWM_ETSEL_SOCASEL_CTR_CMPB_INCR                                            (6U)
#define PWMSS_EPWM_ETSEL_SOCASEL_CTR_CMPA_DECR                                            (5U)
#define PWMSS_EPWM_ETSEL_SOCASEL_CTR_0                                                    (1U)
#define PWMSS_EPWM_ETSEL_SOCASEL_CTR_PERIOD                                               (2U)
#define PWMSS_EPWM_ETSEL_SOCASEL_CTR_CMPA_INCR                                            (4U)
#define PWMSS_EPWM_ETSEL_SOCASEL_CTR_CMPB_DECR                                            (7U)

#define PWMSS_EPWM_ETSEL_SOCA_SHIFT                                                    (11U)
#define PWMSS_EPWM_ETSEL_SOCA_MASK                                                     (0x00000800U)
#define PWMSS_EPWM_ETSEL_SOCA_DISABLE                                                   (0U)
#define PWMSS_EPWM_ETSEL_SOCA_ENABLE                                                    (1U)

#define PWMSS_EPWM_ETPS_SOCACNT_SHIFT                                                    (8U)
#define PWMSS_EPWM_ETPS_SOCACNT_MASK                                                     (0x00000300U)
#define PWMSS_EPWM_ETPS_SOCACNT_EVT_3                                                     (3U)

#define PWMSS_EPWM_ETPS_SOCACNT_NO_EVT                                                    (0U)
#define PWMSS_EPWM_ETPS_SOCACNT_EVT_1                                                     (1U)
#define PWMSS_EPWM_ETPS_SOCACNT_EVT_2                                                     (2U)


/** \brief EPWM offset within PWMSS */
#define USER_PWMSS_EPWM_OFFSET                                                            (0x0U)

/**
 *  \anchor EPWM_EtSocASelEvt_t
 *  \name EPWM SOCA output Selection Options
 *  @{
 */
/** \brief ePWM SOCA output Selection Options. */
typedef uint32_t EPWM_EtSocASelEvt_t;
#define EPWM_ET_SOCASEL_CNT_EQ_ZRO       (PWMSS_EPWM_ETSEL_SOCASEL_CTR_0)
/**< Enable event time-base counter equal to zero. (TBCNT = 0000h).*/
#define EPWM_ET_SOCASEL_CNT_EQ_PRD       (PWMSS_EPWM_ETSEL_SOCASEL_CTR_PERIOD)
/**< Enable event time-base counter equal to period (TBCNT = TBPRD).*/
#define EPWM_ET_SOCASEL_CNT_EQ_CMPA_INC  (PWMSS_EPWM_ETSEL_SOCASEL_CTR_CMPA_INCR)
/**< Enable event time-base counter equal to CMPA when the timer is
         incrementing.*/
#define EPWM_ET_SOCASEL_CNT_EQ_CMPA_DEC  (PWMSS_EPWM_ETSEL_SOCASEL_CTR_CMPA_DECR)
/**< Enable event time-base counter equal to CMPA when the timer is
         decrementing.*/
#define EPWM_ET_SOCASEL_CNT_EQ_CMPB_INC  (PWMSS_EPWM_ETSEL_SOCASEL_CTR_CMPB_INCR)
/**< Enable event: time-base counter equal to CMPB when the timer is
         incrementing.*/
#define EPWM_ET_SOCASEL_CNT_EQ_CMPB_DEC  (PWMSS_EPWM_ETSEL_SOCASEL_CTR_CMPB_DECR)
/**< Enable event: time-base counter equal to CMPB when the timer is
         decrementing.*/
/** @} */


/**
 *  \anchor EPWM_EtSocACnt_t
 *  \name EPWM SOCA (SOCA) count Select
 *  @{
 */
/** \brief ePWM SOCA count selection. */
typedef uint32_t EPWM_EtSocACnt_t;
#define EPWM_PS_ETPS_SOCACNT_DIS_INTR   (PWMSS_EPWM_ETPS_SOCACNT_NO_EVT)
/**< Disable the interrupt event counter. No interrupt will be generated. */
#define EPWM_PS_ETPS_SOCACNT_FIRST_EVT  (PWMSS_EPWM_ETPS_SOCACNT_EVT_1)
/**< Generate one pulse on SOCA every 1 PWM count. */
#define EPWM_PS_ETPS_SOCACNT_SECOND_EVT (PWMSS_EPWM_ETPS_SOCACNT_EVT_2)
/**< Generate one pulse on SOCA every 2 PWM count. */
#define EPWM_PS_ETPS_SOCACNT_THIRD_EVT  (PWMSS_EPWM_ETPS_SOCACNT_EVT_3)
/**< Generate one pulse on SOCA every 3 PWM count. */
/** @} */


/**
 * \brief   This API configure SocA type.
 *
 * \param   baseAddr    Base Address of PWMSS instance used.
 * \param   socAType  socA type.
 */
void EPWM_etSocACfg(uint32_t baseAddr, uint32_t socAType);

/**
 * \brief   This API enables the ePWM SocA output.
 *
 * \param   baseAddr    Base Address of PWMSS instance used.
 */
void EPWM_etSocAEnable(uint32_t baseAddr);

/**
 * \brief   This API disables the ePWM SocA output.
 *
 * \param   baseAddr    Base Address of PWMSS instance used.
 */
void EPWM_etSocADisable(uint32_t baseAddr);

/**
 * \brief   This API configure SocA count.
 *
 * \param   baseAddr    Base Address of PWMSS instance used.
 * \param   cntEvent    socA count.
 */
void EPWM_etSocACntCfg(uint32_t baseAddr, uint32_t cntEvent);


#endif
