-cr
-x
-stack 0x1000
-heap 0x2000
-l rts64plus_elf.lib

MEMORY
{

  VECTORS_MEM: origin = 0x00800000 length = 0x00000400
  /*Local addresses*/
  BOOT_MEM: origin = 0x00800400 length = 0x00001C00
  TEXT_MEM: origin = 0x00802000 length = 0x0007e000
  DATA_MEM: origin = 0x00880000 length = 0x00080000
  
  L1P_MEM: origin = 0x00E00000 length = 0x00008000
  L1D_MEM: origin = 0x00F00000 length = 0x00008000

  /* Global addresses for Multi-GEM*/
  GEM0_BOOT_MEM: origin = 0x10800400 length = 0x00001C00	
  GEM1_BOOT_MEM: origin = 0x11800400 length = 0x00001C00
  GEM2_BOOT_MEM: origin = 0x12800400 length = 0x00001C00
  GEM3_BOOT_MEM: origin = 0x13800400 length = 0x00001C00
  
  GEM0_TEXT_MEM: origin = 0x10802000 length = 0x0007E000	
  GEM1_TEXT_MEM: origin = 0x11802000 length = 0x0007E000
  GEM2_TEXT_MEM: origin = 0x12802000 length = 0x0007E000
  GEM3_TEXT_MEM: origin = 0x13802000 length = 0x0007E000
  
  GEM0_DATA_MEM: origin = 0x10880000 length = 0x00080000	 
  GEM1_DATA_MEM: origin = 0x11880000 length = 0x00080000
  GEM2_DATA_MEM: origin = 0x12880000 length = 0x00080000
  GEM3_DATA_MEM: origin = 0x13880000 length = 0x00080000
  
  
  DDR3_CONFIG_MEM: origin = 0x21000000 length = 0x00000100
  DDR3_DATA_MEM: origin = 0x80000000 length = 0x20000000
  
 
  /* M3 Config Memory */
  XMC_CONFIG_MEM: 	origin = 0x08000000 length = 0x00020000
  M3_CONFIG_MEM: 	origin = 0x0BC00000 length = 0x00100000
  
  /* M3 RAM */
  M3_RAM_MEM: 		origin = 0x0C000000 length = 0x00200000
  

}
 
SECTIONS
{
  .vectors: > VECTORS_MEM

  /* Boot Memory Sections */
  .boot: > BOOT_MEM
  .gem0_boot: > GEM0_BOOT_MEM
  .gem1_boot: > GEM1_BOOT_MEM
  .gem2_boot: > GEM2_BOOT_MEM
  .gem3_boot: > GEM3_BOOT_MEM

  /* Text Memory Sections */
  .text: > TEXT_MEM
  .gem0_text: > GEM0_TEXT_MEM
  .gem1_text: > GEM1_TEXT_MEM
  .gem2_text: > GEM2_TEXT_MEM
  .gem3_text: > GEM3_TEXT_MEM

  /* Data Memory Sections */
  .data: > DATA_MEM
  .gem0_data: > GEM0_DATA_MEM
  .gem1_data: > GEM1_DATA_MEM
  .gem2_data: > GEM2_DATA_MEM
  .gem3_data: > GEM3_DATA_MEM

  .ddrData: > DDR3_DATA_MEM
  .asmBM > DATA_MEM
  .msmcData: >M3_RAM_MEM
  .l1d_mem: > L1D_MEM
  .l1p_mem: > L1P_MEM

  .fasttext:  >       TEXT_MEM
  .cinit:     >       TEXT_MEM
  .stack:     >       TEXT_MEM
  .bss:       >       TEXT_MEM
  .const:     >       TEXT_MEM
  .far:       >       TEXT_MEM
  .switch:    >       TEXT_MEM
  .sysmem:    >       TEXT_MEM
  .cio        >       TEXT_MEM
  .csl_vect   >       TEXT_MEM
}
