/*****************************************************************************\
*           TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION           
*                                                                            
*  Property of Texas Instruments 
*  For  Unrestricted  Internal  Use  Only 
*  Unauthorized reproduction and/or distribution is strictly prohibited.  
*  This product is protected under copyright law and trade secret law 
*  as an unpublished work.  
*  Created 2006, (C) Copyright 2006 Texas Instruments.  All rights reserved.
*  ------------------------------------------------------------------------------
*  Filename       : val_util.h
*  Description    : Chip level common include file for utility and test reporting 
*					definitions.
*
*****************************************************************************/

#ifndef _VAL_UTIL_H_
#define _VAL_UTIL_H_

#include <ti/csl/csl.h>

#ifndef PASS
#define PASS		(1)
#endif

#ifndef FAIL
#define FAIL		(0)
#endif

#define SUCCESS		PASS
#define FAILURE		FAIL

#define FILL_FIX    (0) /* Used for DataFill function */
#define FILL_INC    (1)
#define FILL_DEC    (2)

/*---------------------------------------------------------------------------*/
/* Macros for tracing debug info into NRP register                           */
/*---------------------------------------------------------------------------*/
extern __cregister volatile Uint32 NRP;
#define VAL_TRACE(value) NRP = ((Uint32)(value)) 

/*---------------------------------------------------------------------------*/
/* Function Prototypes                                                       */
/*---------------------------------------------------------------------------*/
Uint32 VAL_chipInit (void *Ptr);
Uint32 VAL_envInit (void *Ptr);
void VAL_testExit (Uint32 result);
Uint32 global_address (Uint32 addr);
Uint32 DataFill (Uint32 *start_location, Uint32 length, Uint32 fill_value, 
                 Uint32 fill_type);
Uint32 DataCompare (Uint32 *src_location, Uint32 *dst_location, Uint32 length);

void VAL_reportToRegs(Uint32 *repPtr);


#endif /* _VAL_UTIL_H_ */

/*****************************************************************************/
/*                       End of val_util.h file                              */
/*****************************************************************************/
