/*****************************************************************************\
*           TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION           
*                                                                            
*  Property of Texas Instruments 
*  For  Unrestricted  Internal  Use  Only 
*  Unauthorized reproduction and/or distribution is strictly prohibited.  
*  This product is protected under copyright law and trade secret law 
*  as an unpublished work.  
*  Created 2004, (C) Copyright 2003 Texas Instruments.  All rights reserved.
*------------------------------------------------------------------------------
*  Filename       : vcp2_parameters.h
*  Description    : Configuration Parameters for VCP2
\*****************************************************************************/

#define VCP2_NUM_USERS                   20
#define VCP2_NB_32BITWORD_INPUT_PARAMS	 6
#define VCP2_NB_32BITWORD_OUTPUT_PARAMS	 4

VCP2_Params vcpParameters[VCP2_NUM_USERS] = {
/* User0 */
{
    VCP2_RATE_1_4,                             /* rate             */
    9,                                        /* constLen         */
    0xf5,                                     /* poly0            */
    0xb9,                                     /* poly1            */
    0x4b,                                     /* poly2            */
    0x3b,                                     /* poly3            */
    0,                                        /* yamTh            */
    120, 	                              /* frameLen         */
    0,                                        /* relLen           */
    0,                                        /* convDist         */
	0,					                      /* tbstindex	*/	
    0,					                      /* tbstvalue        */
    0,                                       /* outbit_order	  */
    2500,                                     /* maxSm            */
    488,                                      /* minSm            */
    200,                                      /* stateNum         */
    4,                                        /* bmBuffLen        */
    2,                                        /* decBuffLen       */
    1,                                        /* traceBack        */
    1,                                        /* readFlag         */
    0,                                        /* decision         */
    0,                                        /* numBranchMetrics */
    0},                                        /* numDecisions     */


    /* User0 */
{
    VCP2_RATE_1_2,                             /* rate             */
    5,                                        /* constLen         */
    0x30,                                     /* poly0            */
    0xd0,                                     /* poly1            */
    0x00,                                     /* poly2            */
    0x00,                                     /* poly3            */
    0,                                        /* yamTh            */
    1000, 	                              /* frameLen         */
    0,                                        /* relLen           */
    0,                                        /* convDist         */
	0,	             			              /* tbstindex	*/	
    0,					                      /* tbstvalue        */
    0,
    2500,                                     /* maxSm            */
    488,                                      /* minSm            */
    10,                                       /* stateNum         */
    16,                                       /* bmBuffLen        */
    16,                                       /* decBuffLen       */
    1,                                        /* traceBack        */
    1,                                        /* readFlag         */
    0,                                        /* decision         */
    0,                                        /* numBranchMetrics */
    0},                                        /* numDecisions     */


    
    /* User0 */
{
    VCP2_RATE_1_3,                             /* rate             */
    7,                                        /* constLen         */
    0x6c,                                     /* poly0            */
    0xe4,                                     /* poly1            */
    0xd4,                                     /* poly2            */
    0x00,                                     /* poly3            */
    0,                                        /* yamTh            */
    6000, 	                              /* frameLen         */
    336,                                      /* relLen           */
    36,                                       /* convDist         */
	0,	                 		               /* tbstindex	*/	
    0,					                      /* tbstvalue        */
    0,
    2500,                                     /* maxSm            */
    488,                                      /* minSm            */
    50,                                       /* stateNum         */
    8,                                        /* bmBuffLen        */
    32,                                       /* decBuffLen       */
    3,                                        /* traceBack        */
    1,                                        /* readFlag         */
    0,                                        /* decision         */
    0,                                        /* numBranchMetrics */
    0},                                        /* numDecisions     */


    /* User0 */
{
    VCP2_RATE_1_2,                             /* rate             */
    9,                                        /* constLen         */
    0xeb,                                     /* poly0            */
    0x71,                                     /* poly1            */
    0x00,                                     /* poly2            */
    0x00,                                     /* poly3            */
    0,                                        /* yamTh            */
    6000, 	                              /* frameLen         */
    76,                                       /* relLen           */
    48,                                       /* convDist         */
	1,					                      /* tbstindex	*/	
    128,				                      /* tbstvalue        */
    0,                                        /* outbit_order	  */	 
    2500,                                     /* maxSm            */
    488,                                      /* minSm            */
    200,                                      /* stateNum         */
    16,                                       /* bmBuffLen        */
    32,                                       /* decBuffLen       */
    2,                                        /* traceBack        */
    1,                                        /* readFlag         */
    0,                                        /* decision         */
    0,                                        /* numBranchMetrics */
    0}                                        /* numDecisions     */

    
};


//    0,                                        /* SD Native Mode Enable */
//    0,                                        /* BM Native Mode Enable */
//    0,                                        /* SD Native Mode Enable */
//    0,                                        /* BM Native Mode Enable */
//    0,                                        /* SD Native Mode Enable */
//    0,                                        /* BM Native Mode Enable */
//    0,                                        /* SD Native Mode Enable */
//    0}                                        /* BM Native Mode Enable */


/* User 0 global variable declarations */
extern Uint32 refDecUser0[];
extern Uint8  vcpChannelDataUser0[];

/* User 1 global variable declarations */
extern Uint32 refDecUser1[];
extern Uint8  vcpChannelDataUser1[];

/* User 2 global variable declarations */
extern Uint32 refDecUser2[];
extern Uint8  vcpChannelDataUser2[];

/* User 3 global variable declarations */
extern Uint32 refDecUser3[];
extern Uint8  vcpChannelDataUser3[];

/* User 4 global variable declarations */
extern Uint32 refDecUser4[];
extern Uint8  vcpChannelDataUser4[];

/* User 5 global variable declarations */
extern Uint32 refDecUser5[];
extern Uint8  vcpChannelDataUser5[];

/* User 6 global variable declarations */
extern Uint32 refDecUser6[];
extern Uint8  vcpChannelDataUser6[];

/* User 7 global variable declarations */
extern Uint32 refDecUser7[];
extern Uint8  vcpChannelDataUser7[];

/* User 8 global variable declarations */
extern Uint32 refDecUser8[];
extern Uint8  vcpChannelDataUser8[];

/* User 9 global variable declarations */
extern Uint32 refDecUser9[];
extern Uint8  vcpChannelDataUser9[];

/* User 10 global variable declarations */
extern Uint32 refDecUser10[];
extern Uint8  vcpChannelDataUser10[];

/* User 11 global variable declarations */
extern Uint32 refDecUser11[];
extern Uint8  vcpChannelDataUser11[];

/* User 12 global variable declarations */
extern Uint32 refDecUser12[];
extern Uint8  vcpChannelDataUser12[];

/* User 13 global variable declarations */
extern Uint32 refDecUser13[];
extern Uint8  vcpChannelDataUser13[];

/* User 14 global variable declarations */
extern Uint32 refDecUser14[];
extern Uint8  vcpChannelDataUser14[];

/* User 15 global variable declarations */
extern Uint32 refDecUser15[];
extern Uint8  vcpChannelDataUser15[];

/* User 16 global variable declarations */
extern Uint32 refDecUser16[];
extern Uint8  vcpChannelDataUser16[];

/* User 17 global variable declarations */
extern Uint32 refDecUser17[];
extern Uint8  vcpChannelDataUser17[];

/* User 18 global variable declarations */
extern Uint32 refDecUser18[];
extern Uint8  vcpChannelDataUser18[];

/* User 19 global variable declarations */
extern Uint32 refDecUser19[];
extern Uint8  vcpChannelDataUser19[];


Uint32 *referenceDec[VCP2_NUM_USERS] = {&refDecUser0[0],
                                        &refDecUser1[0],
                                        &refDecUser2[0],
                                        &refDecUser3[0],
                                        &refDecUser4[0],
                                        &refDecUser5[0],
                                        &refDecUser6[0],
                                        &refDecUser7[0],
                                        &refDecUser8[0],
                                        &refDecUser9[0],
                                        &refDecUser10[0],
                                        &refDecUser11[0],
                                        &refDecUser12[0],
                                        &refDecUser13[0],
                                        &refDecUser14[0],
                                        &refDecUser15[0],
                                        &refDecUser16[0],
                                        &refDecUser17[0],
                                        &refDecUser18[0],
                                        &refDecUser19[0]
                                        };

VCP2_UserData *vcpUserData[VCP2_NUM_USERS] =
                                        {(VCP2_UserData *)&vcpChannelDataUser0[0],
                                        (VCP2_UserData *)&vcpChannelDataUser1[0],
                                        (VCP2_UserData *)&vcpChannelDataUser2[0],
                                        (VCP2_UserData *)&vcpChannelDataUser3[0],
                                        (VCP2_UserData *)&vcpChannelDataUser4[0],
                                        (VCP2_UserData *)&vcpChannelDataUser5[0],
                                        (VCP2_UserData *)&vcpChannelDataUser6[0],
                                        (VCP2_UserData *)&vcpChannelDataUser7[0],
                                        (VCP2_UserData *)&vcpChannelDataUser8[0],
                                        (VCP2_UserData *)&vcpChannelDataUser9[0],
                                        (VCP2_UserData *)&vcpChannelDataUser10[0],
                                        (VCP2_UserData *)&vcpChannelDataUser11[0],
                                        (VCP2_UserData *)&vcpChannelDataUser12[0],
                                        (VCP2_UserData *)&vcpChannelDataUser13[0],
                                        (VCP2_UserData *)&vcpChannelDataUser14[0],
                                        (VCP2_UserData *)&vcpChannelDataUser15[0],
                                        (VCP2_UserData *)&vcpChannelDataUser16[0],
                                        (VCP2_UserData *)&vcpChannelDataUser17[0],
                                        (VCP2_UserData *)&vcpChannelDataUser18[0],
                                        (VCP2_UserData *)&vcpChannelDataUser19[0]
                                        };
/*****************************************************************************\
* End of vcp2_parameters.h
\*****************************************************************************/














