/*****************************************************************************\
*           TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION           
*                                                                            
*  Property of Texas Instruments 
*  For  Unrestricted  Internal  Use  Only 
*  Unauthorized reproduction and/or distribution is strictly prohibited.  
*  This product is protected under copyright law and trade secret law 
*  as an unpublished work.  
*  Created 2004, (C) Copyright 2003 Texas Instruments.  All rights reserved.
*------------------------------------------------------------------------------
*  Filename       : val_util.c
*  Description    : NySh level Common file for utility and test reporting 
*					functions 
\*****************************************************************************/

#include "val_util.h"
#include <ti/csl/csl_chip.h>

void end_test(int result);

/******************************************************************************
* Function : VAL_chipInit (void *Ptr)
* 
* Description : Performs Chip Initialization
*
* Inputs:
*
* Returns:
******************************************************************************/
Uint32 VAL_chipInit (void *Ptr)
{

 /* Place holder for future compatibility */

    return (SUCCESS);
}

/******************************************************************************
* Function : VAL_envInit (void *Ptr)
* 
* Description : Performs Environment Initialization
*
* Inputs:
*
* Returns:
******************************************************************************/
Uint32 VAL_envInit (void *Ptr)
{

 /* Place holder for future compatibility */

    return (SUCCESS);
}

/******************************************************************************
* Function : VAL_testExit (Uint32 result)
* 
* Description : Performs test reporting by indicating PASS or FAIL
*               to the Test Bench and termitates.
*
* Inputs: result = PASS (0) when the test is passed
*                  FAIL (1) or any non-zero value when the test is failed
*
* Returns: None
******************************************************************************/
void VAL_testExit (Uint32 result)
{
    if(result == 0)
    {
        end_test (FAIL);  	
        //        passed();
        asm("   NOP 5  ");
    }
    else
    {
        end_test(PASS);
        //        failed();
        asm("   NOP 5  ");
    }
}

/*
#define GLOBAL_ADDR(addr) (Uint32)addr<0x1000000?\
						(Uint32)addr+(0x10000000+DNUM*0x1000000):\
						(Uint32)addr
*/
/******************************************************************************
* Function:  void global_address (Uint32 addr)
*
* Purpose:   Returns the gloabl equivalent of a local address
* Inputs:    Uint32 addr - Local address
*
* Returns:   Uint32 addr - Computed global address
******************************************************************************/

Uint32 global_address (Uint32 addr)
{
	Uint32 corenum;
	corenum = CSL_chipReadReg(CSL_CHIP_DNUM); 

	addr = addr + (0x10000000 + corenum*0x1000000);
	return addr;
}


/******************************************************************************
* Function:  DataFill ( Uint32 *start_location, Uint32 length,
*                      Uint32 fill_value, Uint8 fill_type )
*
* Purpose:   Fills a memory location with a pattern as requested. 
*            Beginning at 'start_location', 'length' words (32-bit) are filled,
*            starting with 'fill_value'.  After the initial value, the
*            other memory locations are filled with either a constant
*            value, incrementing values, or decrementing values.
*
* Inputs:    Uint32 *start_location : Memory location to start filling.
*            Uint32 length : Number of 32-bit words to fill.
*            Uint32 fill_value : 32-bit value to start filling with.
*            Uint32 fill_type : Type of fill: 
*                               FILL_FIX, FILL_INC, FILL_DEC
*
* Returns:   Uint32 flag : SUCCESS (0) for a success
*                          FAILURE (1) for a failure
******************************************************************************/

Uint32 DataFill (Uint32 *start_location, Uint32 length, Uint32 fill_value, 
                 Uint32 fill_type)
{
    Uint32  i;
  
    for (i = 0; i < length; i++) {

      if (fill_type == FILL_FIX) {
          *start_location = fill_value;
          /* Check that value was written correctly */
          if (*start_location != fill_value)    
              return FAILURE;
      }
      else if (fill_type == FILL_INC) {
          *start_location = (Uint32)(fill_value+i);
          /* Check that value was written correctly */
          if (*start_location != (Uint32)(fill_value+i))
              return FAILURE;
      }
      else if (fill_type == FILL_DEC) {
          *start_location = (Uint32)(fill_value-i);
          /* Check that value was written correctly */
          if (*start_location != (Uint32)(fill_value-i))
              return FAILURE;
      }
      else {                  
          /* Error if non-valid fill type */
          return FAILURE;
      }
    
      start_location++;
    }

    VAL_TRACE(0xF000A000); /* Set this value into the NRP register for debugging */
    VAL_TRACE(0xF000B000);
  
    return SUCCESS;
}

/******************************************************************************
* Function: DataCompare (Uint32 *src_location, Uint32 *dst_location, 
*                        Uint32 length)
*
* Purpose:  Checks that a transfer was successful by comparing the data
*           in the source buffer against the data in the destination buffer.
*           The total amount of data compared is "length" 32-bit words.
*
* Inputs:   Uint32 *src_location: Source address
*                                       
*           Uint32 *dst_location: Destination address
*
*           Uint32 length  : Number of 32-bit words to check
*
* Returns:  Uint32 flag : PASS for a matching comparison
*                         FAIL for a mis-match
******************************************************************************/
Uint32 DataCompare (Uint32 *src_location, Uint32 *dst_location, Uint32 length )
{
    Uint32  i;
  
    for (i = 0; i < length; i++) {
  
      if (*src_location != *dst_location) { 
           VAL_TRACE (0xF000DBAD);
           VAL_TRACE (i);
           VAL_TRACE (*src_location);
           VAL_TRACE (*dst_location);
           return FAIL; /* Data mis-match */
      }     

      src_location++;
      dst_location++;
  }
  
  return PASS;  /* Data matches */
}

/* For reporting use A7 to A31 and B7 to B31 (excluding B15). Hence total values that can be dumped is 49 */

/******************************************************************************
* Function : VAL_reportToRegs(Uint32 *repPtr)
* 
* Description :   
*               
*
* Inputs: Uint32 *repPtr
*
* Returns: None
******************************************************************************/
void VAL_reportToRegs(Uint32 *repPtr)
{
   /* Copy into A Registers */
	asm(" LDW *A4++,A15"); 
   	asm(" LDW *A4++,A16");   asm(" LDW *A4++,A17");   asm(" LDW *A4++,A18"); 
   	asm(" LDW *A4++,A19");   asm(" LDW *A4++,A20");   asm(" LDW *A4++,A21"); 
   	asm(" LDW *A4++,A22");   asm(" LDW *A4++,A23");   asm(" LDW *A4++,A24"); 
   	asm(" LDW *A4++,A25");   asm(" LDW *A4++,A26");   asm(" LDW *A4++,A27"); 
   	asm(" LDW *A4++,A28");   asm(" LDW *A4++,A29");   asm(" LDW *A4++,A30"); 
   	asm(" LDW *A4++,A31"); 
   
   /* Copy into B Registers */
	asm(" LDW *A4++,B16");   asm(" LDW *A4++,B17");   asm(" LDW *A4++,B18"); 
   	asm(" LDW *A4++,B19");   asm(" LDW *A4++,B20");   asm(" LDW *A4++,B21"); 
   	asm(" LDW *A4++,B22");   asm(" LDW *A4++,B23");   asm(" LDW *A4++,B24"); 
   	asm(" LDW *A4++,B25");   asm(" LDW *A4++,B26");   asm(" LDW *A4++,B27"); 
   	asm(" LDW *A4++,B28");   asm(" LDW *A4++,B29");   asm(" LDW *A4++,B30"); 
}

/******************************************************************************
* Function : end_test(int32 result)
* 
* Description :   
*               
*
* Inputs: int32 result
*
* Returns: None
******************************************************************************/
void end_test(int result)
{
    NRP = (result == PASS ? 0xabcdabcd : 0xdeaddead);

    // Point of no return.
    while (1) {
        ;
    }
}



/*****************************************************************************/
/*                       End of val_util.c file                              */
/*****************************************************************************/
