/*****************************************************************************\
*           TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION           
*                                                                            
*  Property of Texas Instruments 
*  For  Unrestricted  Internal  Use  Only 
*  Unauthorized reproduction and/or distribution is strictly prohibited.  
*  This product is protected under copyright law and trade secret law 
*  as an unpublished work.  
*  Created 2004, (C) Copyright 2003 Texas Instruments.  All rights reserved.
*------------------------------------------------------------------------------
*  Filename       : vcp2_util.c
*  Description    : Utility functions for the VCP2 module
\*****************************************************************************/

#include <ti/csl/csl.h>
#include <val_util.h>
#include <ti/csl/csl_vcp2.h>
Uint32 *profilePtr; 
Int32 vcpCheckResults(Uint32 *actual, Uint32 *reference, Uint32 size);
/****************************************************************************\
 * vcpCheckResults: Verify that the hard decisions and output parameters sent*
 * by the VCP are correct. If the hard decisions are not correct, the index *
 * of the first incorrect value is returned. If all values are correct then *
 * a 0 is returned.                                 *
 \****************************************************************************/
Int32 vcpCheckResults(Uint32 *actual, Uint32 *reference, Uint32 size)
{
    Uint32 i;
    Uint32 mismatch=0;
    Uint32 numWords = size;

    for (i=0; i<numWords; i++) {
        if (actual[i]!=reference[i]) {
            mismatch++;
            VAL_TRACE(0xDEAD1000);
            VAL_TRACE(i);
            VAL_TRACE(0xDEAD1001);
            VAL_TRACE(actual[i]); 
            VAL_TRACE(actual); 
            VAL_TRACE(0xDEAD1002);
            VAL_TRACE(reference[i]);
            break;
        } /* end if actual != reference */
    } /* end for i */

    if ((!mismatch) && (size & 1)) {
        if ((short)actual[i] != (short)reference[i]) 
        {
            mismatch++;
            VAL_TRACE(0xDEAD2000); 
            VAL_TRACE(i);
            VAL_TRACE(0xDEAD2001);
            VAL_TRACE(actual[i]); 
            VAL_TRACE(0xDEAD2002);
            VAL_TRACE(reference[i]);            
        }

    } /* end if */

    if (mismatch) 
    {    
        return(i+1); /* return index for 1st error that occured. */
        /* Index will range from 1 to framelength   */
    }
    else
    {
        //return(PASS);      /* no error */
        return 0;            /* no error */
    }

} /* end checkResults() */
/****************************************************************************\
 * CalcTimeStamp: Calculate the time between start of timer and Stop of Timer*
 \****************************************************************************/
void CalcTimeStamp(Uint32 TimerStartLow, 
        Uint32 TimerStartHigh,
        Uint32 TimerStopLow,
        Uint32 TimerStopHigh
        )
{
    Uint32 TimerCntHigh, TimerCntLow;

    TimerCntHigh = TimerStopHigh - TimerStartHigh;

    if(TimerStartLow < TimerStopLow)
    {
        TimerCntLow = TimerStopLow - TimerStartLow;
    } 
    else 
    {
        TimerCntLow = (0xFFFFFFFF - TimerStartLow) + TimerStopLow;
        TimerCntHigh = TimerCntHigh - 1;
    }

    *profilePtr++ = TimerCntHigh;
    *profilePtr++ = TimerCntLow;
}     

/******************************************************************************\
 * End of vcp2_util.c
 \******************************************************************************/
void VcpCslCompat (VCP2_Params * restrict ipConfigParams, 
        VCP2_Params * restrict opConfigParams
        )
{
    Uint16 TemptraceBackEn;
    TemptraceBackEn = ipConfigParams->traceBackEn;
    opConfigParams->traceBackEn = ipConfigParams->traceBackIndex;
    opConfigParams->traceBackIndex = TemptraceBackEn;
    opConfigParams->bmBuffLen = ipConfigParams->bmBuffLen-1;  
    opConfigParams->decBuffLen = ipConfigParams->decBuffLen-1;

    opConfigParams->rate = ipConfigParams->rate;
    opConfigParams->constLen = ipConfigParams->constLen;
    opConfigParams->poly0 = ipConfigParams->poly0;
    opConfigParams->poly1 = ipConfigParams->poly1;
    opConfigParams->poly2 = ipConfigParams->poly2;
    opConfigParams->poly3 = ipConfigParams->poly3;
    opConfigParams->yamTh = ipConfigParams->yamTh;
    opConfigParams->frameLen = ipConfigParams->frameLen;
    opConfigParams->relLen = ipConfigParams->relLen;
    opConfigParams->convDist = ipConfigParams->convDist;
    opConfigParams->outOrder = ipConfigParams->outOrder;
    opConfigParams->minSm = ipConfigParams->minSm;
    opConfigParams->maxSm = ipConfigParams->maxSm;
    opConfigParams->stateNum = ipConfigParams->stateNum;
    opConfigParams->traceBack = ipConfigParams->traceBack;
    opConfigParams->readFlag = ipConfigParams->readFlag;
    opConfigParams->decision = ipConfigParams->decision;
    opConfigParams->numBmFrames = opConfigParams->numBmFrames;
    opConfigParams->numDecFrames = opConfigParams->numDecFrames;


}  
