/***************************************************************************************
 * vusrLoopBoot.c
 *
 *  Simple program to test the VUSR boot in loopback. 
 *
 *  Here we assume that the base address of the VUSR window has been mapped
 *  to core 0s L2. The boot code does this by default, but of course
 *  it can be changed by the other side of the vusr.
 *
 ***************************************************************************************/


#pragma DATA_ALIGN(tcode, 16)
unsigned int tcode[] =  {

#ifdef _BIG_ENDIAN

    0x220101e3,     /* mov r0, 0x1122 */
 	0xfeffffea,     /* branch to me   */
  	0x00000000,
  	0x00000000,
    0x00000000

#else

    0xe3010122,     /* mov r0, 0x1122 */
 	0xeafffffe,     /* branch to me   */
  	0x00000000,
  	0x00000000,
    0x00000000

#endif

};


#pragma DATA_ALIGN(magicWrite, 16)
unsigned int magicWrite;

/* The port value can be modified run time during the test */
int port = PORT;

#define CODE_START       0x0c000000  /* Must be a global address */

/* Since gem is writing the ARM start address need to swap for big endian */
#ifdef _BIG_ENDIAN
 #define WRITE_CODE_START   (  (((CODE_START >> 24) & 0xff) <<  0)   |  \
                               (((CODE_START >> 16) & 0xff) <<  8)   |  \
                               (((CODE_START >>  8) & 0xff) << 16)   |  \
                               (((CODE_START >>  0) & 0xff) << 24)   )

#else
 #define WRITE_CODE_START   CODE_START
#endif


unsigned int code_start_vusr[] = { 0x40000000, 0x28000000 }; /* the VUSR memory windows for each port */
unsigned int vusr_regs_base[]  = { 0x21400000, 0x21400100 }; /* the VUSR ports */

extern cregister unsigned int DNUM;

volatile unsigned int control;
volatile unsigned int status;

volatile unsigned int vlocal;
volatile unsigned int vvusr;

volatile unsigned int remoteStatus;
volatile unsigned int remoteControl;
volatile unsigned int remoteInt;

volatile unsigned int secStatusReg;

void testDone(void);

void main (void)
{ 
    unsigned int *sAddr;
    unsigned int *dAddr;
    volatile int i;
    unsigned int v;


    control = *((unsigned int *)(vusr_regs_base[port] + 0x4));
    status  = *((unsigned int *)(vusr_regs_base[port] + 0x8));


    /* Sanity check the interface */
    *((unsigned int *)0x10800000) = 0x1234abcd;
    vlocal = *((unsigned int *)0x10800000);
    vvusr = *((unsigned int *)code_start_vusr[port]);

    
    /* Poke to tx overlay control to setup the tx mask */
    *((unsigned int *)(vusr_regs_base[port] + 0x1c)) = 7;  /* for nyquist, should also work for shannon */


    /* Form the global source address of the source data */
    sAddr = (unsigned int *)((1 << 28) | (DNUM << 24) | (unsigned int)tcode);


    /* Setup segment index 0 to point to the code */
    *((unsigned int *)(vusr_regs_base[port] + 0x38)) = 0;  /* use seg index 0 */
    *((unsigned int *)(vusr_regs_base[port] + 0x3c)) = (CODE_START & 0xffc00000) | 0x15;

    dAddr = (unsigned int *)(code_start_vusr[port] + (CODE_START & 0x3fffff));


    for (i = 0; i < sizeof(tcode)/sizeof(unsigned int); i++)
        dAddr[i] = sAddr[i];

  	/* Poke the VUSR remote intlocal bit in the remote control reg */
  	*((unsigned int *)(vusr_regs_base[port] + 0x84)) = 0x3f80;
    remoteControl = *((unsigned int *)(vusr_regs_base[port] + 0x84));

  	/* Poke the VUSR remote interrupt. This interrupt shouldnt do anything since
  	 * there is nothing in the magic address. It will verify that the interrupt
  	 * cleanup is working correctly and the second interrupt will be seen. */
  	*((unsigned int *)(vusr_regs_base[port] + 0x94)) = 1;
    remoteInt = *((unsigned int *)(vusr_regs_base[port] + 0x94));

    for (i = 0; i < 1000; i++); /* some delay while core 0 runs through the interrupt cleanup */


    /* Clear out the interrupt just generated */
  	*((unsigned int *)(vusr_regs_base[port] + 0x90)) = 1;
    
  	v = *((unsigned int *)(vusr_regs_base[port] + 0x8c));
    if ((v & 0x80000000) == 0) 
  	    *((unsigned int *)(vusr_regs_base[port] + 0x8c)) = v;


    /* Now write the code start address to the magic address so the
     * boot code knows where to go after an interrupt */
    *((unsigned int *)(vusr_regs_base[port] + 0x3c)) = (BOOT_MAGIC & 0xffc00000) | 0x15;

    dAddr = (unsigned int *)(code_start_vusr[port] + (BOOT_MAGIC & 0x3fffff));
    *dAddr = WRITE_CODE_START;


  	/* Poke the VUSR remote interrupt */
  	*((unsigned int *)(vusr_regs_base[port] + 0x94)) = 1;
    remoteInt = *((unsigned int *)(vusr_regs_base[port] + 0x94));

    for (i = 0; i < 1000; i++); /* some delay while core 0 runs through the interrupt cleanup */

    /* Clear out the interrupt just generated */
  	*((unsigned int *)(vusr_regs_base[port] + 0x90)) = 1;
    
  	v = *((unsigned int *)(vusr_regs_base[port] + 0x8c));
    if ((v & 0x80000000) == 0) 
  	    *((unsigned int *)(vusr_regs_base[port] + 0x8c)) = v;

    testDone();
  	
}
  	

void testDone(void)
{
    for (;;);
}


