OUTPUT_FORMAT("elf32-msp430")
OUTPUT_ARCH("msp430")

MEMORY {
  sfr              : ORIGIN = 0x0000, LENGTH = 0x0010 /* END=0x0010, size 16 */
  peripheral_8bit  : ORIGIN = 0x0010, LENGTH = 0x00f0 /* END=0x0100, size 240 */
  peripheral_16bit : ORIGIN = 0x0100, LENGTH = 0x0100 /* END=0x0200, size 256 */
  ram (wx)         : ORIGIN = 0x0200, LENGTH = 0x0200 /* END=0x0400, size 512 */
  infomem          : ORIGIN = 0x1000, LENGTH = 0x0100 /* END=0x1100, size 256 as 4 64-byte segments */
  infod            : ORIGIN = 0x1000, LENGTH = 0x0040 /* END=0x1040, size 64 */
  infoc            : ORIGIN = 0x1040, LENGTH = 0x0040 /* END=0x1080, size 64 */
  infob            : ORIGIN = 0x1080, LENGTH = 0x0040 /* END=0x10c0, size 64 */
  infoa            : ORIGIN = 0x10c0, LENGTH = 0x0040 /* END=0x1100, size 64 */
  rom (rx)         : ORIGIN = 0xe000, LENGTH = 0x1fe0 /* END=0xffe0, size 8160 */
  boot1 (rx)       : ORIGIN = 0xe000, LENGTH = 0x0200
  boot2 (rx)       : ORIGIN = 0xfa00, LENGTH = 0x0600
  vectors          : ORIGIN = 0xffe0, LENGTH = 0x0020 /* END=0x10000, size 32 as 16 2-byte segments */
  /* Remaining banks are absent */
  bsl              : ORIGIN = 0x0000, LENGTH = 0x0000
  ram2 (wx)        : ORIGIN = 0x0000, LENGTH = 0x0000
  ram_mirror (wx)  : ORIGIN = 0x0000, LENGTH = 0x0000
  usbram (wx)      : ORIGIN = 0x0000, LENGTH = 0x0000
  far_rom          : ORIGIN = 0x00000000, LENGTH = 0x00000000
}
REGION_ALIAS("REGION_TEXT", boot2);
REGION_ALIAS("REGION_DATA", ram);
REGION_ALIAS("REGION_FAR_ROM", far_rom);
PROVIDE (__info_segment_size = 0x40);
PROVIDE (__infod = 0x1000);
PROVIDE (__infoc = 0x1040);
PROVIDE (__infob = 0x1080);
PROVIDE (__infoa = 0x10c0);

__IE1 = 0x0000;
__IFG1 = 0x0002;
__IE2 = 0x0001;
__IFG2 = 0x0003;
__ADC10DTC0 = 0x0048;
__ADC10DTC1 = 0x0049;
__ADC10AE0 = 0x004A;
__ADC10CTL0 = 0x01B0;
__ADC10CTL1 = 0x01B2;
__ADC10MEM = 0x01B4;
__ADC10SA = 0x01BC;
__DCOCTL = 0x0056;
__BCSCTL1 = 0x0057;
__BCSCTL2 = 0x0058;
__BCSCTL3 = 0x0053;
__FCTL1 = 0x0128;
__FCTL2 = 0x012A;
__FCTL3 = 0x012C;
__P1IN = 0x0020;
__P1OUT = 0x0021;
__P1DIR = 0x0022;
__P1IFG = 0x0023;
__P1IES = 0x0024;
__P1IE = 0x0025;
__P1SEL = 0x0026;
__P1SEL2 = 0x0041;
__P1REN = 0x0027;
__P2IN = 0x0028;
__P2OUT = 0x0029;
__P2DIR = 0x002A;
__P2IFG = 0x002B;
__P2IES = 0x002C;
__P2IE = 0x002D;
__P2SEL = 0x002E;
__P2SEL2 = 0x0042;
__P2REN = 0x002F;
__P3IN = 0x0018;
__P3OUT = 0x0019;
__P3DIR = 0x001A;
__P3SEL = 0x001B;
__P3SEL2 = 0x0043;
__P3REN = 0x0010;
__TA0IV = 0x012E;
__TA0CTL = 0x0160;
__TA0CCTL0 = 0x0162;
__TA0CCTL1 = 0x0164;
__TA0CCTL2 = 0x0166;
__TA0R = 0x0170;
__TA0CCR0 = 0x0172;
__TA0CCR1 = 0x0174;
__TA0CCR2 = 0x0176;
__TA1IV = 0x011E;
__TA1CTL = 0x0180;
__TA1CCTL0 = 0x0182;
__TA1CCTL1 = 0x0184;
__TA1CCTL2 = 0x0186;
__TA1R = 0x0190;
__TA1CCR0 = 0x0192;
__TA1CCR1 = 0x0194;
__TA1CCR2 = 0x0196;
__UCA0CTL0 = 0x0060;
__UCA0CTL1 = 0x0061;
__UCA0BR0 = 0x0062;
__UCA0BR1 = 0x0063;
__UCA0MCTL = 0x0064;
__UCA0STAT = 0x0065;
__UCA0RXBUF = 0x0066;
__UCA0TXBUF = 0x0067;
__UCA0ABCTL = 0x005D;
__UCA0IRTCTL = 0x005E;
__UCA0IRRCTL = 0x005F;
__UCB0CTL0 = 0x0068;
__UCB0CTL1 = 0x0069;
__UCB0BR0 = 0x006A;
__UCB0BR1 = 0x006B;
__UCB0I2CIE = 0x006C;
__UCB0STAT = 0x006D;
__UCB0RXBUF = 0x006E;
__UCB0TXBUF = 0x006F;
__UCB0I2COA = 0x0118;
__UCB0I2CSA = 0x011A;
__WDTCTL = 0x0120;
__CALDCO_16MHZ = 0x10F8;
__CALBC1_16MHZ = 0x10F9;
__CALDCO_12MHZ = 0x10FA;
__CALBC1_12MHZ = 0x10FB;
__CALDCO_8MHZ = 0x10FC;
__CALBC1_8MHZ = 0x10FD;
__CALDCO_1MHZ = 0x10FE;
__CALBC1_1MHZ = 0x10FF;

SECTIONS
{
  /* Read-only sections, merged into text segment.  */
  .hash            : { *(.hash)          }
  .dynsym          : { *(.dynsym)        }
  .dynstr          : { *(.dynstr)        }
  .gnu.version     : { *(.gnu.version)   }
  .gnu.version_d   : { *(.gnu.version_d) }
  .gnu.version_r   : { *(.gnu.version_r) }
  .rel.init      : { *(.rel.init)  }
  .rela.init     : { *(.rela.init) }
  .rel.fini      : { *(.rel.fini)  }
  .rela.fini     : { *(.rela.fini) }
  .rel.text      : { *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*)        }
  .rela.text     : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)     }
  .rel.rodata    : { *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*)    }
  .rela.rodata   : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }
  .rel.data      : { *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*)        }
  .rela.data     : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)     }
  .rel.bss       : { *(.rel.bss .rel.bss.* .rel.gnu.linkonce.b.*)          }
  .rela.bss      : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)       }
  .rel.ctors     : { *(.rel.ctors)  }
  .rela.ctors    : { *(.rela.ctors) }
  .rel.dtors     : { *(.rel.dtors)  }
  .rela.dtors    : { *(.rela.dtors) }
  .rel.got       : { *(.rel.got)    }
  .rela.got      : { *(.rela.got)   }
  .rel.plt       : { *(.rel.plt)    }
  .rela.plt      : { *(.rela.plt)   }
  .trampoline :
  {
     *(.trampoline)
     __trampoline_end = .;
     shared/i2c.o(.text)
  } > boot1
  .text :
  {
     . = ALIGN(2);
     KEEP(*(.init .init.*))
     KEEP(*(.init0))  /* Start here after reset.               */
     KEEP(*(.init1))  /* User definable.                       */
     KEEP(*(.init2))  /* Initialize stack.                     */
     KEEP(*(.init3))  /* Initialize hardware, user definable.  */
     KEEP(*(.init4))  /* Copy data to .data, clear bss.        */

     . = ALIGN(2);
     __init5_start = . ;
     *(.init5)
     __init5_end = . ;

     KEEP(*(.init6))  /* C++ constructors.                     */
     KEEP(*(.init7))  /* User definable.                       */
     KEEP(*(.init8))  /* User definable.                       */
     KEEP(*(.init9))  /* Call main().                          */
     KEEP(*(.fini9))  /* Falls into here after main(). User definable.  */
     KEEP(*(.fini8))  /* User definable.                           */
     KEEP(*(.fini7))  /* User definable.                           */
     KEEP(*(.fini6))  /* C++ destructors.                          */
     KEEP(*(.fini5))  /* User definable.                           */
     KEEP(*(.fini4))  /* User definable.                           */
     KEEP(*(.fini3))  /* User definable.                           */
     KEEP(*(.fini2))  /* User definable.                           */
     KEEP(*(.fini1))  /* User definable.                           */
     KEEP(*(.fini0))  /* Infinite loop after program termination.  */
     KEEP(*(.fini .fini.*))
     . = ALIGN(2);
     __ctors_start = . ;
     KEEP(*(.ctors))
     __ctors_end = . ;
     __dtors_start = . ;
     KEEP(*(.dtors))
     __dtors_end = . ;
     . = ALIGN(2);
    *(.text .text.* .gnu.linkonce.t.*)
     . = ALIGN(2);
  }  > REGION_TEXT
  .rodata   :
  {
     . = ALIGN(2);
    *(.rodata .rodata.* .gnu.linkonce.r.*)
     . = ALIGN(2);
  }  > REGION_TEXT
   _etext = .; /* Past last read-only (loadable) segment */
  .vam :
  {
     . = ALIGN(2);
     PROVIDE (__vam_start = .) ;
     . += 32;
  } > REGION_DATA
  .data   :
  {
     . = ALIGN(2);
     PROVIDE (__data_start = .) ;
    *(.data .data.* .gnu.linkonce.d.*)
     . = ALIGN(2);
     _edata = . ;  /* Past last read-write (loadable) segment */
  }  > REGION_DATA AT > REGION_TEXT
   PROVIDE (__data_load_start = LOADADDR(.data) );
   PROVIDE (__data_size = SIZEOF(.data) );
  .bss   :
  {
     PROVIDE (__bss_start = .) ;
    *(.bss .bss.*)
    *(COMMON)
     . = ALIGN(2);
     PROVIDE (__bss_end = .) ;
  }  > REGION_DATA
   PROVIDE (__bss_size = SIZEOF(.bss) );
  .noinit   :
  {
     PROVIDE (__noinit_start = .) ;
    *(.noinit .noinit.*)
     . = ALIGN(2);
     PROVIDE (__noinit_end = .) ;
  }  > REGION_DATA
   . = ALIGN(2);
   _end = . ;   /* Past last write (loadable) segment */
  .infomem   :
  {
     *(.infomem)
     . = ALIGN(2);
  }  > infomem
  .infomemnobits   :
  {
    *(.infomemnobits)
     . = ALIGN(2);
    *(.infomemnobits.*)
  }  > infomem
  .infoa   :
  {
    *(.infoa .infoa.*)
  }  > infoa
  .infob   :
  {
    *(.infob .infob.*)
  }  > infob
  .infoc   :
  {
    *(.infoc .infoc.*)
  }  > infoc
  .infod   :
  {
    *(.infod .infod.*)
  }  > infod
  .vectors  :
  {
     PROVIDE (__vectors_start = .) ;
    KEEP(*(.vectors*))
     _vectors_end = . ;
  }  > vectors
  .fartext :
  {
     . = ALIGN(2);
    *(.fartext)
     . = ALIGN(2);
    *(.fartext.*)
     _efartext = .;
  }  > REGION_FAR_ROM
  /* Stabs for profiling information*/
  .profiler 0 : { *(.profiler) }
  /* Stabs debugging sections.  */
  .stab 0 : { *(.stab) }
  .stabstr 0 : { *(.stabstr) }
  .stab.excl 0 : { *(.stab.excl) }
  .stab.exclstr 0 : { *(.stab.exclstr) }
  .stab.index 0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }
  .comment 0 : { *(.comment) }
  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */
  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }
  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }
  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }
  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info) *(.gnu.linkonce.wi.*) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }
  /* DWARF 3 */
  .debug_pubtypes 0 : { *(.debug_pubtypes) }
  .debug_ranges   0 : { *(.debug_ranges) }
   PROVIDE (__stack = ORIGIN(ram) + LENGTH(ram));
   PROVIDE (__data_start_rom = _etext);
   PROVIDE (__data_end_rom   = _etext + SIZEOF (.data));
}
