/******************************************************************************
 *
 * Default Linker Command file for the Texas Instruments TM4C1237H6PZ
 *
 * This is derived from revision 10691 of the TivaWare Library.
 *
 *****************************************************************************/

--retain=g_pfnVectors
--retain=.persistent

#define FLASH_START   0x00000000
#define FLASH_SIZE    0x00040000
#define FLASH_END     (FLASH_START + FLASH_SIZE -1)
#define RAM_START     0x20000000
#define RAM_SIZE      0x00008000
#define RAM_END       (RAM_START + RAM_SIZE -1)
#define ROM_START     0x01000000
#define ROM_END       0x010087FF
#define ROM_SIZE      (ROM_END - ROM_START + 1)


#define VESTA_SIZE    (0x00008000 - CRCDATA_SIZE)
#define CRCDATA_SIZE  (SIZE(CRCDATA) /*+ SIZE(CRCDATA2)*/)

MEMORY
{
    CRCDATA (R)     : origin = 0x3FFFC, length = 0x00000004, fill = 0xFFFFFFFF
    FLASH (RX)      : origin = FLASH_START, length = START(CRCDATA)-FLASH_START, fill = 0xFFFFFFFF

    SRAM (RWX)      : origin = RAM_START, length = 0x00007F00, vfill = 0x00000000
    PERSISTENT (RW) : origin = 0x20007F00, length = 0x00000100
}

/* The following command line options are set as part of the CCS project.    */
/* If you are building using the command line, or for some reason want to    */
/* define them here, you can uncomment and modify these lines as needed.     */
/* If you are using CCS for building, it is probably better to make any such */
/* modifications in your CCS project and leave this file alone.              */
/*                                                                           */
/* --heap_size=0                                                             */
/* --stack_size=256                                                          */
/* --library=rtsv7M4_T_le_eabi.lib                                           */

/* Section allocation in memory */

SECTIONS
{
    .intvecs    :   > 0x00000000
    .text       :   > FLASH
    .const      :   > FLASH
    .cinit      :   > FLASH
    .pinit      :   > FLASH
    .init_array : > FLASH
    .crcval1    :   >CRCDATA

    //.vtable :   > 0x20000000
    .stack      : > RAM_START /* fill = 0xFEFEFEFE */
    //.vtable :   > SRAM
    .sysmem     : > SRAM (HIGH) { __SYSMEM_START = .; }
    .data       : > SRAM (HIGH) { __DATA_START = .; }
    .bss        : > SRAM (HIGH) { __BSS_START = .; }
    .persistent : > PERSISTENT, type=NOINIT
}


__STACK_TOP = __BSS_START - 0x08;
__STACK_END = __STACK_TOP + 0x04;
__STACK_SIZE = __STACK_TOP - RAM_START;

__CRCDATA_START = FLASH_END+1-CRCDATA_SIZE;
__ROM_START = ROM_START;
__ROM_END = ROM_END;
__ROM_SIZE = ROM_SIZE;
__CRCVAL1_START = START(CRCDATA);
__PERSISTENT_START = START(PERSISTENT);
__FLASH_START = START(FLASH);
__FLASH_SIZE = START(CRCDATA)-FLASH_START;
__FLASH_END = __FLASH_START + __FLASH_SIZE - 1;
__RAM_START = START(SRAM);
__RAM_SIZE = RAM_SIZE;
__RAM_END = __RAM_START + __RAM_SIZE - 1;
