/*
 * Blood_Pressure.c
 *
 *  Created on: Oct 20, 2015
 *      Author: ShitijAvlani
 */


#include <stdint.h>
#include <inc/tm4c123gh6pm.h>
#include <Blood_Pressure.h>


void BP_Init (void)
{

	//Activate UART5
	SYSCTL_RCGCUART_R |= (1<<5);
	//Activate Port E
	SYSCTL_RCGCGPIO_R |= (1<<4);

	//Disable UART5
	UART5_CTL_R &= ~(0x00000001);
	//IBRD = int(16,000,000/(16*9600)) = int(104.16667)
	UART5_IBRD_R = 104;
	//FBRD = round(0/16667 * 64) = 11
	UART5_FBRD_R = 11;
	//8 bit, 0 parity bits, 1 stop bit, Enable FIFOs
	UART5_LCRH_R = ((1<<6) | (1<<5) | (1<<4));
	//Enable UART5
	UART5_CTL_R |= (0x00000001);


	//Enable Alternate Function on PE.4, PE.5
	GPIO_PORTE_AFSEL_R |= ((1<<4) | (1<<5));
	//Configure PE.4, PE.5 as UART5
	GPIO_PORTE_DEN_R |= ((1<<4) | (1<<5));
	GPIO_PORTE_PCTL_R = ((GPIO_PORTE_PCTL_R & 0xFF00FFFF) + 0x00110000);
	//Disable Analog on PE.4, PE.5
	GPIO_PORTE_AMSEL_R &= ~((1<<4) | (1<<5));

}


void Read_BP ( unsigned char *reading)
{

	//Wait till device sends enter key character
	int i = 0;
	while(i < 15)
	{
		*(reading++) = readCharacter();
		i++;
	}

}


unsigned char readCharacter (void)
{

	//Wait until RX FIFO has data
	while((UART5_FR_R & (1<<4)) != 0);
	return((unsigned char)(UART5_DR_R&0xFF));

}
