/*
 * GT511C3.c
 *
 *  Created on: Oct 12, 2015
 *      Author: ShitijAvlani
 */


#include <GT511C3.h>
#include <stdbool.h>
#include <stdint.h>
#include <inc/tm4c123gh6pm.h>

#define SET_AND_SUMADD(idx,val) sendbuf[idx]=((unsigned char)(val));sum += sendbuf[idx]


int  Init(void)
{

	// activate UART3
	SYSCTL_RCGCUART_R |= (1<<3);
	// activate port C
	SYSCTL_RCGCGPIO_R |= (1<<2);

	// disable UART
	UART3_CTL_R &= ~(0x00000001);
	// IBRD = int(16,000,000 / (16 * 9,600)) = int(104.16667)
	UART3_IBRD_R = 104;
	// FBRD = round(0.16667 * 64) = 11
	UART3_FBRD_R = 11;
	// 8 bit, no parity bits, one stop, FIFOs
	UART3_LCRH_R = ((1<<6) | (1<<5) | (1<<4));
	// enable UART
	UART3_CTL_R |= (0x00000001);

	// enable alt funct on PC.7 PC.6
	GPIO_PORTC_AFSEL_R |= ((1<<7) | (1<<6));
	GPIO_PORTC_DEN_R |= ((1<<7) | (1<<6));
	// configure PC.6, PC.7 as UART3
	GPIO_PORTC_PCTL_R = ((GPIO_PORTC_PCTL_R & 0x00FFFFFF) + 0x11000000);
	// disable analog on PC.6, PC.7
	GPIO_PORTC_AMSEL_R &= ~((1<<7) | (1<<6));

    ClearLine();

    return 0;

}

int  SendCommand(unsigned long Parameter,unsigned short Command)
{
    unsigned char sendbuf[12];
    unsigned short sum = 0;
    int idx = 0;
    int i;

    SET_AND_SUMADD(idx,0x55); idx++;
    SET_AND_SUMADD(idx,0xAA); idx++;
    SET_AND_SUMADD(idx,0x01); idx++;
    SET_AND_SUMADD(idx,0x00); idx++;
    SET_AND_SUMADD(idx,Parameter & 0xff); idx++;
    SET_AND_SUMADD(idx,(Parameter >> 8) & 0xFF); idx++;
    SET_AND_SUMADD(idx,(Parameter >> 16) & 0xFF); idx++;
    SET_AND_SUMADD(idx,(Parameter >> 24) & 0xFF); idx++;
    SET_AND_SUMADD(idx,Command & 0xFF); idx++;
    SET_AND_SUMADD(idx,(Command >> 8) & 0xFF); idx++;
    sendbuf[idx] = sum & 0xFF; idx++;
    sendbuf[idx] = (sum >> 8) & 0xFF; idx++;

    for(i = 0;i < idx;i++){
        while(!writeable());
        putc(sendbuf[i]);
    }
    return 0;
}

int  RecvResponse(unsigned long *Parameter,unsigned short *Response)
{
    const unsigned char fixedbuf[4] = { 0x55,0xAA,0x01,0x00 };
    unsigned char buf[12];
    unsigned short sum = 0;
    int i;

    *Parameter = 0;
    *Response = CMD_Nack;

    for(i = 0;i < sizeof(buf);i++){
        while(!readable());
        buf[i] = getc();
        if(i < 9){
            sum += buf[i];
        }
        if(i < 4){
            if(buf[i] != fixedbuf[i]){
                return -1;
            }
        }
    }
    if(buf[10] != (sum & 0xff))
        return -2;
    if(buf[11] != ((sum >> 8) & 0xff))
        return -2;

    *Parameter =  buf[7];
    *Parameter = (*Parameter << 8) | buf[6];
    *Parameter = (*Parameter << 8) | buf[5];
    *Parameter = (*Parameter << 8) | buf[4];

    *Response = buf[9];
    *Response = (*Response << 8) | buf[8];

    return 0;
}

int  RecvData(unsigned char *data,unsigned long size)
{
    const unsigned char fixedbuf[4] = { 0x5A,0xA5,0x01,0x00 };
    unsigned short sum = 0;
    int i;

    for(i = 0;i < size;i++){
        while(!readable());
        *(data + i) = getc();
        if(i < (size-2)){
            sum += *(data + i);
        }
        if(i < 4){
            if(*(data + i) != fixedbuf[i]){
                return -1;
            }
        }
    }
    if(*(data + size - 2) != (sum & 0xff))
        return -2;
    if(*(data + size - 1) != ((sum >> 8) & 0xff))
        return -2;
    return 0;
}

int SendData (unsigned char *data)
{
	const unsigned char fixedbuf[4] = { 0x5A,0xA5,0x01,0x00 };
	unsigned short sum = 0;
	int i;

	for(i = 0; i < 4; i++)
	{
		while(!writeable());
	    putc(fixedbuf[i]);
	    sum += fixedbuf[i];
	}

	while(*data)
	{
		while(!writeable());
		putc(*data);
		sum += *data;
		data++;
	}

	while(!writeable());
	putc(sum & 0xFF);
	while(!writeable());
	putc((sum >> 8) & 0xFF);

	return 0;
}

int  SendRecv(unsigned short Command,unsigned long *Parameter,unsigned short *Response)
{
    int sts;
    if((sts = SendCommand(*Parameter,Command)) == 0){
        *Parameter = 0;
        if((sts = RecvResponse(Parameter,Response)) != 0){
            *Response = CMD_Nack;
            *Parameter = NACK_IO_ERR;
        }
    }
    if(*Response == CMD_Nack){
        LastError = *Parameter;
    }
    return sts;
}

int  ClearLine(void)
{
    while(readable()){
        (void)getc();
    }
    return 0;
}

int  Open(void)
{
    unsigned long Parameter = 0;
    unsigned short Response = 0;
    int sts = -1;

    if((sts = Init()) != 0)
        return -1;

    sts = SendRecv(CMD_Open,&Parameter,&Response);
    if((sts != 0) || (Response != CMD_Ack)){
        return -1;
    }
    return sts;
}

int  WaitPress(int press)
{
    while(IsPress() != press);
    return 0;
}

int  CmosLed(int onoff)
{
    unsigned long Parameter = onoff & 1;
    unsigned short Response = 0;
    int sts = 0;

    sts = SendRecv(CMD_CmosLed,&Parameter,&Response);
    if((sts != 0) || (Response != CMD_Ack)){
        return -1;
    }
    return 0;
}

int  IsPress(void)
{
    unsigned long Parameter = 0;
    unsigned short Response = 0;
    int sts = 0;
    sts = SendRecv(CMD_IsPressFinger,&Parameter,&Response);
    if((sts != 0) || (Response != CMD_Ack))
        return 0;
    if(Parameter != 0)
        return 0;
    return 1;
}

int  Capture(int best)
{
    unsigned long Parameter = best;
    unsigned short Response = 0;
    int sts = 0;

    sts = SendRecv(CMD_CaptureFinger,&Parameter,&Response);
    if((sts != 0) || (Response != CMD_Ack))
        return -1;
    return 0;
}

int  Enroll_N(int N)
{
    unsigned long Parameter = 0;
    unsigned short Response = 0;
    int sts = 0;
    enum Command cmd;

    switch(N){
        default:
        case 1: cmd = CMD_Enroll1; break;
        case 2: cmd = CMD_Enroll2; break;
        case 3: cmd = CMD_Enroll3; break;
    }
    sts = SendRecv(cmd,&Parameter,&Response);
    if((sts != 0) || (Response != CMD_Ack))
        return -1;
    return 0;
}

int  Identify(void)
{
    unsigned long Parameter = 0;
    unsigned short Response = 0;
    int sts = 0;

    sts = SendRecv(CMD_Identify,&Parameter,&Response);
    if((sts != 0) || (Response != CMD_Ack))
        return -1;
    return Parameter;
}

int  Enroll(int ID,int (*progress)(int status,char *msg))
{
    unsigned long Parameter = 0;
    unsigned short Response = 0;
    int sts = 0;

    CmosLed(1);

    while(1){
        if((sts = (*progress)(1,"EnrollStart\n")) != 0)
            return -9999;
        Parameter = ID;
        sts = SendRecv(CMD_EnrollStart,&Parameter,&Response);
        if(sts != 0)
            return sts;
        if(Response != CMD_Ack)
            return -100;

        if((sts = (*progress)(0,"Remove finger\n")) != 0)
            return -9999;
        WaitPress(0);

        while(1){
            if((sts = (*progress)(10,"Press finger to Enroll (1st)\n")) != 0)
                return -9999;
            WaitPress(1);
            if(Capture(1) == 0)
                break;
        }

        if((sts = (*progress)(0,"Remove finger\n")) != 0)
            return -9999;
        if(Enroll_N(1) != 0)
            continue;
        WaitPress(0);

        while(1){
            if((sts = (*progress)(20,"Press finger to Enroll (2nd)\n")) != 0)
                return -9999;
            WaitPress(1);
            if(Capture(1) == 0)
                break;
        }

        if((sts = (*progress)(0,"Remove finger\n")) != 0)
            return -9999;
        if(Enroll_N(2) != 0)
            continue;
        WaitPress(0);

        while(1){
            if((sts = (*progress)(30,"Press finger to Enroll (3rd)\n")) != 0)
                return -9999;
            WaitPress(1);
            if(Capture(1) == 0)
                break;
        }

        if((sts = (*progress)(0,"Remove finger\n")) != 0)
            return -9999;
        if(Enroll_N(3) != 0)
            continue;
        WaitPress(0);

        if((sts = (*progress)(100,"Enroll OK\n")) != 0)
            return -9999;

        break;
    }

    return 0;

}

int  CheckEnrolled(int ID)
{
    unsigned long Parameter = ID;
    unsigned short Response = 0;
    int sts = 0;

    sts = SendRecv(CMD_CheckEnrolled,&Parameter,&Response);
    if((sts == 0) && (Response == CMD_Ack))
        return 0;  //This ID is enrolled
    return -1;
}

int  DeleteID(int ID)
{
    unsigned long Parameter = ID;
    unsigned short Response = 0;
    int sts = 0;

    sts = SendRecv(CMD_DeleteID,&Parameter,&Response);
    if((sts == 0) && (Response == CMD_Ack))
        return 0;
    return -1;
}

int DeleteAll(void)
{
	unsigned long Parameter = 0;
	unsigned short Response = 0;
	int sts = 0;

	sts = SendRecv(CMD_DeleteAll,&Parameter,&Response);
	if((sts == 0) && (Response == CMD_Ack))
		return 0;
	return -1;
}

int GetTemplate(int ID, unsigned char *template)
{
	unsigned long Parameter = ID;
	unsigned short Response = 0;
	int sts = 0;

	sts = SendRecv(CMD_GetTemplate,&Parameter,&Response);
	if((sts == 0) && (Response == CMD_Ack))
	{
		RecvData(template, 504);
		return 0;
	}
	return -1;
}

int SetTemplate(int ID, unsigned char *template)
{
	unsigned long Parameter = ID;
	unsigned short Response = 0;
	int sts = 0;

	sts = SendRecv(CMD_SetTemplate,&Parameter,&Response);
	if((sts == 0) && (Response == CMD_Ack))
	{
		SendData(template);
		sts = RecvResponse(&Parameter, &Response);
		if((sts == 0) && (Response == CMD_Ack))
			return 0;
	}
	return -1;
}

bool  writeable (void)
{

	if((UART3_FR_R & (1<<5)) == 0)
		return true;
	else
		return false;

}

void  putc (unsigned char data)
{

	UART3_DR_R = data;

}

bool  readable (void)
{

	if((UART3_FR_R & (1<<4)) == 0)
		return true;
	else
		return false;

}

unsigned char  getc (void)
{

	return((unsigned char)(UART3_DR_R & 0xFF));

}



