/*
 * SPO2.c
 *
 *  Created on: Oct 24, 2015
 *      Author: ShitijAvlani
 */


#include <stdint.h>
#include <math.h>
#include <analogRead.h>
#include <SPO2.h>

#define Absorbance(colour)	log10(colour / 4095)

float SPO2 (void)
{

	uint16_t red, ir;

	SPO2_Read(&red, &ir);

	float bloodOx = (113 - (28 * (Absorbance(red) / (Absorbance(ir) + Absorbance(red)))));

	if ((bloodOx <= 100) && (bloodOx !=85))
		return bloodOx;
	return -1;

}
